/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_SKYWALKER_GPIO_H__
#define __MAINBOARD_GOOGLE_SKYWALKER_GPIO_H__

#include <soc/gpio.h>

#define GPIO_IMU_INT_SCP_L			GPIO(GPIO00)
#define GPIO_LID_ACCEL_INT_SCP_L		GPIO(GPIO01)
#define GPIO_AP_SCP_GPIO02			GPIO(GPIO02)
#define GPIO_AP_SCP_GPIO03			GPIO(GPIO03)
#define GPIO_HP_INT_ODL				GPIO(GPIO04)
#define GPIO_EN_SPKR				GPIO(GPIO05)
#define GPIO_RST_SPKR_L				GPIO(GPIO06)
#define GPIO_USB3_HUB_RST_L			GPIO(GPIO07)
#define GPIO_SPKR_INT_ODL			GPIO(GPIO08)
#define GPIO_SAR_INT_ODL			GPIO(GPIO09)
#define GPIO_WWAN_RESET_L			GPIO(GPIO10)
#define GPIO_PEN_EJECT_OD			GPIO(GPIO11)
#define GPIO_EN_PWR_FP				GPIO(GPIO12)
#define GPIO_EDP_BL_EN_1V8			GPIO(GPIO13)
/* For !BOARD_GOOGLE_PADME */
#define GPIO_TCHSCR_REPORT_DISABLE		GPIO(GPIO14)
/* For BOARD_GOOGLE_PADME */
#define GPIO_EN_PP6000_MIPI_DISP		GPIO(GPIO14)
#define GPIO_TCHSCR_INT_1V8_ODL			GPIO(GPIO15)
#define GPIO_AP_WP_ODL				GPIO(GPIO16)
#define GPIO_EC_AP_DPOC_EN_ODL			GPIO(GPIO17)
#define GPIO_EN_PP3300_EDP_X			GPIO(DSI_LCM_RST)
#define GPIO_EC_AP_DP_HPD_L			GPIO(DP_TX_HPD)
#define GPIO_EDP_HPD_1V8			GPIO(EDP_TX_HPD)
#define GPIO_BL_PWM_1V8				GPIO(DISP_PWM0)
#define GPIO_CODEC_PWR_SOC_EN			GPIO(DISP_PWM1)
#define GPIO_UART_AP_TX_GSC_DBG_RX		GPIO(UART0_TXD)
#define GPIO_UART_GSC_DBG_TX_AP_RX		GPIO(UART0_RXD)
#define GPIO_AP_UART1_TXD			GPIO(UART1_TXD)
#define GPIO_AP_UART1_RXD			GPIO(UART1_RXD)
#define GPIO_AP_UART2_TXD			GPIO(UART2_TXD)
#define GPIO_AP_UART2_RXD			GPIO(UART2_RXD)
#define GPIO_AP_UART3_TXD			GPIO(UART3_TXD)
#define GPIO_AP_UART3_RXD			GPIO(UART3_RXD)
#define GPIO_AP_JTAG_TMS			GPIO(JTMS)
#define GPIO_AP_JTAG_TCK			GPIO(JTCK)
#define GPIO_AP_JTAG_TDI			GPIO(JTDI)
#define GPIO_AP_JTAG_TDO			GPIO(JTDO)
#define GPIO_AP_JTAG_TRST_L			GPIO(JTRST)
#define GPIO_AP_KPCOL0				GPIO(KPCOL0)
#define GPIO_AP_KPCOL1				GPIO(KPCOL1)
#define GPIO_AP_KPROW0				GPIO(KPROW0)
#define GPIO_AP_KPROW1				GPIO(KPROW1)
#define GPIO_PCIE_WLAN_WAKE_OBFF_1V8_ODL	GPIO(PCIE_WAKE_N)
#define GPIO_PCIE_WLAN_RST_1V8_L		GPIO(PCIE_PERESET_N)
#define GPIO_PCIE_WLAN_CLKREQ_1V8_ODL		GPIO(PCIE_CLKREQ_N)
#define GPIO_SCP_I2C_SENSOR_SCL_1V8		GPIO(SCP_SCL0)
#define GPIO_SCP_I2C_SENSOR_SDA_1V8		GPIO(SCP_SDA0)
#define GPIO_AP_SCP_I2C1_SCL			GPIO(SCP_SCL1)
#define GPIO_AP_SCP_I2C1_SDA			GPIO(SCP_SDA1)
#define GPIO_AP_I2C_AUD_SCL_1V8			GPIO(SCL2)
#define GPIO_AP_I2C_AUD_SDA_1V8			GPIO(SDA2)
#define GPIO_AP_I2C_TPM_SCL_1V8			GPIO(SCL3)
#define GPIO_AP_I2C_TPM_SDA_1V8			GPIO(SDA3)
#define GPIO_AP_I2C_TCHSCR_SCL_1V8		GPIO(SCL4)
#define GPIO_AP_I2C_TCHSCR_SDA_1V8		GPIO(SDA4)
#define GPIO_AP_I2C_SAR_SCL_1V8			GPIO(SCL5)
#define GPIO_AP_I2C_SAR_SDA_1V8			GPIO(SDA5)
#define GPIO_AP_I2C_HDMI_SCL_1V8		GPIO(SCL6)
#define GPIO_AP_I2C_HDMI_SDA_1V8		GPIO(SDA6)
#define GPIO_AP_I2C_TCHPAD_SCL_1V8		GPIO(SCL7)
#define GPIO_AP_I2C_TCHPAD_SDA_1V8		GPIO(SDA7)
#define GPIO_AP_I2C8_SCL_1V8			GPIO(SCL8)
#define GPIO_AP_I2C8_SDA_1V8			GPIO(SDA8)
#define GPIO_SPI_AP_CS_EC_L			GPIO(SPIM0_CSB)
#define GPIO_SPI_AP_CLK_EC			GPIO(SPIM0_CLK)
#define GPIO_SPI_AP_DO_EC_DI			GPIO(SPIM0_MOSI)
#define GPIO_SPI_AP_DI_EC_DO			GPIO(SPIM0_MISO)
#define GPIO_SPI_AP_CS_FP_1V8_L			GPIO(SPIM1_CSB)
#define GPIO_SPI_AP_CLK_FP_1V8			GPIO(SPIM1_CLK)
#define GPIO_SPI_AP_DO_FP_DI_1V8		GPIO(SPIM1_MOSI)
#define GPIO_SPI_AP_DI_FP_DO_1V8		GPIO(SPIM1_MISO)
#define GPIO_SPI_AP_CS_TCHSCR_L			GPIO(SPIM2_CSB)
#define GPIO_SPI_AP_CLK_TCHSCR			GPIO(SPIM2_CLK)
#define GPIO_SPI_AP_DO_TCHSCR_DI		GPIO(SPIM2_MOSI)
#define GPIO_SPI_AP_DI_TCHSCR_DO		GPIO(SPIM2_MISO)
#define GPIO_PWRAP_SPI_CS_L			GPIO(PWRAP_SPI_CSN)
#define GPIO_PWRAP_SPI_CK			GPIO(PWRAP_SPI_CK)
#define GPIO_PWRAP_SPI_MOSI			GPIO(PWRAP_SPI_MO)
#define GPIO_PWRAP_SPI_MISO			GPIO(PWRAP_SPI_MI)
#define GPIO_SRCLKENA0				GPIO(PMIC_SRCLKENA0)
#define GPIO_SRCLKENA1				GPIO(PMIC_SRCLKENA1)
#define GPIO_SCP_VREQ_VAO			GPIO(SCP_VREQ_VAO)
#define GPIO_AP_RTC_CLK32K			GPIO(PMIC_RTC32K_CK)
#define GPIO_AP_PMIC_WDTRST_L			GPIO(PMIC_WATCHDOG)
#define GPIO_AUD_CLK_MOSI			GPIO(AUD_CLK_MOSI)
#define GPIO_AUD_SYNC_MOSI			GPIO(AUD_SYNC_MOSI)
#define GPIO_AUD_DAT_MOSI0			GPIO(AUD_DAT_MOSI0)
#define GPIO_AUD_DAT_MOSI1			GPIO(AUD_DAT_MOSI1)
#define GPIO_AUD_DAT_MISO0			GPIO(AUD_DAT_MISO0)
#define GPIO_AUD_DAT_MISO1			GPIO(AUD_DAT_MISO1)
#define GPIO_AP_I2SIN0_MCK			GPIO(I2SIN0_MCK)
#define GPIO_AP_I2SIN0_BCk			GPIO(I2SIN0_BCK)
#define GPIO_AP_I2SIN0_LRCK			GPIO(I2SIN0_LRCK)
#define GPIO_I2S_HP_DI				GPIO(I2SIN0_DI)
#define GPIO_I2S_HP_MCK				GPIO(I2SOUT0_MCK)
#define GPIO_I2S_HP_BCK				GPIO(I2SOUT0_BCK)
#define GPIO_I2S_HP_LRCK			GPIO(I2SOUT0_LRCK)
#define GPIO_I2S_HP_DO				GPIO(I2SOUT0_DO)
#define GPIO_I2S_SPKR_MCK			GPIO(DMIC0_CLK)
#define GPIO_I2S_SPKR_BCK			GPIO(DMIC0_DAT0)
#define GPIO_I2S_SPKR_LRCK			GPIO(DMIC1_CLK)
#define GPIO_I2S_SPKR_DO			GPIO(DMIC1_DAT0)
#define GPIO_PCM_HDMI_CLK			GPIO(PCM_CLK)
#define GPIO_PCM_HDMI_SYNC			GPIO(PCM_SYNC)
#define GPIO_AP_PCM_DI				GPIO(PCM_DI)
#define GPIO_PCM_HDMI_DO			GPIO(PCM_DO)
#define GPIO_DMIC0_CLK				GPIO(GBE_TXD3)
#define GPIO_DMIC0_DATA				GPIO(GBE_TXD2)
#define GPIO_EN_PP3300_WWAN_X			GPIO(GBE_TXD1)
#define GPIO_DMIC1_CLK				GPIO(GBE_TXD0)
#define GPIO_DMIC1_DATA				GPIO(GBE_RXD3)
#define GPIO_WWAN_SAR_DETECT_L			GPIO(GBE_RXD2)
#define GPIO_TCHPAD_INT_ODL			GPIO(GBE_RXD1)
#define GPIO_TCHSCR_RST_1V8_L			GPIO(GBE_RXD0)
#define GPIO_AP_HDMI_RST_ODL			GPIO(GBE_TXC)
#define GPIO_HDMI_AP_INT_ODL			GPIO(GBE_RXC)
#define GPIO_FP_AP_INT_1V8_S3_ODL		GPIO(GBE_RXDV)
#define GPIO_I2S_SPKR_DI			GPIO(GBE_TXEN)
#define GPIO_AP_XHCI_INIT_DONE			GPIO(GBE_MDC)
#define GPIO_EC_AP_INT_ODL			GPIO(GBE_MDIO)
#define GPIO_AP_FP_FW_UP_STRAP			GPIO(GBE_TXER)
#define GPIO_FP_RST_1V8_S3_L			GPIO(GBE_RXER)
#define GPIO_EN_HDMI_PWR			GPIO(GBE_COL)
#define GPIO_SD_CD_ODL				GPIO(GBE_INTR)
#define GPIO_AP_EC_WARM_RST_REQ			GPIO(GBE_AUX_PPS0)
#define GPIO_GSC_AP_INT_ODL			GPIO(GBE_AUX_PPS1)
#define GPIO_HDMI_HPD_1V8_ODL			GPIO(CONN_TOP_CLK)
#define GPIO_AP_SUSPEND_L			GPIO(CONN_TOP_DATA)
#define GPIO_EC_AP_RSVD0_ODL			GPIO(CONN_BT_CLK)
#define GPIO_EC_AP_RSVD1_ODL			GPIO(CONN_BT_DATA)
#define GPIO_MT6319B_INT			GPIO(CONN_HRST_B)
#define GPIO_MT6319C_INT			GPIO(CONN_WB_PTA)
#define GPIO_BT_KILL_1V8_L			GPIO(CONN_WF_CTRL0)
#define GPIO_WIFI_KILL_1V8_L			GPIO(CONN_WF_CTRL1)
#define GPIO_WWAN_PWR_OFF_L			GPIO(CONN_WF_CTRL2)
#define GPIO_WWAN_W_DISABLE_L			GPIO(CONN_WF_CTRL3)
#define GPIO_SPI_AP_CLK_BIOS			GPIO(SPINOR_CK)
#define GPIO_SPI_AP_CS_BIOS_L			GPIO(SPINOR_CS)
#define GPIO_SPI_AP_DO_BIOS_DI			GPIO(SPINOR_IO0)
#define GPIO_SPI_AP_DI_BIOS_DO			GPIO(SPINOR_IO1)
#define GPIO_AP_SPINOR_IO2			GPIO(SPINOR_IO2)
#define GPIO_AP_SPINOR_IO3			GPIO(SPINOR_IO3)
#define GPIO_SD_CMD				GPIO(MSDC1_CMD)
#define GPIO_SD_CLK				GPIO(MSDC1_CLK)
#define GPIO_SD_DATA0				GPIO(MSDC1_DAT0)
#define GPIO_SD_DATA1				GPIO(MSDC1_DAT1)
#define GPIO_SD_DATA2				GPIO(MSDC1_DAT2)
#define GPIO_SD_DATA3				GPIO(MSDC1_DAT3)
#define GPIO_SPMI_SCL				GPIO(SPMI_P_SCL)
#define GPIO_SPMI_SDA				GPIO(SPMI_P_SDA)
#define GPIO_EMI_RESET_N			GPIO(EMI_RESETB)

void setup_chromeos_gpios(void);

#endif
