% Libreboot 20241206, 11th revision released! (fixes to GRUB regressions)
% Leah Rowe
% 20 April 2025

Today's Libreboot 20241206 revision is the 11th revision in the Libreboot
20241206 stable release series. The changelog on this page is written, relative
to Libreboot 20241206 revision 10
You can find the full list of revisions [here](libreboot20241206.Revisions.md)
and the original release [here](libreboot20241206.md).

Open source BIOS/UEFI firmware
------------------------------

<img tabindex=1 class="r" src="https://av.libreboot.org/t480/t480.jpg" /><span class="f"><img src="https://av.libreboot.org/t480/t480.jpg" /></span>

Libreboot is a free/open source BIOS/UEFI replacement on x86 and ARM, providing
boot firmware that initialises the hardware in your computer, to then load an
operating system (e.g. Linux/BSD). It is specifically
a *[coreboot distribution](../docs/maintain/)*,
in the same way that Debian is a Linux distribution. It provides an automated
build system to produce coreboot ROM images with a variety of payloads such as
GRUB or SeaBIOS, with regular well-tested releases to make coreboot as easy
to use as possible for non-technical users. From a project management perspective,
this works in *exactly* the same way as a Linux distro, providing a source-based
package manager (called lbmk) which patches sources and compiles coreboot images.
It makes use of [coreboot](https://www.coreboot.org/) for hardware initialisation,
and then a payload such as [SeaBIOS](https://www.seabios.org/SeaBIOS)
or GRUB to boot your operating
system; on ARM(chromebooks), we provide *U-Boot* (as a coreboot payload).

We also provide an experimental U-Boot setup on x86, as a coreboot payload for
providing a minimal UEFI implementation.

### Regarding revision 11

Normally, revisions would only be documented on
the [Libreboot 20241206 revisions page](libreboot20241206.Revisions.md), but
this revision contains *critical regression fixes*, so it was decided that there
should be a full announcement, to ensure that more people see it.

Summarised list of changes
------------------------

Several major CVE fixes were merged in the previous release revision, but
these caused several regressions especially in filesystem drivers (e.g. fs/ext2).

For example, very large files would sometimes not load properly on ext4 file
systems, leading to a distro no longer booting (this also affected people who
used the loopback device).

See below for a full list of fixes merged from upstream, included in this
revision release. GRUB should hopefully be stable now.

If you previously updated to the revision 10 release, and you rely on the
GRUB payload, you are *strongly* advised to install 20241206rev11 instead.

### Revision updates

The following GRUB fixes were merged from upstream:

```
* a4da71daf util/grub-install: Include raid5rec module for RAID 4 as well
* 223fcf808 loader/ia64/efi/linux: Reset grub_errno on failure to allocate
* 6504a8d4b lib/datetime: Specify license in emu module
* 8fef533cf configure: Add -mno-relax on riscv*
* 1fe094855 docs: Document the long options of tpm2_key_protect_init
* 6252eb97c INSTALL: Document the packages needed for TPM2 key protector tests
* 9d4b382aa docs: Update NV index mode of TPM2 key protector
* 2043b6899 tests/tpm2_key_protector_test: Add more NV index mode tests
* 9f66a4719 tests/tpm2_key_protector_test: Reset "ret" on fail
* b7d89e667 tests/tpm2_key_protector_test: Simplify the NV index mode test
* 5934bf51c util/grub-protect: Support NV index mode
* cd9cb944d tpm2_key_protector: Support NV index handles
* fa69deac5 tpm2_key_protector: Unseal key from a buffer
* 75c480885 tss2: Add TPM 2.0 NV index commands
* 041164d00 tss2: Fix the missing authCommand
* 46c9f3a8d tpm2_key_protector: Add tpm2_dump_pcr command
* 617dab9e4 tpm2_key_protector: Dump PCRs on policy fail
* 204a6ddfb loader/i386/linux: Update linux_kernel_params to match upstream
* 6b64f297e loader/xnu: Fix memory leak
* f94d257e8 fs/btrfs: Fix memory leaks
* 81146fb62 loader/i386/linux: Fix resource leak
* 1d0059447 lib/reloacator: Fix memory leaks
* f3f1fcecd disk/ldm: Fix memory leaks
* aae2ea619 fs/ntfs: Fix NULL pointer dereference and possible infinite loop
* 3b25e494d net/drivers/ieee1275/ofnet: Add missing grub_malloc()
* fee6081ec kern/ieee1275/init: Increase MIN_RMA size for CAS negotiation on PowerPC machines
* b66c6f918 fs/zfs: Fix a number of memory leaks in ZFS code
* 1d59f39b5 tests/util/grub-shell: Remove the work directory on successful run and debug is not on
* e0116f3bd tests/grub_cmd_cryptomount: Remove temporary directories if successful and debug is not on
* e6e2b73db tests/grub_cmd_cryptomount: Default TMPDIR to /tmp
* 32b02bb92 tests/grub_cmd_cryptomount: Cleanup the cryptsetup script unless debug is enabled
* c188ca5d5 tests: Cleanup generated files on expected failure in grub_cmd_cryptomount
* 50320c093 tests/util/grub-shell-luks-tester: Add missing line to create RET variable in cleanup
* bb6d3199b tests/util/grub-shell-luks-tester: Find cryptodisk by UUID
* 3fd163e45 tests/util/grub-shell: Default qemuopts to envvar $GRUB_QEMU_OPTS
* ff7f55307 disk/lvm: Add informational messages in error cases of ignored features
* a16b4304a disk/lvm: Add support for cachevol LV
* 9a37d6114 disk/lvm: Add support for integrity LV
* 6c14b87d6 lvm: Match all LVM segments before validation
* d34b9120e disk/lvm: Remove unused cache_pool
* 90848a1f7 disk/lvm: Make cache_lv more generic as ignored_feature_lv
* 488ac8bda commands/ls: Add directory header for dir args
* 096bf59e4 commands/ls: Print full paths for file args
* 90288fc48 commands/ls: Output path for single file arguments given with path
* 6337d84af commands/ls: Show modification time for file paths
* cbfb031b1 commands/ls: Merge print_files_long() and print_files() into print_file()
* 112d2069c commands/ls: Return proper GRUB_ERR_* for functions returning type grub_err_t
* da9740cd5 commands/acpi: Use options enum to index command options
* 1acf11fe4 docs: Capture additional commands restricted by lockdown
* 6a168afd3 docs: Document restricted filesystems in lockdown
* be0ae9583 loader/i386/bsd: Fix type passed for the kernel
* ee27f07a6 kern/partition: Unbreak support for nested partitions
* cb639acea lib/tss2/tss2_structs.h: Fix clang build - remove duplicate typedef
* 696e35b7f include/grub/mm.h: Remove duplicate inclusion of grub/err.h
* 187338f1a script/execute: Don't let trailing blank lines determine the return code
* ff173a1c0 gitignore: Ignore generated files from libtasn
* fbcc38891 util/grub.d/30_os-prober.in: Conditionally show or hide chain and efi menu entries
* 56ccc5ed5 util/grub.d/30_os-prober.in: Fix GRUB_OS_PROBER_SKIP_LIST for non-EFI
* 01f064064 docs: Do not reference non-existent --dumb option
* 3f440b5a5 docs: Replace @lbracechar{} and @rbracechar{} with @{ and @}
* f20988738 fs/xfs: Fix grub_xfs_iterate_dir() return value in case of failure
* 1ed2628b5 fs/xfs: Add new superblock features added in Linux 6.12/6.13
* 348cd416a fs/ext2: Rework out-of-bounds read for inline and external extents
* c730eddd2 disk/ahci: Remove conditional operator for endtime
* f0a08324d term/ns8250-spcr: Return if redirection is disabled
* 7161e2437 commands/file: Fix NULL dereference in the knetbsd tests
* 11b9c2dd0 gdb_helper: Typo hueristic
* 224aefd05 kern/efi/mm: Reset grub_mm_add_region_fn after ExitBootServices() call
* 531750f7b i386/tsc: The GRUB menu gets stuck due to unserialized rdtsc
* f2a1f66e7 kern/i386/tsc_pmtimer: The GRUB menu gets stuck due to failed calibration
* 13f005ed8 loader/i386/linux: Fix cleanup if kernel doesn't support 64-bit addressing
```
