<?php
/* * * * * * * * * * * * * * * * * * * * * * *
 * _     _ _  _   _                          *
 * \ \  ///                [ 2 0 0 6 ]       *
 *  \ \///  i s h i o u s . d e              *
 *   \///                                    *
 * * * * * * * * ` W H A T  * * * * * * * * *
 *   \// I N C E  subversion: Custom         *
 * * * * * * * * ` D A T A  * * * * * * * * *
 *  For: q4max                               *
 *  Sub: index.php                           *
 *  Chg: 20.02.2006                          *
 * * * * * * * * * * * * * * * * * * * * * * */

// set basepath
define("PATH", "../");
define("IMPORTPATH", PATH."import/");
define("TEMPLATEPATH", PATH."template/");
define("CONFIGPATH", PATH."configs/");
define("IMAGEPATH", PATH."img/");

// try to forcefully set session timeouts etc
@ini_set('session.use_cookies','1');
@ini_set('session.use_only_cookies','1');
@session_cache_limiter('private_no_expire');

// debug mode?
if (isset($_REQUEST["debug"])) {
	error_reporting(E_ALL);
	$_REQUEST["killall"] = "true";
} else error_reporting(0);

// session started?
$possid = session_id();
if (empty($possid)) session_start();

// include basic classes
require_once(IMPORTPATH."q4maxXML_class.php");
require_once(IMPORTPATH."SofeeXmlParser.php");
require_once(IMPORTPATH."class.iniparser.php"); 

// initialize timecounter
$script_start = microtime_float();

// initialize xml parsing
if (!isset($_REQUEST["reparse"]) && (($_SESSION["q4maxstats"]["reparse_when"]) > time()) && $_SESSION["q4maxstats"]["reparse_when"] > 0 && !isset($_REQUEST["killall"])) {
	$stats = unserialize($_SESSION["q4maxstats"]["objdata"]);
	$stats->wasiparsed = FALSE;
	$_SESSION["q4maxstats"]["parsed"] = FALSE;
}
else {
	$stats = new XMLstats();
	if (isset($_REQUEST["killall"])) {
		// if wanted kill dumped ini
		$hndl = fopen(IMPORTPATH."parsed.ini", "w");
		fclose($hndl);
		usleep(10);
	}
	$stats->Parse_Stats();
	$stats->wasiparsed = TRUE;
	$_SESSION["q4maxstats"]["parsed"] = TRUE;
}

// set class version
$stats->classversion = "MAXStats 1.0.3.1";

// finalize timecounter
usleep(10);
$script_end = microtime_float();
$script_time = round($script_end - $script_start, 5);

// process queries
if (isset($_REQUEST["top"])) $stats->outputtype = $_REQUEST["top"];
else {
	if (empty($_COOKIE["q4mstats"]))	$stats->outputtype = "players";
	else $stats->outputtype = $_COOKIE["q4mstats"];
}

if (empty($_COOKIE["q4mstats"]) || $_COOKIE["q4mstats"] != $stats->outputtype) {
	setcookie("q4mstats", $stats->outputtype, time()+30*3600);
}

// do output
echo $stats->Generate_Output();

// unset parsed things for less sessiondata
$stats->XMLfiles = NULL;

// finalize session handling, save parsed data
$_SESSION["q4maxstats"]["objdata"] = serialize($stats);
$_SESSION["q4maxstats"]["time"] = time();
$_SESSION["q4maxstats"]["reparse"] = $stats->configuration["GENERAL"]["reparse_stats"];
if ($stats->wasiparsed == TRUE) $_SESSION["q4maxstats"]["reparse_when"] = (time() + $stats->configuration["GENERAL"]["reparse_stats"]);
?>