# (c) 1992-2023 Intel Corporation.                            
# Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack words    
# and logos are trademarks of Intel Corporation or its subsidiaries in the U.S.  
# and/or other countries. Other marks and brands may be claimed as the property  
# of others. See Trademarks on intel.com for full list of Intel trademarks or    
# the Trademarks & Brands Names Database (if Intel) or See www.Intel.com/legal (if Altera) 
# Your use of Intel Corporation's design tools, logic functions and other        
# software and tools, and its AMPP partner logic functions, and any output       
# files any of the foregoing (including device programming or simulation         
# files), and any associated documentation or information are expressly subject  
# to the terms and conditions of the Altera Program License Subscription         
# Agreement, Intel MegaCore Function License Agreement, or other applicable      
# license agreement, including, without limitation, that your use is for the     
# sole purpose of programming logic devices manufactured by Intel and sold by    
# Intel or its authorized distributors.  Please refer to the applicable          
# agreement for further details.                                                 


# TCL File Generated by Component Editor 15.0
# Mon Jul 27 14:34:17 EDT 2015
# DO NOT MODIFY


#
# cra_ring_root "cra_ring_root" v1.0
#  2015.07.27.14:34:17
# OpenCL CRA Address Decode Ring Root Node
#

#
# request TCL package from ACDS 15.0
#
package require -exact qsys 15.0


#
# module cra_ring_root
#
set_module_property DESCRIPTION "OpenCL CRA Address Decode Ring Root Node"
set_module_property NAME cra_ring_root
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property GROUP OpenCL
set_module_property AUTHOR "John Freeman"
set_module_property DISPLAY_NAME cra_ring_root
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property REPORT_HIERARCHY false


#
# file sets
#
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL cra_ring_root
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property QUARTUS_SYNTH ENABLE_FILE_OVERWRITE_MODE false
add_fileset_file cra_ring_root.sv SYSTEM_VERILOG PATH cra_ring_root.sv TOP_LEVEL_FILE

add_fileset SIM_VERILOG SIM_VERILOG "" ""
set_fileset_property SIM_VERILOG TOP_LEVEL cra_ring_root
set_fileset_property SIM_VERILOG ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property SIM_VERILOG ENABLE_FILE_OVERWRITE_MODE false
add_fileset_file cra_ring_root.sv SYSTEM_VERILOG PATH cra_ring_root.sv

add_fileset SIM_VHDL SIM_VHDL "" ""
set_fileset_property SIM_VHDL TOP_LEVEL cra_ring_root
set_fileset_property SIM_VHDL ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property SIM_VHDL ENABLE_FILE_OVERWRITE_MODE false
add_fileset_file cra_ring_root.sv SYSTEM_VERILOG PATH cra_ring_root.sv


#
# parameters
#
add_parameter ASYNC_RESET INTEGER 1
set_parameter_property ASYNC_RESET DEFAULT_VALUE 1
set_parameter_property ASYNC_RESET DISPLAY_NAME ASYNC_RESET
set_parameter_property ASYNC_RESET TYPE INTEGER
set_parameter_property ASYNC_RESET UNITS None
set_parameter_property ASYNC_RESET HDL_PARAMETER true
add_parameter SYNCHRONIZE_RESET INTEGER 1
set_parameter_property SYNCHRONIZE_RESET DEFAULT_VALUE 0
set_parameter_property SYNCHRONIZE_RESET DISPLAY_NAME SYNCHRONIZE_RESET
set_parameter_property SYNCHRONIZE_RESET TYPE INTEGER
set_parameter_property SYNCHRONIZE_RESET UNITS None
set_parameter_property SYNCHRONIZE_RESET HDL_PARAMETER true
add_parameter ADDR_W INTEGER 32 "Width of the address bus"
set_parameter_property ADDR_W DEFAULT_VALUE 32
set_parameter_property ADDR_W DISPLAY_NAME ADDR_W
set_parameter_property ADDR_W WIDTH ""
set_parameter_property ADDR_W TYPE INTEGER
set_parameter_property ADDR_W UNITS None
set_parameter_property ADDR_W ALLOWED_RANGES -2147483648:2147483647
set_parameter_property ADDR_W DESCRIPTION "Width of the address bus"
set_parameter_property ADDR_W HDL_PARAMETER true
add_parameter DATA_W INTEGER 32 "Width of the data bus"
set_parameter_property DATA_W DEFAULT_VALUE 32
set_parameter_property DATA_W DISPLAY_NAME DATA_W
set_parameter_property DATA_W TYPE INTEGER
set_parameter_property DATA_W UNITS None
set_parameter_property DATA_W ALLOWED_RANGES -2147483648:2147483647
set_parameter_property DATA_W DESCRIPTION "Width of the data bus"
set_parameter_property DATA_W HDL_PARAMETER true
add_parameter ID_W INTEGER 3 "Width of the node ID"
set_parameter_property ID_W DEFAULT_VALUE 3
set_parameter_property ID_W DISPLAY_NAME ID_W
set_parameter_property ID_W TYPE INTEGER
set_parameter_property ID_W UNITS None
set_parameter_property ID_W ALLOWED_RANGES -2147483648:2147483647
set_parameter_property ID_W DESCRIPTION "Width of the node ID"
set_parameter_property ID_W HDL_PARAMETER true
add_parameter ROM_EXT_W INTEGER 0 "Extra Address Width for ROM"
set_parameter_property ROM_EXT_W DEFAULT_VALUE 0
set_parameter_property ROM_EXT_W DISPLAY_NAME ROM_EXT_W
set_parameter_property ROM_EXT_W TYPE INTEGER
set_parameter_property ROM_EXT_W UNITS None
set_parameter_property ROM_EXT_W ALLOWED_RANGES -2147483648:2147483647
set_parameter_property ROM_EXT_W DESCRIPTION "Extra Address Width for ROM"
set_parameter_property ROM_EXT_W HDL_PARAMETER true
add_parameter ROM_ENABLE INTEGER 0 "Enable or disable ROM select wire"
set_parameter_property ROM_ENABLE DEFAULT_VALUE 0
set_parameter_property ROM_ENABLE DISPLAY_NAME ROM_ENABLE
set_parameter_property ROM_ENABLE TYPE INTEGER
set_parameter_property ROM_ENABLE UNITS None
set_parameter_property ROM_ENABLE ALLOWED_RANGES 0:1
set_parameter_property ROM_ENABLE DESCRIPTION "Enable or disable ROM select wire"
set_parameter_property ROM_ENABLE HDL_PARAMETER true
add_parameter AGENT_PORT_WAITREQUEST_ALLOWANCE INTEGER 0 "Agent port waitrequest allowance"
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE DEFAULT_VALUE 0
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE DISPLAY_NAME AGENT_PORT_WAITREQUEST_ALLOWANCE
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE TYPE INTEGER
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE UNITS None
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE ALLOWED_RANGES 0:7
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE DESCRIPTION "Agent port waitrequest allowance"
set_parameter_property AGENT_PORT_WAITREQUEST_ALLOWANCE HDL_PARAMETER true
add_parameter ALLOW_HIGH_SPEED_FIFO_USAGE INTEGER 1
set_parameter_property ALLOW_HIGH_SPEED_FIFO_USAGE DEFAULT_VALUE 1
set_parameter_property ALLOW_HIGH_SPEED_FIFO_USAGE DISPLAY_NAME ALLOW_HIGH_SPEED_FIFO_USAGE
set_parameter_property ALLOW_HIGH_SPEED_FIFO_USAGE TYPE INTEGER
set_parameter_property ALLOW_HIGH_SPEED_FIFO_USAGE UNITS None
set_parameter_property ALLOW_HIGH_SPEED_FIFO_USAGE HDL_PARAMETER true

#
# display items
#


#
# connection point clock
#
add_interface clock clock end
set_interface_property clock clockRate 0
set_interface_property clock ENABLED true
set_interface_property clock EXPORT_OF ""
set_interface_property clock PORT_NAME_MAP ""
set_interface_property clock CMSIS_SVD_VARIABLES ""
set_interface_property clock SVD_ADDRESS_GROUP ""

add_interface_port clock clk clk Input 1


#
# connection point reset
#
add_interface reset reset end
set_interface_property reset associatedClock clock
set_interface_property reset synchronousEdges DEASSERT
set_interface_property reset ENABLED true
set_interface_property reset EXPORT_OF ""
set_interface_property reset PORT_NAME_MAP ""
set_interface_property reset CMSIS_SVD_VARIABLES ""
set_interface_property reset SVD_ADDRESS_GROUP ""

add_interface_port reset rst_n reset_n Input 1


#
# connection point cra_agent
#
add_interface cra_agent avalon end
set_interface_property cra_agent addressUnits WORDS
set_interface_property cra_agent associatedClock clock
set_interface_property cra_agent associatedReset reset
set_interface_property cra_agent bitsPerSymbol 8
set_interface_property cra_agent burstOnBurstBoundariesOnly false
set_interface_property cra_agent burstcountUnits WORDS
set_interface_property cra_agent explicitAddressSpan 0
set_interface_property cra_agent holdTime 0
set_interface_property cra_agent linewrapBursts false
set_interface_property cra_agent maximumPendingReadTransactions 1
set_interface_property cra_agent maximumPendingWriteTransactions 0
set_interface_property cra_agent readLatency 0
set_interface_property cra_agent readWaitTime 1
set_interface_property cra_agent setupTime 0
set_interface_property cra_agent timingUnits Cycles
set_interface_property cra_agent writeWaitTime 0
set_interface_property cra_agent ENABLED true
set_interface_property cra_agent EXPORT_OF ""
set_interface_property cra_agent PORT_NAME_MAP ""
set_interface_property cra_agent CMSIS_SVD_VARIABLES ""
set_interface_property cra_agent SVD_ADDRESS_GROUP ""

add_interface_port cra_agent avs_write write Input 1
add_interface_port cra_agent avs_addr address Input ADDR_W+ID_W+ROM_EXT_W+ROM_ENABLE
add_interface_port cra_agent avs_byteena byteenable Input DATA_W/8
add_interface_port cra_agent avs_writedata writedata Input DATA_W
add_interface_port cra_agent avs_readdata readdata Output DATA_W
add_interface_port cra_agent avs_readdatavalid readdatavalid Output 1
add_interface_port cra_agent avs_waitrequest waitrequest Output 1
add_interface_port cra_agent avs_read read Input 1
set_interface_assignment cra_agent embeddedsw.configuration.isFlash 0
set_interface_assignment cra_agent embeddedsw.configuration.isMemoryDevice 0
set_interface_assignment cra_agent embeddedsw.configuration.isNonVolatileStorage 0
set_interface_assignment cra_agent embeddedsw.configuration.isPrintableDevice 0


#
# connection point ring_in
#
add_interface ring_in conduit end
set_interface_property ring_in associatedClock clock
set_interface_property ring_in associatedReset reset
set_interface_property ring_in ENABLED true
set_interface_property ring_in EXPORT_OF ""
set_interface_property ring_in PORT_NAME_MAP ""
set_interface_property ring_in CMSIS_SVD_VARIABLES ""
set_interface_property ring_in SVD_ADDRESS_GROUP ""

add_interface_port ring_in ri_write write Input 1
add_interface_port ring_in ri_addr addr Input ADDR_W+ID_W
add_interface_port ring_in ri_byteena byteena Input DATA_W/8
add_interface_port ring_in ri_data data Input DATA_W
add_interface_port ring_in ri_readdata data Input DATA_W
add_interface_port ring_in ri_read read Input 1
add_interface_port ring_in ri_datavalid datavalid Input 1


#
# connection point ring_out
#
add_interface ring_out conduit end
set_interface_property ring_out associatedClock clock
set_interface_property ring_out associatedReset reset
set_interface_property ring_out ENABLED true
set_interface_property ring_out EXPORT_OF ""
set_interface_property ring_out PORT_NAME_MAP ""
set_interface_property ring_out CMSIS_SVD_VARIABLES ""
set_interface_property ring_out SVD_ADDRESS_GROUP ""

add_interface_port ring_out ro_read read Output 1
add_interface_port ring_out ro_write write Output 1
add_interface_port ring_out ro_addr addr Output ADDR_W+ID_W+ROM_EXT_W+ROM_ENABLE
add_interface_port ring_out ro_data data Output DATA_W
add_interface_port ring_out ro_readdata data Output DATA_W
add_interface_port ring_out ro_byteena byteena Output DATA_W/8
add_interface_port ring_out ro_datavalid datavalid Output 1

