/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

public final class AsymmetricXDHPrivateKey
extends AsymmetricXDHKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] keyData;
    private byte[] publicData;
    private boolean hasPublicKey;
    private ASN1Set attributes;
    private int hashCode;

    public AsymmetricXDHPrivateKey(Algorithm algorithm, byte[] byArray, byte[] byArray2) {
        super(algorithm);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
        this.attributes = null;
        if (byArray2 == null) {
            this.hasPublicKey = false;
            this.publicData = EdEC.computePublicData(algorithm, byArray);
        } else {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(byArray2);
        }
    }

    public AsymmetricXDHPrivateKey(byte[] byArray) throws IOException {
        this(PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricXDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(EdECObjectIdentifiers.id_X448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519);
        byte[] byArray = privateKeyInfo.getPrivateKey().getOctets();
        if (byArray.length == 32 || byArray.length == 56) {
            this.keyData = Arrays.clone(byArray);
        } else {
            ASN1Encodable aSN1Encodable = privateKeyInfo.parsePrivateKey();
            this.keyData = Arrays.clone(ASN1OctetString.getInstance(aSN1Encodable).getOctets());
        }
        if (privateKeyInfo.hasPublicKey()) {
            this.hasPublicKey = true;
            this.publicData = Arrays.clone(privateKeyInfo.getPublicKeyData().getOctets());
        } else {
            this.publicData = null;
        }
        if (EdECObjectIdentifiers.id_X448.equals(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? this.keyData.length != 56 : this.keyData.length != 32) {
            throw new IllegalArgumentException("raw key data incorrect size");
        }
        this.attributes = privateKeyInfo.getAttributes();
        this.hashCode = this.calculateHashCode();
    }

    public byte[] getSecret() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] byArray = Arrays.clone(this.keyData);
        KeyUtils.checkDestroyed(this);
        return byArray;
    }

    public byte[] getPublicData() {
        byte[] byArray = Arrays.clone(this.publicData);
        KeyUtils.checkDestroyed(this);
        return byArray;
    }

    @Override
    public byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        byte[] byArray = this.hasPublicKey && !Properties.isOverrideSet("org.bouncycastle.pkcs8.v1_info_only") ? this.publicData : null;
        ASN1Set aSN1Set = this.attributes;
        if (this.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), new DEROctetString(this.getSecret()), aSN1Set, byArray);
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(this.getSecret()), aSN1Set, byArray);
    }

    @Override
    protected void zeroize() {
        super.zeroize();
        Arrays.clear(this.keyData);
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.keyData);
            if (this.publicData != null) {
                Arrays.clear(this.publicData);
            }
            this.publicData = null;
            this.hasPublicKey = false;
            this.attributes = null;
            this.hashCode = -1;
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricXDHPrivateKey)) {
            return false;
        }
        AsymmetricXDHPrivateKey asymmetricXDHPrivateKey = (AsymmetricXDHPrivateKey)object;
        asymmetricXDHPrivateKey.checkApprovedOnlyModeStatus();
        return this.hashCode == asymmetricXDHPrivateKey.hashCode && KeyUtils.isFieldEqual(this.getAlgorithm(), asymmetricXDHPrivateKey.getAlgorithm()) && Arrays.constantTimeAreEqual(this.keyData, asymmetricXDHPrivateKey.keyData);
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }
}

