#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include "uxsock.h"

/*
 * keep writing until its all sent
 */
int write_all(int fd, const void *buf, size_t len)
{
	size_t total = 0;
	while (len) {
		int n = write(fd, buf, len);
		if (n <= 0) return total;
		buf = n + (char *)buf;
		len -= n;
		total += n;
	}
	return total;
}

/*
 * keep reading until its all read
 */
int read_all(int fd, void *buf, size_t len)
{
	size_t total = 0;
	while (len) {
		int n = read(fd, buf, len);
		if (n <= 0) return total;
		buf = n + (char *)buf;
		len -= n;
		total += n;
	}
	return total;
}

int main(int argc, char **argv)
{
	int sock;
	struct sockaddr_un sun;
	int len;
	char reply[5];

	if (argc != 2)
		exit(1);
	len = strlen(argv[1]) + 1;
	if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0)
		exit(1);
	sun.sun_family = AF_UNIX;
	strncpy(sun.sun_path, SOCKET_NAME, sizeof(sun.sun_path));
	sun.sun_path[sizeof(sun.sun_path)-1] = 0;
	if (connect(sock, (struct sockaddr *)&sun, sizeof(sun)) < 0)
		exit(0);
	if (write_all(sock, &len, sizeof(len)) != sizeof(len))
		exit(1);
	if (write_all(sock, argv[1], len) != len)
		exit(1);
	if (read_all(sock, &len, sizeof(len)) != sizeof(len))
		exit(1);
	if (len > 5)
		exit(1);
	if (read_all(sock, &reply, len) != len)
		exit(1);
	if (strcmp(reply, "ok"))
		exit(1);
	close(sock);
	return 0;
}
	
