;; $Id: dbblock.dsl,v 1.1 1998/02/18 13:13:35 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(element HIGHLIGHTS ($block-container$))

(element BLOCKQUOTE
  (make element gi: "BLOCKQUOTE"
	(process-children-trim)))

(element EPIGRAPH ($block-container$))

(element ATTRIBUTION ($paragraph$))

(element PARA ($paragraph$))
(element SIMPARA ($paragraph$))

(element FORMALPARA
  (make element gi: "DIV"
	attributes: (list
		     (list "CLASS" (gi)))
	(make element gi: "P"
	      (process-children))))

(element (FORMALPARA TITLE)
  (make element gi: "B"
	(process-children)
	(literal ". ")))

(element (FORMALPARA PARA)
  (process-children))

(element SIDEBAR 
  (make element gi: "TABLE"
	attributes: (list
		     (list "CLASS" (gi))
		     (list "BORDER" "1")
		     (list "CELLPADDING" "5"))
	(make element gi: "TR"
	      (make element gi: "TD"
		    ($semiformal-object$)))))

(element (SIDEBAR TITLE)
  (empty-sosofo))

(element ABSTRACT 
  (make element gi: "BLOCKQUOTE"
	attributes: '(("CLASS" "ABSTRACT"))
	(process-children)))

(element AUTHORBLURB ($block-container$))

(define ($inline-object$)
  (process-children))

(define ($informal-object$)
  (make element gi: "DIV"
	attributes: (list
		     (list "CLASS" (gi)))
	(if %spacing-paras%
	    (make element gi: "P" (empty-sosofo))
	    (empty-sosofo))
	(process-children)))

(define ($formal-object$)
  (let* ((nsep  (gentext-label-title-sep (gi)))
	 (id    (attribute-string "ID"))
	 (titlesosofo (make sequence
			(literal (gentext-element-name (gi)))
			(if (string=? (element-label) "")
			    (literal nsep)
			    (literal " " (element-label) nsep))
			(element-title-sosofo))))
    (make element gi: "DIV"
	  attributes: (list
		       (list "CLASS" (gi)))
	  (make element gi: "P"
		(make element gi: "B"
		      (if id
			  (make element gi: "A"
				attributes: (list (list "NAME" id))
				titlesosofo)
			  titlesosofo)))
	  (process-children))))

(define ($semiformal-object$)
  ;; semiformal means optional title...
  (if (node-list-empty? (select-elements (children (current-node)) "TITLE"))
      ($informal-object$)
      ($formal-object$)))

(element EXAMPLE ($formal-object$))

(element (EXAMPLE TITLE) (empty-sosofo)) ; don't show caption below example
(element INFORMALEXAMPLE ($informal-object$))

(element (FIGURE TITLE) (empty-sosofo)) ; don't show caption below figure

(element FIGURE ($formal-object$))

(element INFORMALTABLE ($informal-object$))

(element TABLE ($formal-object$))

(element (TABLE TITLE) (empty-sosofo))
