;; $Id: dbrfntry.dsl,v 1.1 1998/02/18 13:13:48 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; =========================== REFERENCE PAGES ==========================

(element REFERENCE ($component$))

;; If each RefEntry begins on a new page, this title is going to wind
;; up on its own page, too, so make it a divtitlepage instead.  Otherwise,
;; just let it be a component title.
(element (REFERENCE TITLE) 
  (empty-sosofo))

(mode refentry-head-mode
  (element REFNAMEDIV
    (make element gi: "TITLE"
	  (literal
	   (data 
	    (node-list-first 
	     (children (current-node))))))))

(define ($refentry-body$)
  (make sequence 
    (make element gi: "H1"
	  (element-title-sosofo (current-node)))
    (process-children)))

(element REFENTRY
  (html-document (with-mode refentry-head-mode
		   (process-first-descendant "REFNAMEDIV"))
		 ($refentry-body$)))

(element REFMETA (empty-sosofo))

(element MANVOLNUM 
  (if %refentry-function%
      (sosofo-append
       (literal "(")
       (process-children)
       (literal ")"))
      (process-children)))

(element REFMISCINFO (empty-sosofo))

(element REFENTRYTITLE ($charseq$))

(element REFNAMEDIV
  (make element gi: "P"
	(process-children)))

(element REFNAME
  (make sequence
    (if (and %refentry-generate-name% (first-sibling? (current-node)))
 	($lowtitlewithsosofo$ 2 (literal (gentext-element-name 
					  (gi (current-node)))))
 	(empty-sosofo))
    (make sequence
	  (process-children)
 	  (if (last-sibling? (current-node))
 	      (empty-sosofo)
	      (literal (gentext-intra-label-sep (gi (current-node))))))))

(element REFPURPOSE
  (make sequence
    (literal " \em-dash ")
    (process-children)))
	
(element REFDESCRIPTOR (empty-sosofo)) ;; TO DO: finish this

(element REFCLASS
  (let ((role (attribute-string "role")))
    (make element gi: "P"
	  (make element gi: "B"
		(literal
		 (if role
		     (string-append role ": ")
		     "")))
	  (process-children-trim))))

(element REFSYNOPSISDIV
  ($block-container$))

(element (REFSYNOPSISDIV TITLE) ($lowtitle$ 2))
(element REFSECT1 ($block-container$))
(element (REFSECT1 TITLE) ($lowtitle$ 2))
(element REFSECT2 ($block-container$))
(element (REFSECT2 TITLE) ($lowtitle$ 3))
(element REFSECT3 ($block-container$))
(element (REFSECT3 TITLE) ($lowtitle$ 4))


