;; $Id: dbsynop.dsl,v 1.2 1998/03/26 12:43:39 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= SYNTAX DEFINITIONS =========================

(element SYNOPSIS ($verbatim-display$ %number-synopsis-lines%))
(element CMDSYNOPSIS ($paragraph$))

;; Support for ARG provided by James Bostock, augmented by norm
;;
(element GROUP
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (first-sibling? (current-node))
	  (literal (inherited-attribute-string "sepchar"))
	  (empty-sosofo))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-open-str%))
	(("REQ") (literal %arg-choice-req-open-str%))
	(("OPT") (literal %arg-choice-opt-open-str%))
	(else (literal %arg-choice-def-open-str%)))
      (process-children)
      (case rep
	(("REPEAT") (literal %arg-rep-repeat-str%))
	(("NOREPEAT") (literal %arg-rep-norepeat-str%))
	(else (literal %arg-rep-def-str%)))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-close-str%))
	(("REQ") (literal %arg-choice-req-close-str%))
	(("OPT") (literal %arg-choice-opt-close-str%))
	(else (literal %arg-choice-def-close-str%)))
      (literal " "))))

(element ARG
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (first-sibling? (current-node))
	  (literal (inherited-attribute-string "sepchar"))
	  (empty-sosofo))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-open-str%))
	(("REQ") (literal %arg-choice-req-open-str%))
	(("OPT") (literal %arg-choice-opt-open-str%))
	(else (literal %arg-choice-def-open-str%)))
      (process-children)
      (case rep
	(("REPEAT") (literal %arg-rep-repeat-str%))
	(("NOREPEAT") (literal %arg-rep-norepeat-str%))
	(else (literal %arg-rep-def-str%)))
      (case choice
	(("PLAIN") (literal %arg-choice-plain-close-str%))
	(("REQ") (literal %arg-choice-req-close-str%))
	(("OPT") (literal %arg-choice-opt-close-str%))
	(else (literal %arg-choice-def-close-str%)))
      (literal " "))))

(element (GROUP ARG)
  (let ((choice (attribute-string "Choice"))
	(rep (attribute-string "Rep")))
    (make sequence
      (if (not (first-sibling? (current-node)))
	  (literal %arg-or-sep%)
	  (empty-sosofo))
      (process-children))))

(element SBR 
  (make empty-element gi: "BR"))

(element SYNOPFRAGMENTREF ($paragraph$))
(element SYNOPFRAGMENT (process-children))

(element FUNCSYNOPSIS (process-children))

(element FUNCSYNOPSISINFO ($verbatim-display$ %number-funcsynopsisinfo-lines%))

(element FUNCPROTOTYPE 
  (let ((paramdefs (select-elements (children (current-node)) "PARAMDEF")))
    (make sequence
      (make element gi: "P"
	    (make element gi: "TT"
		  (process-children)
		  (if (equal? %funcsynopsis-style% 'kr)
		      (with-mode ansi-funcsynopsis-mode
			(process-node-list paramdefs))
		      (empty-sosofo)))))))

(element FUNCDEF (process-children))
(element (FUNCDEF FUNCTION) (process-children))

(element VOID 
  (if (equal? %funcsynopsis-style% 'ansi)
      (literal "(void);")
      (literal "();")))

(element VARARGS (literal "(...);"))

(element PARAMDEF
  (let ((param (select-elements (children (current-node)) "PARAMETER")))
    (make sequence
      (if (equal? (child-number (current-node)) 1)
	  (literal "(")
	  (empty-sosofo))
      (if (equal? %funcsynopsis-style% 'ansi)
	  (process-children)
	  (process-node-list param))
      (if (equal? (gi (ifollow (current-node))) "PARAMDEF")
	  (literal ", ")
	  (literal ");")))))
  
(element (PARAMDEF PARAMETER)
  (process-children))

(element FUNCPARAMS 
  (make sequence 
    (literal "(")
    (process-children)
    (literal ")")))

(mode ansi-funcsynopsis-mode
  (element PARAMDEF
    (make sequence
      (make empty-element gi: "BR")
      (process-children) 
      (literal ";"))))

