;; $Id: dbgloss.dsl,v 1.1 1998/02/18 13:14:11 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= GLOSSARY ELEMENTS ==========================

(element GLOSSARY ($component$))
(element (GLOSSARY TITLE) (empty-sosofo))

(element GLOSSDIV ($section$))
(element (GLOSSDIV TITLE) (empty-sosofo))

(element GLOSSLIST ($block-container$))
(element GLOSSENTRY ($para-container$))

;; a glossentry glossterm
(element (GLOSSENTRY GLOSSTERM) ($lowtitle$ 3))
(element (GLOSSENTRY ACRONYM) (empty-sosofo))
(element (GLOSSENTRY ABBREV) (empty-sosofo))
(element GLOSSDEF ($indent-para-container$))

(element GLOSSSEE ($italic-seq$))

(element (GLOSSENTRY GLOSSSEE)
  (let ((otherterm (attribute-string "OTHERTERM")))
    (make paragraph
      space-before: %para-sep%
      space-after: %para-sep%
      start-indent: (+ (inherited-start-indent) (* (ILSTEP) 2))
      quadding: %default-quadding%
      ($italic-seq$ (literal (gentext-element-name (gi))
			     (gentext-label-title-sep (gi))))
      (if otherterm
	  (make link 
	    destination: (node-list-address (element-with-id otherterm))
	    (with-mode otherterm
	      (process-element-with-id otherterm)))
	  (process-children)))))

;; When we hit the first GLOSSSEEALSO, process all of them as a node-list
(element GLOSSSEEALSO
  (if (first-sibling?)
      (make paragraph
	($italic-seq$ (literal (gentext-element-name (gi))
			       (gentext-label-title-sep (gi))))
	(with-mode glossseealso
	  (process-node-list
	   (select-elements (children (parent)) '(glossseealso))))
	(literal "."))
      (empty-sosofo)))

(mode glossseealso

  (element GLOSSSEEALSO
    (let ((otherterm (attribute-string "OTHERTERM")))
      (make sequence
	(if (first-sibling?)
	    (empty-sosofo)
	    ($italic-seq$ (literal ", ")))

	(if otherterm ;; but this should be required...
	    (make link 
	      destination: (node-list-address (element-with-id otherterm))
	      (with-mode otherterm
		(process-element-with-id otherterm)))
	    (process-children)))))

)

;; This is referenced within the GLOSSSEE and GLOSSSEEALSO element
;; construction expressions.  The OTHERTERM attributes on GLOSSSEE and
;; GLOSSSEEALSO (should) refer to GLOSSENTRY elements but we're only
;; interested in the text within the GLOSSTERM.  Discard the revision
;; history and the definition from the referenced term.
(mode otherterm
  (element GLOSSENTRY
    (process-children))
  (element GLOSSTERM
    (process-children))
  (element GLOSSDEF
    (empty-sosofo))
  (element REVHISTORY
    (empty-sosofo))
  (element GLOSSSEE
    (empty-sosofo))
  (element (GLOSSENTRY ACRONYM)
    (empty-sosofo))
  (element (GLOSSENTRY ABBREV)
    (empty-sosofo)))

;; an inline gloss term
(element GLOSSTERM ($italic-seq$))

