;; $Id: dbrfntry.dsl,v 1.1 1998/02/18 13:14:20 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; =========================== REFERENCE PAGES ==========================

(element REFERENCE ($component$))

;; If each RefEntry begins on a new page, this title is going to wind
;; up on its own page, too, so make it a divtitlepage instead.  Otherwise,
;; just let it be a component title.
(element (REFERENCE TITLE) (empty-sosofo))
;;  (if %refentry-new-page%
;;      ($divtitlepage$)
;;      (empty-sosofo)))

(element REFENTRY 
  (make display-group
    keep: %refentry-keep%
    (if %refentry-new-page%
	(make simple-page-sequence
	  page-number-format: ($page-number-format$)
	  use: para-style ;; set defaults for text in this simple page sequence
	  left-header:   ($left-header$)
	  center-header: ($center-header$)
	  right-header:  ($right-header$)
	  left-footer:   ($left-footer$)
	  center-footer: ($center-footer$)
	  right-footer:  ($right-footer$)
	  input-whitespace-treatment: 'collapse
	  quadding: %default-quadding%
	  ($refentry-title$)
	  (process-children))
	(make sequence
	  ($refentry-title$)
	  ($block-container$)))
    (make-endnotes)))

(define ($refentry-title$)
  (let* ((refentrytitle (select-elements (descendants (current-node)) 
					 "REFENTRYTITLE"))
	 (refdescriptor (select-elements (descendants (current-node)) 
					 "REFDESCRIPTOR"))
	 (refname       (select-elements (descendants (current-node)) 
					 "REFNAME"))
	 (title         (if (node-list-empty? refentrytitle)
			    (if (node-list-empty? refdescriptor)
				(node-list-first refname)
				refdescriptor)
			    refentrytitle))
	 (slevel (SECTLEVEL)) ;; the true level in the section hierarchy
	 (hlevel (if (> slevel 2) 2 slevel)) ;; limit to sect2 equiv.
	 (hs (HSIZE (- 4 hlevel))))

    (make paragraph
      font-family-name: %title-font-family%
      font-weight: 'bold
      font-size: hs
      line-spacing: (* hs %line-spacing-factor%)
      space-before: (* hs %head-before-factor%)
      space-after: (* hs %head-after-factor%)
      start-indent: %body-start-indent%
      first-line-start-indent: (- %body-start-indent%)
      quadding: 'start
      keep-with-next?: #t
      (process-node-list (children title))
      (if %refentry-function%
	  (sosofo-append
	   (literal " ")
	   (process-first-descendant "MANVOLNUM"))
	  (empty-sosofo)))))

(element REFMETA (empty-sosofo)) ;; handled by $refentry-title$

(element MANVOLNUM 
  (if %refentry-function%
      (sosofo-append
       (literal "(")
       (process-children)
       (literal ")"))
      (process-children)))

(element REFMISCINFO (empty-sosofo))

(element REFENTRYTITLE ($charseq$))

(element REFNAMEDIV
  (make paragraph
	use: para-style
	space-before: %para-sep%
	start-indent: %body-start-indent%
	quadding: 'start
	(process-children)))

(element REFNAME
  (make sequence
    (if (and %refentry-generate-name% (first-sibling? (current-node)))
 	($lowtitlewithsosofo$ 1 (literal (gentext-element-name 
					  (gi (current-node)))))
 	(empty-sosofo))
    (make sequence
	  font-weight: 'medium
	  font-family-name: %refentry-name-font-family%
	  (process-children)
 	  (if (last-sibling? (current-node))
 	      (empty-sosofo)
	      (literal (gentext-intra-label-sep (gi (current-node))))))))

(element REFPURPOSE
  (make sequence
        font-family-name: %body-font-family%
    (make sequence
      (literal " \em-dash ")
      (process-children))
    (make paragraph-break)))
	
(element REFDESCRIPTOR (empty-sosofo))

(element REFCLASS
  (let ((role (attribute-string "role")))
    (make paragraph
	  use: para-style
	  space-before: %para-sep%
	  start-indent: %body-start-indent%
	  quadding: 'start
	  (make sequence
		font-weight: 'bold
		(literal
		  (if role
		      (string-append role ": ")
		      "")))
	  (process-children-trim))))

(element REFSYNOPSISDIV
  (make paragraph
	use: para-style
	space-before: %para-sep%
	start-indent: %body-start-indent%
	lines: 'asis
	font-family-name: %mono-font-family%
	(process-children)))

(element (REFSYNOPSISDIV TITLE) ($lowtitle$ 1))

(element REFSECT1 ($section$))
(element (REFSECT1 TITLE) (empty-sosofo))
(element REFSECT2 ($section$))
(element (REFSECT2 TITLE) (empty-sosofo))
(element REFSECT3 ($section$))
(element (REFSECT3 TITLE) (empty-sosofo))


