;; $Id: dbl1sv.dsl,v 1.1.1.1 1999/01/28 15:21:19 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x 
;; keywords.
;;

(define (sv-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "&Appendix; som &called; %t"))

(define (sv-article-xref-string gi-or-name)
  (string-append %gentext-sv-start-quote%
		 "%t"
		 %gentext-sv-end-quote%))

(define (sv-bibliography-xref-string gi-or-name)
  "%t")

(define (sv-book-xref-string gi-or-name)
  "%t")

(define (sv-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "&Chapter; som &called; %t"))

(define (sv-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (sv-example-xref-string gi-or-name)
  "&Example; %n")

(define (sv-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (sv-listitem-xref-string gi-or-name)
  "%n")

(define (sv-part-xref-string gi-or-name)
  "&Part; %n")

(define (sv-preface-xref-string gi-or-name)
  "%t")

(define (sv-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (sv-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "&Section; som &called; %t"))

(define (sv-sect1-xref-string gi-or-name)
  (sv-section-xref-string gi-or-name))

(define (sv-sect2-xref-string gi-or-name)
  (sv-section-xref-string gi-or-name))

(define (sv-sect3-xref-string gi-or-name)
  (sv-section-xref-string gi-or-name))

(define (sv-sect4-xref-string gi-or-name)
  (sv-section-xref-string gi-or-name))

(define (sv-sect5-xref-string gi-or-name)
  (sv-section-xref-string gi-or-name))

(define (sv-step-xref-string gi-or-name)
  "&step; %n")

(define (sv-table-xref-string gi-or-name)
  "&Table; %n")

(define (sv-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-sv-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (sv-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (sv-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (sv-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (sv-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (sv-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (sv-equation-xref-string gind))
      ((equal? name (normalize "example"))  (sv-example-xref-string gind))
      ((equal? name (normalize "figure"))   (sv-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (sv-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (sv-part-xref-string gind))
      ((equal? name (normalize "preface"))  (sv-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (sv-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (sv-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (sv-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (sv-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (sv-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (sv-sect5-xref-string gind))
      ((equal? name (normalize "step"))     (sv-step-xref-string gind))
      ((equal? name (normalize "table"))    (sv-table-xref-string gind))
      (else (sv-default-xref-string gind)))))

(define (sv-auto-xref-indirect-connector before) 
  ;; In English, the (cond) is unnecessary since the word is always the
  ;; same, but in other languages, that's not the case.  I've set this
  ;; one up with the (cond) so it stands as an example.
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " in "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " in "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " in "))
   (else
    (literal " in "))))

;; Should the TOC come first or last?
;;
(define %generate-sv-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define sv-abstract-name	"&Abstract;")
(define sv-appendix-name	"&Appendix;")
(define sv-article-name	"&Article;")
(define sv-bibliography-name	"&Bibliography;")
(define sv-book-name		"&Book;")
(define sv-calloutlist-name	"")
(define sv-caution-name	"&Caution;")
(define sv-chapter-name	"&Chapter;")
(define sv-copyright-name	"&Copyright;")
(define sv-dedication-name	"&Dedication;")
(define sv-edition-name	"&Edition;")
(define sv-equation-name	"&Equation;")
(define sv-example-name	"&Example;")
(define sv-figure-name	"&Figure;")
(define sv-glossary-name	"&Glossary;")
(define sv-glosssee-name	"&GlossSee;")
(define sv-glossseealso-name	"&GlossSeeAlso;")
(define sv-important-name	"&Important;")
(define sv-index-name		"&Index;")
(define sv-setindex-name	"&SetIndex;")
(define sv-isbn-name		"&ISBN;")
(define sv-legalnotice-name	"&LegalNotice;")
(define sv-msgaud-name	"&MsgAud;")
(define sv-msglevel-name	"&MsgLevel;")
(define sv-msgorig-name	"&MsgOrig;")
(define sv-note-name		"&Note;")
(define sv-part-name		"&Part;")
(define sv-preface-name	"&Preface;")
(define sv-procedure-name	"&Procedure;")
(define sv-pubdate-name	"&Published;")
(define sv-reference-name	"&Reference;")
(define sv-refname-name	"&RefName;")
(define sv-revhistory-name	"&RevHistory;")
(define sv-revision-name	"&Revision;")
(define sv-sect1-name		"&Section;")
(define sv-sect2-name		"&Section;")
(define sv-sect3-name		"&Section;")
(define sv-sect4-name		"&Section;")
(define sv-sect5-name		"&Section;")
(define sv-simplesect-name	"&Section;")
(define sv-seeie-name		"&See;")
(define sv-seealsoie-name	"&Seealso;")
(define sv-set-name		"&Set;")
(define sv-sidebar-name	"&Sidebar;")
(define sv-step-name		"&step;")
(define sv-table-name		"&Table;")
(define sv-tip-name		"&Tip;")
(define sv-toc-name		"&TableofContents;")
(define sv-warning-name	"&Warning;")

(define (gentext-sv-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	sv-abstract-name)
     ((equal? name (normalize "appendix"))	sv-appendix-name)
     ((equal? name (normalize "article"))	sv-article-name)
     ((equal? name (normalize "bibliography"))	sv-bibliography-name)
     ((equal? name (normalize "book"))		sv-book-name)
     ((equal? name (normalize "calloutlist"))	sv-calloutlist-name)
     ((equal? name (normalize "caution"))	sv-caution-name)
     ((equal? name (normalize "chapter"))	sv-chapter-name)
     ((equal? name (normalize "copyright"))	sv-copyright-name)
     ((equal? name (normalize "dedication"))	sv-dedication-name)
     ((equal? name (normalize "edition"))	sv-edition-name)
     ((equal? name (normalize "equation"))	sv-equation-name)
     ((equal? name (normalize "example"))	sv-example-name)
     ((equal? name (normalize "figure"))	sv-figure-name)
     ((equal? name (normalize "glossary"))	sv-glossary-name)
     ((equal? name (normalize "glosssee"))	sv-glosssee-name)
     ((equal? name (normalize "glossseealso"))	sv-glossseealso-name)
     ((equal? name (normalize "important"))	sv-important-name)
     ((equal? name (normalize "index"))		sv-index-name)
     ((equal? name (normalize "setindex"))	sv-setindex-name)
     ((equal? name (normalize "isbn"))		sv-isbn-name)
     ((equal? name (normalize "legalnotice"))	sv-legalnotice-name)
     ((equal? name (normalize "msgaud"))	sv-msgaud-name)
     ((equal? name (normalize "msglevel"))	sv-msglevel-name)
     ((equal? name (normalize "msgorig"))	sv-msgorig-name)
     ((equal? name (normalize "note"))		sv-note-name)
     ((equal? name (normalize "part"))		sv-part-name)
     ((equal? name (normalize "preface"))	sv-preface-name)
     ((equal? name (normalize "procedure"))	sv-procedure-name)
     ((equal? name (normalize "pubdate"))	sv-pubdate-name)
     ((equal? name (normalize "reference"))	sv-reference-name)
     ((equal? name (normalize "refname"))	sv-refname-name)
     ((equal? name (normalize "revhistory"))	sv-revhistory-name)
     ((equal? name (normalize "revision"))	sv-revision-name)
     ((equal? name (normalize "sect1"))		sv-sect1-name)
     ((equal? name (normalize "sect2"))		sv-sect2-name)
     ((equal? name (normalize "sect3"))		sv-sect3-name)
     ((equal? name (normalize "sect4"))		sv-sect4-name)
     ((equal? name (normalize "sect5"))		sv-sect5-name)
     ((equal? name (normalize "simplesect"))    sv-simplesect-name)
     ((equal? name (normalize "seeie"))		sv-seeie-name)
     ((equal? name (normalize "seealsoie"))	sv-seealsoie-name)
     ((equal? name (normalize "set"))		sv-set-name)
     ((equal? name (normalize "sidebar"))	sv-sidebar-name)
     ((equal? name (normalize "step"))		sv-step-name)
     ((equal? name (normalize "table"))		sv-table-name)
     ((equal? name (normalize "tip"))		sv-tip-name)
     ((equal? name (normalize "toc"))		sv-toc-name)
     ((equal? name (normalize "warning"))	sv-warning-name)
     (else (let* ((msg (string-append "&unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-sv-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define sv-equation-intra-label-sep "-")
(define sv-example-intra-label-sep "-")
(define sv-figure-intra-label-sep "-")
(define sv-procedure-intra-label-sep ".")
(define sv-refentry-intra-label-sep ".")
(define sv-reference-intra-label-sep ".")
(define sv-refname-intra-label-sep ", ")
(define sv-refsect1-intra-label-sep ".")
(define sv-refsect2-intra-label-sep ".")
(define sv-refsect3-intra-label-sep ".")
(define sv-sect1-intra-label-sep ".")
(define sv-sect2-intra-label-sep ".")
(define sv-sect3-intra-label-sep ".")
(define sv-sect4-intra-label-sep ".")
(define sv-sect5-intra-label-sep ".")
(define sv-step-intra-label-sep ".")
(define sv-table-intra-label-sep "-")
(define sv-_pagenumber-intra-label-sep "-")
(define sv-default-intra-label-sep "")

(define (gentext-sv-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	sv-equation-intra-label-sep)
     ((equal? name (normalize "example"))	sv-example-intra-label-sep)
     ((equal? name (normalize "figure"))	sv-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	sv-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	sv-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	sv-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	sv-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	sv-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	sv-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	sv-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		sv-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		sv-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		sv-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		sv-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		sv-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		sv-step-intra-label-sep)
     ((equal? name (normalize "table"))		sv-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	sv-_pagenumber-intra-label-sep)
     (else sv-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define sv-abstract-label-title-sep ": ")
(define sv-appendix-label-title-sep ". ")
(define sv-caution-label-title-sep "")
(define sv-chapter-label-title-sep ". ")
(define sv-equation-label-title-sep ". ")
(define sv-example-label-title-sep ". ")
(define sv-figure-label-title-sep ". ")
(define sv-footnote-label-title-sep ". ")
(define sv-glosssee-label-title-sep ": ")
(define sv-glossseealso-label-title-sep ": ")
(define sv-important-label-title-sep ": ")
(define sv-note-label-title-sep ": ")
(define sv-orderedlist-label-title-sep ". ")
(define sv-part-label-title-sep ". ")
(define sv-procedure-label-title-sep ". ")
(define sv-prefix-label-title-sep ". ")
(define sv-refentry-label-title-sep "")
(define sv-reference-label-title-sep ". ")
(define sv-refsect1-label-title-sep ". ")
(define sv-refsect2-label-title-sep ". ")
(define sv-refsect3-label-title-sep ". ")
(define sv-sect1-label-title-sep ". ")
(define sv-sect2-label-title-sep ". ")
(define sv-sect3-label-title-sep ". ")
(define sv-sect4-label-title-sep ". ")
(define sv-sect5-label-title-sep ". ")
(define sv-seeie-label-title-sep " ")
(define sv-seealsoie-label-title-sep " ")
(define sv-step-label-title-sep ". ")
(define sv-table-label-title-sep ". ")
(define sv-tip-label-title-sep ": ")
(define sv-warning-label-title-sep "")
(define sv-default-label-title-sep "")

(define (gentext-sv-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) sv-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) sv-appendix-label-title-sep)
     ((equal? name (normalize "caution")) sv-caution-label-title-sep)
     ((equal? name (normalize "chapter")) sv-chapter-label-title-sep)
     ((equal? name (normalize "equation")) sv-equation-label-title-sep)
     ((equal? name (normalize "example")) sv-example-label-title-sep)
     ((equal? name (normalize "figure")) sv-figure-label-title-sep)
     ((equal? name (normalize "footnote")) sv-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) sv-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) sv-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) sv-important-label-title-sep)
     ((equal? name (normalize "note")) sv-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) sv-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) sv-part-label-title-sep)
     ((equal? name (normalize "procedure")) sv-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) sv-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) sv-refentry-label-title-sep)
     ((equal? name (normalize "reference")) sv-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) sv-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) sv-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) sv-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) sv-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) sv-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) sv-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) sv-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) sv-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) sv-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) sv-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) sv-step-label-title-sep)
     ((equal? name (normalize "table")) sv-table-label-title-sep)
     ((equal? name (normalize "tip")) sv-tip-label-title-sep)
     ((equal? name (normalize "warning")) sv-warning-label-title-sep)
     (else sv-default-label-title-sep))))

(define (sv-set-label-number-format gind) "1")
(define (sv-book-label-number-format gind) "1")
(define (sv-prefix-label-number-format gind) "1")
(define (sv-part-label-number-format gind) "I")
(define (sv-chapter-label-number-format gind) "1")
(define (sv-appendix-label-number-format gind) "A")
(define (sv-reference-label-number-format gind) "I")
(define (sv-example-label-number-format gind) "1")
(define (sv-figure-label-number-format gind) "1")
(define (sv-table-label-number-format gind) "1")
(define (sv-procedure-label-number-format gind) "1")
(define (sv-step-label-number-format gind) "1")
(define (sv-refsect1-label-number-format gind) "1")
(define (sv-refsect2-label-number-format gind) "1")
(define (sv-refsect3-label-number-format gind) "1")
(define (sv-sect1-label-number-format gind) "1")
(define (sv-sect2-label-number-format gind) "1")
(define (sv-sect3-label-number-format gind) "1")
(define (sv-sect4-label-number-format gind) "1")
(define (sv-sect5-label-number-format gind) "1")
(define (sv-default-label-number-format gind) "1")

(define (sv-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (sv-set-label-number-format gind))
     ((equal? name (normalize "book")) (sv-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (sv-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (sv-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (sv-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (sv-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (sv-reference-label-number-format gind))
     ((equal? name (normalize "example")) (sv-example-label-number-format gind))
     ((equal? name (normalize "figure")) (sv-figure-label-number-format gind))
     ((equal? name (normalize "table")) (sv-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (sv-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (sv-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (sv-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (sv-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (sv-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (sv-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (sv-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (sv-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (sv-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (sv-sect5-label-number-format gind))
     (else (sv-default-label-number-format gind)))))

(define ($lot-title-sv$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-sv-start-quote% (dingbat "ldquo"))

(define %gentext-sv-end-quote% (dingbat "rdquo"))

(define %gentext-sv-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-sv-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-sv-page% "")

(define %gentext-sv-and% "&and;")

(define %gentext-sv-bibl-pages% "&Pgs;")

(define %gentext-sv-endnotes% "&Notes;")

(define %gentext-sv-table-endnotes% "&TableNotes;:")

(define %gentext-sv-index-see% "&See;")

(define %gentext-sv-index-seealso% "&SeeAlso;")

