//==========================================================================
//
//      gmd.h
//
//      eCos interface to MOTOROLA General Market CMF driver for MPC555
//
//==========================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   Bob Koninckx
// Contributors:Bob Koninckx
// Date:        2001-12-22
// Purpose:     eCos interface to motorola General market CMF driver for 
//              MPC555
// Description:
//
//####DESCRIPTIONEND####
//
//==========================================================================

#ifndef CYGONCE_GMD_H
#define CYGONCE_GMD_H

#include <cyg/infra/cyg_type.h>

//-------------------------- CMF Descriptor ---------------------------
typedef struct
{                                       
  volatile cyg_uint32 * cmfMCR;           // Pointer to CMFMCR register
  volatile cyg_uint32 * cmfTST;           // Pointer to CMFTST register
  volatile cyg_uint32 * cmfCTL;           // Pointer to CMFCTL register
  cyg_uint32            cmfMCRInit;       // initial value for CMFMCR
} tCMF_MODULE;

//------------------------- Part Definition ---------------------------
#define CMF_MODULES          2            // CMF module number in MPC555

typedef struct
{
  tCMF_MODULE cmf[CMF_MODULES];           // array of modules structures
  cyg_uint32  arrayBase;                  // CMF array base address
  cyg_uint32  pulseCnt;                   // pulse counts for erase
                                          // or whole program pageset
  cyg_uint8   enabledBlocks[CMF_MODULES]; // array of enabled block flags
  cyg_uint8   enableBDM;                  // enter BDM flag
  cyg_uint8   reserved;                   // reserved for paddding
} tCMF_PART;

//--------------------- Program Algorithm Data -------------------------
#define CMF_PPS             9             // number of program PAWS steps
#define NORMAL_PROGRAM_ALG  0x00          // perform normal program alg

typedef struct
{
  cyg_uint32 oscClk;                      // magnified Oscillator clock
  cyg_uint32 sysClk;                      // magnified expected system
	                                  // clock
  cyg_uint32 ctlProg[CMF_PPS];            // CMFCTL program timing data
  cyg_uint16 pawsProgData[CMF_PPS];       // NVR, GDB, & PAWS prog data
  cyg_uint16 pawsProgPulses[CMF_PPS];     // pulse count per voltage step
  cyg_uint8  pawsProgMode[CMF_PPS];       // program alg mode control
  cyg_uint8  reserved;                    // reserved for paddding
  cyg_uint16 maxProgramPulses;            // maximum of program pulses
} tCMF_PROGRAM_DATA;

//---------------------- Erase Algorithm Data --------------------------
#define CMF_EPS             9             // number of erase PAWS steps
#define NORMAL_ERASE_ALG    0x00          // perform normal erase alg
#define IGNORE_EMR          0x80          // ignore erase margin reads

typedef struct
{
  cyg_uint32 oscClk;                      // magnified Oscillator clock
  cyg_uint32 sysClk;                      // magnified expected system
	                                  // clock
  cyg_uint32 ctlErase[CMF_EPS];           // CMFCTL erase timing data
  cyg_uint16 pawsEraseData[CMF_EPS];      // NVR, GDB, & PAWS erase data
  cyg_uint16 pawsErasePulses[CMF_EPS];    // pulse count per voltage step
  cyg_uint8  pawsEraseMode[CMF_EPS];      // erase alg mode control
  cyg_uint8  reserved;                    // reserved for paddding
  cyg_uint16 maxErasePulses;              // maximum  of erase pulses
} tCMF_ERASE_DATA;

/*----------------------- Comparison Return Data ------------------------*/
typedef struct
{
  cyg_uint32 failingAddr;
  cyg_uint32 failingDestData;
  cyg_uint32 failingSourceData;
} tCMF_COMP_DATA;

//------------------------------------------------------------------------
// Return codes
#define CMF_OK                                  0x00

#define CMF_ERROR_ARRAY_EMR_FAIL                0x05
#define CMF_ERROR_SHADOW_EMR_FAIL               0x06
#define CMF_ERROR_ARRAY_PMR_FAIL                0x07
#define CMF_ERROR_SHADOW_PMR_FAIL               0x08
#define CMF_ERROR_NOT_BLANK                     0x09
#define CMF_ERROR_SRC_DEST_VERIFY               0x0A
#define CMF_ERROR_PROTECTED_BLOCK               0x0B

#define CMF_ERROR_CENSOR_DEVICE_MODE            0x0D
#define CMF_ERROR_CENSOR_MODULE                 0x0E
#define CMF_ERROR_CENSOR_INVALID_REQUEST        0x0F
#define CMF_ERROR_CENSOR_CHANGE                 0x10
#define CMF_ERROR_CENSOR_VALUE                  0x11
#define CMF_ERROR_SHADOW_RANGE                  0x12
#define CMF_ERROR_ALIGNMENT                     0x13
#define CMF_ERROR_ARRAY_RANGE                   0x14
#define CMF_ERROR_SYSCLK_MISMATCH               0x15

//----------Bit masks for return value of ParallelInit--------------------
#define CMF_INFO_CTRL_REGS_INIT_A               0x80
#define CMF_INFO_CTRL_REGS_INIT_B               0x40
#define CMF_INFO_NO_VPP_A                       0x20
#define CMF_INFO_NO_VPP_B                       0x10
#define CMF_INFO_CENSOR_MODULE_A                0x08
#define CMF_INFO_CENSOR_MODULE_B                0x04
#define CMF_INFO_INVALID_ARRAY_BASE             0x02
#define CMF_INFO_BACKUP_CLOCK                   0x01

//------------------------Block Masks-------------------------------------
#define CMF_ENABLED_BLOCKS_A                    0xFF
#define CMF_ENABLED_BLOCKS_B                    0xFC

//----------------------------- Part Specifics ---------------------------
#define MAIN_ARRAY                              0
#define SHADOW_ROW                              1
#define CMF_MODULE_A                            0
#define CMF_MODULE_B                            1
#define WORD_SIZE                               4
#define BLOCKS_IN_MODULE_A                      8
#define BLOCKS_IN_MODULE_B                      6
#define TOTAL_BLOCKS                            (BLOCKS_IN_MODULE_A+BLOCKS_IN_MODULE_B)
#define PROGRAM_BUFFER_SIZE                     64
#define PAGE_SIZE                               (PROGRAM_BUFFER_SIZE)
#define SHADOW_SIZE                             0x100
#define SHADOW_ROW_MASK                         0x8080
#define BLOCK_SIZE                              0x8000
#define MODULE_A_SIZE                           (BLOCKS_IN_MODULE_A*BLOCK_SIZE)
#define MAX_PAGESET_NUM                         (BLOCK_SIZE/PAGE_SIZE)
#define MAX_PAGESET_NUM_OF_SHADOW               (SHADOW_SIZE/PAGE_SIZE)

//--------------------------Module Specifics---------------------------
#define CLEARED_CENSORSHIP                      0
#define NO_CENSORSHIP1                          1
#define NO_CENSORSHIP2                          2
#define INFORMATION_CENSORSHIP                  3

#define DEVICE_CENSORED                         0
#define DEVICE_UNCENSORED                       1
#define STATE_MACHINE                           0x7998
#define STATE_MASK                              0x8000

//----------------------Offset in bytes for GMD IO---------------------
#define GMDIO_OFFSET_PART_DESCRIPTION           0
#define GMDIO_OFFSET_PROGRAM_DATA               2
#define GMDIO_OFFSET_ERASE_DATA                 4
#define GMDIO_OFFSET_CENSOR_DATA                4
#define GMDIO_OFFSET_COMP_DATA                  6

//------------------------MPC555 Register Masks---------------------------
#define MPC555_SCCR_BUCS                       0x00080000
#define MPC555_SCCR_DFNH                       0x07
#define MPC555_SCCR_DFNL                       0x70

#define MPC555_PLPRCR_MF                       0xFFF00000
#define MPC555_PLPRCR_DIVF                     0x0000001F
#define MPC555_PLPRCR_CSRC                     0x00000400

#define MPC555_IMMR_ISB_MASK                   0x0000000E

#define CMFMCR_SIE_MASK                        0x08000000
#define CMFMCR_LOCK_MASK                       0x80000000
#define CMFMCR_PROTECT_MASK                    0x000000FF
#define CMFMCR_ACCESS_MASK                     0x04000000
#define CMFMCR_FIC_MASK                        0x10000000
#define CMFMCR_CENSOR_MASK                     0x03000000

#define CMFCTL_HVS_MASK                        0x80000000
#define CMFCTL_BLOCKS_MASK                     0x0000FF00
#define CMFCTL_CSC_MASK                        0x00000040
#define CMFCTL_EPEE_MASK                       0x00000020
#define CMFCTL_PE_MASK                         0x00000004
#define CMFCTL_SES_MASK                        0x00000002
#define CMFCTL_EHV_MASK                        0x00000001

// Function interface
externC cyg_uint8 ParallelInit(tCMF_PART *cmfPart);
externC cyg_uint8 ParallelErase(tCMF_PART *cmfPart,
                                tCMF_ERASE_DATA *eraseData,
                                cyg_uint8 *enabledBlocks,
                                void (*CallBack)(void));
externC cyg_uint8 BlankCheck(tCMF_PART *cmfPart,
                             cyg_uint32 dest,
                             cyg_uint32 size,
                             cyg_uint8 shadow,
                             tCMF_COMP_DATA *cmfCompare,
                             void (*CallBack)(void));
externC cyg_uint8 ParallelProgram(tCMF_PART *cmfPart,
                                  tCMF_PROGRAM_DATA *programData,
                                  cyg_uint8 *enabledBlocks,
                                  cyg_uint32 source,
                                  cyg_uint32 offset,
                                  cyg_uint16 pagesetNum,
                                  cyg_uint8 shadow,
                                  void (*CallBack)(void));

#endif // CYGONCE_GMD_H

// -------------------------------------------------------------------------
// EOF gmd.h
