//=============================================================================
//
//      plf_misc.c
//
//      Platform miscellaneous code/data.
//
//=============================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   Bob Koninckx
// Contributors:Bob Koninckx
// Date:        2001-12-11
// Purpose:     Platform specific code and data
// Description: Tables for per-platform initialization
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal.h>
#include <cyg/hal/hal_mem.h>            // HAL memory definitions
#include <cyg/hal/hal_if.h>             // hal_if_init

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_intr.h>           // interrupt vectors
#include <cyg/hal/hal_misc.h>           // Helper functions
#include <cyg/hal/drv_api.h>            // HANDLED
#include <cyg/hal/hal_diag.h>

// The memory map is weakly defined, allowing the application to redefine
// it if necessary. Leave the table empty, the mpc555 has no cache ...
CYGARC_MEMDESC_TABLE CYGBLD_ATTRIB_WEAK = {
    CYGARC_MEMDESC_TABLE_END
};

void
hal_platform_init(void)
{  
  hal_if_init();

#if defined CYGSEM_HAL_VIRTUAL_VECTOR_DIAG  
  HAL_DIAG_INIT();
#endif
}

// EOF plf_misc.c
