/*
 * Copyright (c) 1996-2007 MIPS Technologies, Inc.
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *      * Redistributions of source code must retain the above copyright
 *        notice, this list of conditions and the following disclaimer.
 *      * Redistributions in binary form must reproduce the above
 *      copyright
 *        notice, this list of conditions and the following disclaimer
 *        in the documentation and/or other materials provided with
 *        the distribution.
 *      * Neither the name of MIPS Technologies Inc. nor the names of its
 *        contributors may be used to endorse or promote products derived
 *        from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
	
/*	
 * Originally written by Kjeld Borch Egevang <kjelde@mips.com>, 2002.
 * Performance improvements by Thiemo Seufer <ths@mips.com>, 2006.
 */
	
#include <mips/asm.h>
#include <mips/regdef.h>

	.set	nomips16

/* int strcmp(const char *s1, const char *s2); */

#if __mips > 1 && __mips != 32 && __mips != 64
#define BRANCHLIKELY 1
#endif

#ifdef __mips64
#define	SUBU	dsubu
#define	ADDIU	daddiu
#define	SLL	dsll
#define	SRL	dsrl
#else
#define	SUBU	subu
#define	ADDIU	addiu
#define	SLL	sll
#define	SRL	srl
#endif

#ifdef __MIPSEL__
#define PUSH	SLL
#define POP	SRL
#else
#define PUSH	SRL
#define POP	SLL
#endif

#if 0
/* This one is faster for a dual pipelined 20Kc */
#define	STRCMP_WORD(OFS)			\
	SUBU	t0, v0, t1			;\
	nor	t2, v0, ta3			;\
	bne	v0, v1, compare_word		;\
	 and	t0, t2				;\
	beql	t0, zero, 1f			;\
	 REG_L	v0, (OFS+1)*SZREG(a0)		;\
	jr	ra				;\
	 move	v0, zero			;\
1:	REG_L	v1, (OFS+1)*SZREG(a1)
#else
#define	STRCMP_WORD(OFS)			\
	SUBU	t0, v0, t1			;\
	nor	t2, v0, ta3			;\
	bne	v0, v1, compare_word		;\
	 and	t0, t2				;\
	bnez	t0, leave			;\
	 nop					;\
	REG_L	v0, (OFS+1)*SZREG(a0)		;\
	REG_L	v1, (OFS+1)*SZREG(a1)
#endif

#ifdef __mips64
	.sdata
	.align	4
c0101:	.dword	0x0101010101010101
	.previous
#endif

LEAF(strcmp)
	.set	noreorder

	or	t0, a0, a1		/* Check for unaligned strings */
#ifdef __mips64
	REG_L	t1, c0101
	andi	t0, SZREG - 1
	SLL	ta3, t1, 7
	bnez	t0, strcmp_byte
	 nor	ta3, zero, ta3
#else
	lui	t1, 0x0101
	andi	t0, SZREG - 1
	lui	ta3, 0x7f7f
	bnez	t0, strcmp_byte
	 ori	t1, 0x0101
	ori	ta3, 0x7f7f
#endif

strcmp_loop:
	REG_L	v0, 0x00(a0)
	REG_L	v1, 0x00(a1)
	STRCMP_WORD(0)
	STRCMP_WORD(1)
	STRCMP_WORD(2)
#ifndef __mips64
	STRCMP_WORD(3)
	STRCMP_WORD(4)
	STRCMP_WORD(5)
	STRCMP_WORD(6)
#endif
	SUBU	t0, v0, t1
	nor	t2, v0, ta3
	bne	v0, v1, compare_word
	 and	t0, t2
	ADDIU	a0, 32
	beqz	t0, strcmp_loop
	 ADDIU	a1, 32
leave:
	jr	ra
	 move	v0, zero

compare_word:
	/* Figure out where the bad bytes are, indicated by set bits
	   in t3. t0 holds already the null detection pattern for v0. */
	xor	t2, v0, v1
	or	t3, t2, t0

	/* Isolate the first bad byte. */
#ifdef __mips64
	PUSH	ta2, t3, (SZREG * 8) - 32
	bnez	ta2, 1f
	 nop
	POP	t3, 32
	POP	v0, 32
	POP	v1, 32
1:
#endif
	PUSH	ta2, t3, (SZREG * 8) - 16
	bnez	ta2, 1f
	 nop
	POP	t3, 16
	POP	v0, 16
	POP	v1, 16
1:	PUSH	ta2, t3, (SZREG * 8) - 8
	bnez	ta2, 1f
	 nop
	POP	v0, 8
	POP	v1, 8
1:	PUSH	v0, (SZREG * 8) - 8
	PUSH	v1, (SZREG * 8) - 8
9:	jr	ra
	 SUBU	v0, v0, v1


#ifdef BRANCHLIKELY
#define	STRCMP_T0T1(OFS)	\
	bnel	t0, zero, 8f	;\
	 lbu	t2, OFS(a0)	;\
	jr	ra		;\
	 SUBU	v0, t0, t1	;\
8:	beql	t0, t1, 8f	;\
	 lbu	t3, OFS(a1)	;\
	jr	ra		;\
	 SUBU	v0, t0, t1	;\
8:

#define	STRCMP_T2T3(OFS)	\
	bnel	t2, zero, 8f	;\
	 lbu	t0, OFS(a0)	;\
	jr	ra		;\
	 SUBU	v0, t2, t3	;\
8:	beql	t2, t3, 8f	;\
	 lbu	t1, OFS(a1)	;\
	jr	ra		;\
	 SUBU	v0, t2, t3	;\
8:
#endif /* BRANCHLIKELY */

strcmp_byte:
#ifndef BRANCHLIKELY
1:	lbu	t0, 0(a0)
	lbu	t1, 0(a1)
	beq	t0, zero, 2f
    	 ADDIU	a0, 1
	beq	t0, t1, 1b
    	 ADDIU	a1, 1
2:	jr	ra
	 SUBU	v0, t0, t1
#else /* BRANCHLIKELY */
	lbu	t0, 0(a0)
	lbu	t1, 0(a1)

1:	STRCMP_T0T1(1)
	STRCMP_T2T3(2)
	STRCMP_T0T1(3)
	STRCMP_T2T3(4)
	STRCMP_T0T1(5)
	STRCMP_T2T3(6)
	STRCMP_T0T1(7)
	bnel	t2, zero, 2f
	 lbu	t0, 8(a0)
	jr	ra
	 SUBU	v0, t2, t3

2:	ADDIU	a0, 0x08
	ADDIU	a1, 0x08
	beql	t2, t3, 1b
	 lbu	t1, 0(a1)
	jr	ra
	 SUBU	v0, t2, t3
#endif /* BRANCHLIKELY */
END(strcmp)
