#******************************************************************************
#*
#* ====================================================
#* Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
#*
#* Developed at SunPro, a Sun Microsystems, Inc. business.
#* Permission to use, copy, modify, and distribute this
#* software is freely granted, provided that this notice
#* is preserved.
#* ====================================================
#*
#* Copyright (c) 2004 Freescale Semiconductor, Inc
#* All rights reserved.
#*
#* Redistribution and use in source and binary forms, with or without
#* modification, are permitted provided that the following conditions are met:
#*     * Redistributions of source code must retain the above copyright
#*       notice, this list of conditions and the following disclaimer.
#*     * Redistributions in binary form must reproduce the above copyright
#*       notice, this list of conditions and the following disclaimer in the
#*       documentation and/or other materials provided with the distribution.
#*     * Neither the name of Freescale Semiconductor nor the
#*       names of its contributors may be used to endorse or promote products
#*       derived from this software without specific prior written permission.
#*
#* THIS SOFTWARE IS PROVIDED BY Freescale Semiconductor ``AS IS'' AND ANY
#* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#* DISCLAIMED. IN NO EVENT SHALL Freescale Semiconductor BE LIABLE FOR ANY
#* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*
#*  Functions:    log10
#*
#*  Description:  implements floating point double precision
#*                software emulation for and log10() functions
#*                from MATH library (libmath)
#*
#*  Notes:        none
#*
#******************************************************************************

#include <powerpc/asm.h>


#define r0 0
#define r1 1
#define r2 2
#define r3 3
#define r4 4
#define r5 5
#define r6 6
#define r7 7
#define r8 8
#define r9 9
#define r10 10
#define r11 11
#define r12 12
#define r13 13
#define r14 14
#define r15 15
#define r16 16
#define r17 17
#define r18 18
#define r19 19
#define r20 20
#define r21 21
#define r22 22
#define r23 23
#define r24 24
#define r25 25
#define r26 26
#define r27 27
#define r28 28
#define r29 29
#define r30 30
#define r31 31

	.extern	__muldf3
	.extern	__divdf3
	.extern	__adddf3
	.extern	__subdf3
	.extern	__floatsidf

	.section	".text"

/*******************************************
*	fast implementation of log         *
*******************************************/
	.align  2

ENTRY(__ieee754_log10)
#ifdef _SOFT_DOUBLE
#define hx r3
#define lx r4

#define y 19
#define k 20
#define xhi 21
#define dhi 22
#define dlo 23
#define fhi 24
#define flo 25
#define shi 26
#define slo 27
#define whi 28
#define wlo 29
#define zhi 30
#define zlo 31

	lis	r5,	0x7ff0
	lis	r6,	0x0010
	clrlwi	r0,	hx,	1		# |hx|
	or.	r0,	r0,	lx		# if x = 0

	cmpwi	cr1,	hx,	0		# sign in cr1
	cmpw	cr5,	hx,	r5		# if x is Inf or NaN
	cmpw	cr6,	hx,	r6		# if x < 2**-1022

	beq-	cr0,	L(log_return_ninf)		# log(+-0) = -Inf
	blt-	cr1,	L(log_return_nan)		# log(-x) = NaN
	bgelr-	cr5				# log(+Inf/NaN) = +Inf/NaN

	stwu	r1,	-64(r1)
	mflr	r0
	stw	r0,	68(r1)
	stmw	r18,	8(r1)

	li	r0,	0			# k = 0
	bge+	cr6,	L(log10_argument_reduction)

	lis	r5,	0x4350			# 2**54
	li	r6,	0
	bl	__muldf3@plt			# x = x * 2**54
	li	r0,	-54			# k = -54

L(log10_argument_reduction):
	srawi	r5,	hx,	20		# k += (hx>>20) - 1023
	addi	r5,	r5,	-1023
	add	r10,	r0,	r5

	clrlwi	hx,	hx,	12		# hx &= 0x000fffff

	extrwi	r6,	r10,	1,0		# i = isnegative(k)

	li	r8,	0x3ff
	subf	r8,	r6,	r8
	slwi	r8,	r8,	20

	add	r7,	r6,	r10
	mr	y,	r7

	or	hx,	hx,	r8

	bl	log2@plt

	lis	r5,	0x3FD3
	ori	r5,	r5,	0x4413
	lis	r6,	0x509F
	ori	r6,	r6,	0x79FF
	bl	__muldf3@plt			# log(x)/log10
	mr	zhi,	r3
	mr	zlo,	r4

	mr	r3,	y
	bl	__floatsidf@plt			# d = (double) y
	mr	dhi,	r3
	mr	dlo,	r4

	lis	r5,	0x3d59
	ori	r5,	r5,	0xfef3
	lis	r6,	0x11f1
	ori	r6,	r6,	0x2b36
	bl	__muldf3@plt			# y*__LO(log10(2))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__adddf3@plt
	mr	zhi,	r3
	mr	zlo,	r4

	mr	r3,	dhi
	mr	r4,	dlo
	lis	r5,	0x3fd3
	ori	r5,	r5,	0x4413
	lis	r6,	0x509f
	ori	r6,	r6,	0x6000
	bl	__muldf3@plt			# y*__HI(log10(2))

	mr	r5,	zhi
	mr	r6,	zlo
	bl	__adddf3@plt

	b	L(log_exit)

L(log_return_ninf):
	lis	r3,	0xfff0
	li	r4,	0
	blr

L(log_return_nan):
	lis	r3,	0x7fff
	li	r4,	0
	blr

L(log_exit):
	lmw	r18,	8(r1)
	lwz	r0,	68(r1)
	mtlr	r0
	addi	r1,	r1,	+64
	blr
#else
#define hx r3
#define lx r4

#define x r4
					/* r5, r6 are reserved */
#define t r7
#define k r8
#define z r9
#define w r10
#define s r11
#define f r12

	lis	r5,	0x7ff0
	lis	r6,	0x0010
	clrlwi	r0,	hx,	1		# |hx|
	or.	r0,	r0,	lx		# if x = 0

	cmpwi	cr1,	hx,	0		# sign in cr1
	cmpw	cr5,	hx,	r5		# if x is Inf or NaN
	cmpw	cr6,	hx,	r6		# if x < 2**-1022

	beq-	cr0,	L(log_return_ninf)		# log(+-0) = -Inf
	blt-	cr1,	L(log_return_nan)		# log(-x) = NaN
	bgelr-	cr5				# log(+Inf/NaN) = +Inf/NaN

	li	k,	0			# k = 0
	bge+	cr6,	L(log10_argument_reduction)

	li	k,	-54			# k = -54

	cmpwi	cr0,	hx,	0
	bne+	cr0,	L(log10_denorm_small_shift)

	cntlzw	r5,	lx			# r5 = N = number of leading 0s
	cmpwi	cr5,	r5,	11
	blt+	cr5,	L(log10_denorm_middle_shift)

L(log10_denorm_big_shift):
	addi	r6,	r5,	-11
	slw	hx,	lx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	li	lx,	0
	addi	r5,	r5,	+21
	b	L(log10_denorm_calc_exp)

L(log10_denorm_middle_shift):
	li	r6,	11
	sub	r6,	r6,	r5		# r6 = 11 - N
	srw	hx,	lx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	addi	r5,	r5,	+21
	slw	lx,	lx,	r5
	b	L(log10_denorm_calc_exp)

L(log10_denorm_small_shift):
	cntlzw	r5,	hx			# r5 = N = number of leading 0s
	addi	r5,	r5,	-11		# discard zeroes in exp
	slw	hx,	hx,	r5
	li	r6,	32
	sub	r6,	r6,	r5		# r6 = 32 - N
	srw	r6,	lx,	r6
	or	hx,	hx,	r6
	clrlwi	hx,	hx,	12		# remove leading one
	slw	lx,	lx,	r5
L(log10_denorm_calc_exp):
	li	r6,	+55			# 54!!!
	sub	r6,	r6,	r5		# calculate exp
	slwi	r6,	r6,	20
	or	hx,	hx,	r6

L(log10_argument_reduction):
	srawi	r5,	hx,	20		# k += (hx>>20) - 1023
	addi	r5,	r5,	-1023
	add	k,	k,	r5

	clrlwi	hx,	hx,	12		# hx &= 0x000fffff

	extrwi	r6,	k,	1,0		# i = isnegative(k)

	li	r5,	0x3ff
	subf	r5,	r6,	r5
	slwi	r5,	r5,	20

	add	k,	k,	r6
	or	hx,	hx,	r5

	stwu	r1,	-16(r1)
	mflr	r0
	stw	r0,	20(r1)
	stw	k,	8(r1)

	bl	log@plt

	lwz	k,	8(r1)
	lwz	r0,	20(r1)
	mtlr	r0
	addi	r1,	r1,	+16

	evmergelo	x,	hx,lx		# merge x

	lis	r5,	0x3fdb
	ori	r5, r5,	0xcb7b
	lis	r6,	0x1526
	ori	r6, r6,	0xe50e
	evmergelo	t,	r5,r6		# t = 1/ln10
	efdmul	x,	x,	t		# log(x)/log10

	efdcfsi	k,	k			# (double)k

	lis	r5,	0x3d59
	ori	r5, r5,	0xfef3
	lis	r6,	0x11f1
	ori	r6, r6,	0x2b36
	evmergelo	t,	r5,r6		# t = LO(log10(2))
	efdmul	z,	k,	t
	efdadd	x,	x,	z

	lis	r5,	0x3fd3
	ori	r5, r5,	0x4413
	lis	r6,	0x509f
	ori	r6, r6,	0x6000
	evmergelo	t,	r5,r6		# t = HI(log10(2))
	efdmul	z,	k,	t
	efdadd	x,	x,	z
	evmergelohi	hx,	lx,	x	# split result
	blr					# and exit

L(log_return_ninf):
	lis	r3,	0xfff0
	li	r4,	0
	blr

L(log_return_nan):
	lis	r3,	0x7fff
	li	r4,	0
	blr
#endif

END(__ieee754_log10)
