#******************************************************************************
#*
#* Copyright (c) 2004 Freescale Semiconductor, Inc
#* All rights reserved.
#*
#* Redistribution and use in source and binary forms, with or without
#* modification, are permitted provided that the following conditions are met:
#*     * Redistributions of source code must retain the above copyright
#*       notice, this list of conditions and the following disclaimer.
#*     * Redistributions in binary form must reproduce the above copyright
#*       notice, this list of conditions and the following disclaimer in the
#*       documentation and/or other materials provided with the distribution.
#*     * Neither the name of Freescale Semiconductor nor the
#*       names of its contributors may be used to endorse or promote products
#*       derived from this software without specific prior written permission.
#*
#* THIS SOFTWARE IS PROVIDED BY Freescale Semiconductor ``AS IS'' AND ANY
#* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
#* DISCLAIMED. IN NO EVENT SHALL Freescale Semiconductor BE LIABLE FOR ANY
#* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
#* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
#* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
#* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#*
#*  Functions:    modf
#*
#*  Description:  implements MODF() function
#*                from MATH library (libmath)
#*
#*  Notes:        none
#*
#******************************************************************************

#include <powerpc/asm.h>


#define r0 0
#define r1 1
#define r2 2
#define r3 3
#define r4 4
#define r5 5
#define r6 6
#define r7 7
#define r8 8
#define r9 9
#define r10 10
#define r11 11
#define r12 12
#define r13 13
#define r14 14
#define r15 15
#define r16 16
#define r17 17
#define r18 18
#define r19 19
#define r20 20
#define r21 21
#define r22 22
#define r23 23
#define r24 24
#define r25 25
#define r26 26
#define r27 27
#define r28 28
#define r29 29
#define r30 30
#define r31 31

#define cr0_lt 0
#define cr0_gt 1
#define cr0_eq 2
#define cr0_so 3
#define cr1_lt 4
#define cr1_gt 5
#define cr1_eq 6
#define cr1_so 7
#define cr5_lt 20
#define cr5_gt 21
#define cr5_eq 22
#define cr5_so 23
#define cr6_lt 24
#define cr6_gt 25
#define cr6_eq 26
#define cr6_so 27
#define cr7_lt 28
#define cr7_gt 29
#define cr7_eq 30
#define cr7_so 31

        /*ARGUMENTS AND RESULT COMPONENTS */
#define a_hi r3
#define a_lo r4
                
#define res_hi a_hi
#define res_lo a_lo
                
#define exp_a r7
#define sign_a r8
                
#define frac_res_hi res_hi
#define frac_res_lo res_lo
#define exp_res exp_a
#define sign_res sign_a

#define int_addr r5
#define rsh r5
#define lsh r6

#define exp_shift 20
        
#define temp r0
#define temp1 r9
#define temp2 r10
#define temp3 r11
#define temp4 r12
                
        .section    ".text"

/****************************************
 *  fast implementation of MODF         * 
 ****************************************/
        .align  2
ENTRY(modf)
        rlwinm  exp_a, a_hi, (32-exp_shift), 21, 31
        rlwinm  sign_a, a_hi, 0, 0, 0
        cmpi    cr1, 0, exp_a, 2047             #special check for NAN/INF
        cmpi    cr6, 0, exp_a, (1023+52)        #covers both big numbers and NANs/INFs
        cmpi    cr7, 0, exp_a, (1023+0)
        cmpi    cr5, 0, exp_a, (1023+20)
        
        bge-    cr1, L(nan_inf_modf)
        bge-    cr6, L(huge_modf)
        blt-    cr7, L(tiny_modf)
        bgt-    cr5, L(shift_big_modf)
        beq-    cr5, L(shift_32_modf)
        /*blt-    cr5, shift_small_modf */

L(shift_small_modf): #a_lo is ZERO in int part 
        li      temp1, -1
        addi    r6, exp_a, -1023+12          
        mr      temp4, a_lo                     #form frac part (lo in temp4)
        srw     temp2, temp1, r6                #mask_hi=0x000f_ffff>>(exp-1023)=(-1)>>(exp-1023+12)
        li      res_lo, 0                       #form int part (lo)
        and.    temp3, a_hi, temp2              #form frac part (hi in temp3), check for ZERO
        andc    res_hi, a_hi, temp2             #form int part (hi)

        bne+    cr0, L(continue_small_modf)
        or.     temp, temp4, temp4
        b       L(continue_big_modf)

L(continue_small_modf):        
        stw     res_lo, 4(int_addr)             #store int part (lo)
        cntlzw  lsh, temp3                      
        stw     res_hi, 0(int_addr)             #store int part (hi)
        subfic  rsh, lsh, +32+11                #rsh=32-new_lsh = 32-old_lsh+11
        addi    lsh, lsh, -11                   #=cntlz-11
        srw     temp, temp4, rsh
        subf    exp_res, lsh, exp_res           #exp -= (cntlz-11)
        slw     res_hi, temp3, lsh
        rlwimi  sign_a, exp_res, 20, 1, 11
        or      res_hi, res_hi, temp
        slw     res_lo, temp4, lsh
        rlwimi  res_hi, sign_a, 0, 0, 11
        blr

L(shift_32_modf):  #a_hi is unchanged in int part (i.e. a_hi==res_hi)
        or.     temp4, res_lo, res_lo           #form frac part (hi=0 is not used, lo in temp4), check for ZERO
        li      res_lo, 0                       #form int part (lo)
        b       L(continue_big_modf)        

L(shift_big_modf): #a_hi is unchanged in int part (i.e. a_hi==res_hi)
        li      temp1, -1
        addi    r6, exp_a, -1023-20
        srw     temp2, temp1, r6                #mask_lo=(-1)>>(exp-1023-20)
        and.    temp4, a_lo, temp2              #form frac part (hi=0 is not used, lo in temp4), check for ZERO
        andc    res_lo, a_lo, temp2             #form int part (lo)
        /*b       continue_big_modf         */

L(continue_big_modf):        
        stw     res_hi, 0(int_addr)             #store int part (hi)
        addi    exp_res, exp_res, -21
        stw     res_lo, 4(int_addr)             #store int part (lo)
        cntlzw  lsh, temp4
        beq-    cr0, L(zero_frac_modf)
        cmpi    cr1, 0, lsh, +11
        subf    exp_res, lsh, exp_res
        subfic  rsh, lsh, +11
        addi    lsh, lsh, -11
        bge-    cr1, L(left_big_modf)
        /*beq-    cr1, right_big_modf */
        
L(right_big_modf):        
        subfic  lsh, rsh, +32                   # = 32-rsh
        rlwimi  sign_a, exp_res, 20, 1, 11
        srw     res_hi, temp4, rsh
        slw     res_lo, temp4, lsh
        rlwimi  res_hi, sign_a, 0, 0, 11
        blr

L(left_big_modf):
        rlwimi  sign_a, exp_res, 20, 1, 11
        slw     res_hi, temp4, lsh
        li      res_lo, 0
        rlwimi  res_hi, sign_a, 0, 0, 11
        blr

L(tiny_modf):
        /*return argument as fraction, +-ZERO as integer */
        li      temp, 0
        stw     sign_a, 0(int_addr)
        stw     temp, 4(int_addr)
        blr

L(huge_modf):
        /*return +-ZERO as fraction, argument as integer */
        stw     a_hi, 0(int_addr)        
        mr      res_hi, sign_a
        stw     a_lo, 4(int_addr)        
        li      res_lo, 0
        blr

L(nan_inf_modf):
        rlwinm  temp, a_hi, 0, 12, 31
        stw     a_hi, 0(int_addr)               #store A (NAN/INF) as int part       
        or.     temp, temp, a_lo
        stw     a_lo, 4(int_addr)               #store A (NAN/INF) as int part       
        isel    res_hi, sign_a, res_hi, cr0_eq  #return +-ZERO if A==INF, else return A (NAN)
        isel    res_lo, 0, res_lo, cr0_eq
        blr

L(zero_frac_modf):
        li      res_lo, 0
        mr      res_hi, sign_a
        blr

END(modf)

#ifdef NO_LONG_DOUBLE


#endif
        
        /*
        c=modf(a,*b)
        c - fractional part of a,
        *b - integer part of a,
        with:
        sign(a)=sign(*b)=sign(c)
        a = (*b) + c
        
        simple solution: *b = trunc(a), c = a-(*b) -> it needs stack
        comlex solution:
        case(exp_a)
        >=1023+52 -> c=+-ZERO(depends on sign(a)), *b=a 
        <1023+0 -> c=a, *b=+-ZERO(depends on sign(a))
        other (<=>1023+20) -> form fraction mask and separate int and frac parts
        */
         
