#ifndef fcntl_h

extern "C" {

#ifdef __fcntl_h_recursive
#include_next <fcntl.h>
#else
#define fcntl __hide_fcntl
#define open  __hide_open
#define creat __hide_creat

#define __fcntl_h_recursive
#include_next <fcntl.h>

#undef fcntl
#undef open
#undef creat

#define fcntl_h 1

int       fcntl(int, int, ...);
#if defined(DGUX)
int       creat(char*, unsigned long int);
#elif defined(convex)
int       creat(char*, unsigned short int);
#elif defined(hpux) || defined(USG)
int	      creat(const char*, unsigned short int);
#elif defined(___AIX__)
int       creat(char*, unsigned long);
#else
int       creat(const char*, unsigned long int);
#endif

#ifdef DGUX
int       open(char*, int, ...);
#else
int       open(const char*, int, ...);
#endif

#endif
}
#endif
