// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1989 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _signal_h

extern "C" {

#ifdef __signal_h_recursive
#include_next <signal.h>
#else

#define __signal_h_recursive

#define signal __hide_signal
#include_next <signal.h>
#undef signal

#define _signal_h 1

// The Interviews folks call this SignalHandler. Might as well conform.
// Beware: some systems think that SignalHandler returns int.
typedef void (*SignalHandler) (...);

extern SignalHandler signal(int sig, SignalHandler action);
extern SignalHandler sigset(int sig, SignalHandler action);
extern SignalHandler ssignal(int sig, SignalHandler action);
extern int           gsignal (int sig);
extern int           kill (int pid, int sig);
extern int           killpg(int, int);
extern int           siginterrupt(int, int);
extern void          psignal(unsigned, char*);

#ifndef hpux // Interviews folks claim that hpux doesn't like these
extern int           sigsetmask(int mask);
extern int           sigblock(int mask);
extern int           sigpause(int mask);
extern int           sigvec(int sig, struct sigvec* v, struct sigvec* prev);
#endif

// The Interviews version also has these ...

#define SignalBad ((SignalHandler)-1)
#define SignalDefault ((SignalHandler)0)
#define SignalIgnore ((SignalHandler)1)

#undef BADSIG
#undef SIG_DFL
#undef SIG_IGN
#define BAD_SIG SignalBad
#define SIG_DFL SignalDefault
#define SIG_IGN SignalIgnore

#endif
}

#endif

