/* Complex square root of long double value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"

/* Thanks to SGI we have to trick here.  At least Irix 6.2 provides hypotl,
   but it has a wrong prototype.  Grrr.  */
extern long double local_hypotl (long double, long double) asm ("hypotl");


__complex__ long double
csqrtl (__complex__ long double x)
{
  __complex__ long double res;

  if (!FINITEL_P (__real__ x) || !FINITEL_P (__imag__ x))
    {
      if (INFINITEL_P (__imag__ x))
	{
	  __real__ res = HUGE_VALL;
	  __imag__ res = __imag__ x;
	}
      else if (INFINITEL_P (__real__ x))
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = __imag__ x != __imag__ x ? NAN : 0;
	      __imag__ res = __copysignl (HUGE_VALL, __imag__ x);
	    }
	  else
	    {
	      __real__ res = __real__ x;
	      __imag__ res = (__imag__ x != __imag__ x
			      ? NAN : __copysignl (0.0, __imag__ x));
	    }
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      if (__imag__ x == 0.0)
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = 0.0;
	      __imag__ res = __copysignl (sqrtl (-__real__ x), __imag__ x);
	    }
	  else
	    {
	      __real__ res = fabsl (sqrtl (__real__ x));
	      __imag__ res = __copysignl (0.0, __imag__ x);
	    }
	}
      else if (__real__ x == 0.0)
	{
	  long double r = sqrtl (0.5 * fabsl (__imag__ x));

	  __real__ res = __copysignl (r, __imag__ x);
	  __imag__ res = r;
	}
      else
	{
	  __complex__ long double q;
	  long double t, r;

	  if (fabsl (__imag__ x) < 2.0e-4 * fabsl (__real__ x))
	    t = 0.25 * __imag__ x * (__imag__ x / __real__ x);
	  else
	    t = 0.5 * (local_hypotl (__real__ x, __imag__ x) - __real__ x);

	  r = sqrtl (t);

	  __real__ q = __imag__ x / (2.0 * r);
	  __imag__ q = r;

	  /* Heron iteration in complex arithmetic.  */
	  res = 0.5 * (q + q / x);
	}
    }

  return res;
}
