// Iostreams base classes -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#ifndef _CPP_BITS_BASICIOS_H
#define _CPP_BITS_BASICIOS_H 1

namespace std {

  // 27.4.5  Template class basic_ios
  template <class _CharT, class _Traits>
  class basic_ios : public ios_base
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits traits_type;

  private:
    char_type _M_fill;
    basic_ostream<_CharT,_Traits>* _M_tie;

  protected:
    basic_streambuf<_CharT,_Traits>* _M_strbuf;

  public:
    operator void* () const 
      { return fail() ? 0 : const_cast<basic_ios*>(this); }
    bool operator! () const { return fail (); }
    iostate rdstate () const { return ios_base::rdstate (); }
    void clear (iostate __state = goodbit);
    void setstate (iostate __state);
    bool good () const { return rdstate () == 0; }
    bool eof () const { return (rdstate () & eofbit) != 0; }
    bool fail () const { return (rdstate () & (eofbit | failbit)) != 0; }
    bool bad () const { return (rdstate () & badbit) != 0; }

    iostate exceptions () const { return ios_base::exceptions (); }
    void exceptions (iostate __except) { ios_base::exceptions (); }

    // Constructor/destructor:
    explicit basic_ios (basic_streambuf<_CharT,_Traits>* __sb);
    virtual ~basic_ios ();

    // Members:
    basic_ostream<_CharT,_Traits>*
      tie () const      { return _M_tie; }
    basic_ostream<_CharT,_Traits>*
      tie (basic_ostream<_CharT,_Traits>* __tiestr);
    basic_streambuf<_CharT,_Traits>*
      rdbuf () const    { return _M_strbuf; }
    basic_streambuf<_CharT,_Traits>* 
      rdbuf(basic_streambuf<_CharT,_Traits>* __sb);
    basic_ios&
      copyfmt (const basic_ios& __rhs);

    char_type fill() const { return _M_fill; }
    char_type fill (char_type __ch);

    // Locales:
    locale imbue (const locale& __loc);
    char narrow (char_type __c, char __dfault) const;
    char_type widen (char __c) const;

  protected:
    // 27.4.5.1  basic_ios constructors
    basic_ios ();
    void init (basic_streambuf<_CharT,_Traits>* __sb);
  };

  template <class _CharT, class _Traits>
    basic_ios<_CharT,_Traits>::basic_ios () 
      : ios_base () { /* Do nothing, leave the object undefined.  */ }

  template <class _CharT, class _Traits>
    basic_ios<_CharT,_Traits>::
      basic_ios (basic_streambuf<_CharT,_Traits>* __sb) 
       : ios_base () 
       { this->init (__sb); }

  template <class _CharT, class _Traits>
    basic_ios<_CharT,_Traits>::~basic_ios() {}

  template <class _CharT, class _Traits>
    void 
    basic_ios<_CharT,_Traits>::clear (iostate __state)
      { ios_base::clear ((rdbuf () == 0 ? __state|badbit : __state)); }

  template <class _CharT, class _Traits>
    void 
    basic_ios<_CharT,_Traits>::setstate (iostate __state) 
      { this->clear (rdstate () | __state); }

  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>*
    basic_ios<_CharT,_Traits>::tie (
        basic_ostream<_CharT,_Traits>* __tiestr)
  {
    basic_ostream<_CharT,_Traits>* __old = _M_tie;
    _M_tie = __tiestr;
    return __old;
  }

  template <class _CharT, class _Traits>
    basic_streambuf<_CharT,_Traits>* 
    basic_ios<_CharT,_Traits>::rdbuf(basic_streambuf<_CharT,_Traits>* __sb)
  {
    basic_streambuf<_CharT,_Traits>* __old = _M_strbuf;
    _M_strbuf = __sb;
    return __old;
  }

  // XXX this should be "export", and moved to bits/basic_ios.tcc.
  template <class _CharT, class _Traits>
    basic_ios<_CharT,_Traits>&
    basic_ios<_CharT,_Traits>::copyfmt (const basic_ios& __rhs)
  {
    // Per 27.1.1.1, do not call imbue();  must not imbue on the sbuf.
    // XXX but must trash all caches associated with imbue()
    
    // XXX shouldn't _M_copy_base take a const argument?
    _M_copy_base(const_cast<basic_ios&> (__rhs));  

    tie (__rhs.tie ());
    fill (__rhs.fill ());

    // The next is required to be the last assignment.
    exceptions (__rhs.exceptions ());
    
    _M_call_callbacks (copyfmt_event);
    return *this;
  }

  template <class _CharT, class _Traits>
  _CharT basic_ios<_CharT,_Traits>::fill (char_type __ch)
  {
    char_type __old = _M_fill;
    _M_fill = __ch;
    return __old;
  }

    // Locales:
  template <class _CharT, class _Traits>
    locale
    basic_ios<_CharT,_Traits>::imbue (const locale& __loc)
  {
    locale __old (getloc ());
    ios_base::imbue (__loc);
    if (rdbuf () != 0)
      rdbuf ()->pubimbue (__loc);
    _M_call_callbacks (imbue_event);
    return __old;
  }

  template <class _CharT, class _Traits>
    char
    basic_ios<_CharT,_Traits>::narrow (char_type __c, char __dfault) const
  {
    // XXX imbue should cache this facet.
    return use_facet<ctype<char_type> > (getloc ()).narrow (__c, __dfault);
  }

  template <class _CharT, class _Traits>
    _CharT
    basic_ios<_CharT,_Traits>::widen (char __c) const
  {
    // XXX imbue should cache this facet.
    return use_facet<ctype<char_type> > (_M_getloc ()).widen (__c);
  }

  template <class _CharT, class _Traits>
    void
    basic_ios<_CharT,_Traits>::init (basic_streambuf<_CharT,_Traits>* __sb)
  {
    // note: this may be called more than once on the same object.
    _M_strbuf = __sb;
    _M_tie = 0;
    ios_base::_M_init();
    _M_fill = widen (' ');
  }
  
} // namespace std

#endif /* _CPP_BITS_BASICIOS_H */
