// String based streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.7  String-based streams
//

#ifndef _CPP_SSTREAM
#define _CPP_SSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_streambuf.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>

namespace std {

  template <class _CharT, class _Traits, class _Alloc>
  class basic_stringbuf : public basic_streambuf<_CharT, _Traits>
  {
    // Types:
    typedef _CharT 					char_type;
    typedef typename _Traits::int_type 			int_type;
    typedef typename _Traits::pos_type 			pos_type;
    typedef typename _Traits::off_type 			off_type;
    typedef _Traits                    			traits_type;
    typedef basic_streambuf<_CharT, _Traits> 		streambuf_type;
    typedef basic_string<_CharT, _Traits, _Alloc> 	string_type;

    // Data Members:
    ios_base::openmode 	_M_mode;
    string_type 	_M_str;

  public:
    // Constructors:
    explicit basic_stringbuf(ios_base::openmode __which = (ios_base::in
							  | ios_base::out))
      : streambuf_type(), _M_mode (__which), _M_str(string_type())
      { sync(); }

    explicit basic_stringbuf(const string_type& __str,
        ios_base::openmode __which = (ios_base::in | ios_base::out));

    // Get and set:
    string_type str() const
      {  return _M_str; }

    void str(const string_type& __s)
      {
	_M_str = __s;
	sync();
      }

  protected:

    // Overridden virtual functions:
    virtual int_type underflow()
      {
	if (_M_in_cur != _M_in_end)
	  return traits_type::to_int_type(*gptr());
	else
	  return traits_type::eof();
      }

    virtual int_type pbackfail(int_type __c = traits_type::eof())
      {
	int_type __retval = traits_type::eof();
	char_type* __pcur = gptr();
	bool __testeq = traits_type::eq_int_type(__c, traits_type::eof());
	bool __testpos = __pcur != _M_in_beg && __pcur <= _M_in_end; 

	// Try to put back __c into input sequence in one of three ways.
	// Order these tests done in is unspecified by the standard.
	if (!__testeq && __testpos 
	    && traits_type::eq(traits_type::to_char_type(__c), gptr()[-1]))
	  {
	    char_type __asgn = __pcur[-1];
	    *__pcur = __asgn;
	    __retval = __c;
	  }
	else if (!__testeq && __testpos && _M_mode & ios_base::out)
	  {
	    __pcur[-1] = __c;
	    __retval = __c;
	  }
	else if (__testeq && __testpos)
	  {
	    char_type __asgn = __pcur[-1];
	    *__pcur = __asgn;
	    __retval = traits_type::not_eof(__c);
	  }

	return __retval;
      }

    virtual int_type overflow(int_type __c = traits_type::eof())
      {
	bool __testi = traits_type::eq_int_type(__c, traits_type::eof());
	int_type __retval = traits_type::eof();
	string_type::size_type __size;

	// Try to append __c into output sequence in one of two ways.
	// Order these tests done in is unspecified by the standard.
	if (!__testi)
	  {
	    if (_M_mode & ios_base::out
		&& _M_str.size() < _M_str.max_size())
	      {
		// Need explicit cast here or else string::append template
		// will be instantiated and int_type (char or wchar_t)
		// will be promoted to int.
		_M_str.append(string_type::size_type(1), __c);
		sync();
		// This shouldn't be necessary, but standard calls for it
		//sputc(__c);
 		__retval = __c;
	      }
	    // Undefined in the standard
	    else
	      return traits_type::eof();
	  }
	else
	  __retval = traits_type::not_eof(__c);
	return __retval;
      }

    virtual streambuf_type* setbuf(char_type* __s, streamsize __n)
    { 
      string_type __str(__s, __n);
      if (__str.size())
	this->str(__str);
      return dynamic_cast<streambuf_type*> (this); 
    } 

    virtual pos_type 
    seekoff(off_type __off, ios_base::seekdir __way,
	    ios_base::openmode __which = (ios_base::in | ios_base::out))
      {
	pos_type __retval =  pos_type(off_type(-1)); 
	off_type __newoff = 0;
	streambuf_type::char_type* __beg;
	streambuf_type::char_type* __cur;
	streambuf_type::char_type* __end;

	if (__which & ios_base::in)
	  {
	    __beg = eback();
	    __cur = gptr();
	    __end = egptr();
	  }
	if (__which & ios_base::out)
	  {
	    __beg = pbase();
	    __cur = pptr();
	    __end = epptr();
	  }

	if (__cur)
	  {
	    if (__way == ios_base::cur 
		&& !(__which & ios_base::in & ios_base::out))
	      __newoff = __cur - __beg;
	    if (__way == ios_base::end)
	      __newoff = __end - __beg;

	    if (__newoff + __off >= 0 && __end - __beg >= __newoff + __off )
	     {
	       // Need to set both of these if applicable
	       if (__which & ios_base::in)
		 _M_in_cur = _M_in_beg + __newoff + __off;
	       if (__which & ios_base::out)
		 _M_out_cur = _M_out_beg + __newoff + __off;
	       __retval = pos_type(off_type(__beg + __newoff + __off));
	     }
	  }
	
	return __retval;
      }

    virtual pos_type 
    seekpos(pos_type __sp, 
	    ios_base::openmode __which = (ios_base::in | ios_base::out))
      {
	pos_type __retval =  pos_type(off_type(-1)); 
	char_type* __pos = reinterpret_cast<char_type*> (__sp._M_position());
	char_type* __beg = NULL;
	char_type* __end = NULL;
	bool __testvalid = false;

	if (__which & ios_base::in)
	  {
	    __beg = eback();
	    __end = egptr();
	  }

	if (__which & ios_base::out)
	  {
	    __beg = pbase();
	    __end = epptr();
	  }

	__testvalid = __beg <= __pos && __pos <= __end;

	if (__testvalid)
	  {
	    // Need to set both of these if applicable
	    if (__which & ios_base::in)
	      _M_in_cur = __pos;
	    if (__which & ios_base::out)
	      _M_out_cur = __pos;
	    __retval = pos_type(off_type(__pos));
	  }

	return __retval;
      }

    virtual int sync()
      {
	// Will eventually need to cast these to _Alloc::pointer or
	// string_type::iterator types.
	if (_M_mode & ios_base::in)
	  setg(_M_str.begin(), _M_str.begin(), _M_str.end());
	if (_M_mode & ios_base::out)
	    setp(_M_str.begin(), _M_str.end());
	return 0;
      }

  };

  typedef basic_stringbuf<char> stringbuf;
  typedef basic_stringbuf<wchar_t> wstringbuf;


  // 27.7.2  Template class basic_istringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_istringstream : public basic_istream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors:
    explicit basic_istringstream (ios_base::openmode __which = ios_base::in)
      : basic_istream<_CharT, _Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__which | ios_base::in))
       { }

    explicit basic_istringstream (
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = ios_base::in)
      : basic_istream<_CharT, _Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which | ios_base::in))
      { }

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
      { return const_cast<basic_stringbuf<_CharT,_Traits,_Alloc>*> (&_M_sb); }
    basic_string<_CharT,_Traits,_Alloc> str () const
      { return rdbuf() -> str(); }
  
    void str (const basic_string<_CharT,_Traits,_Alloc>& __s)
      { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits,_Alloc> _M_sb;
  };

  typedef basic_istringstream<char> istringstream;
  typedef basic_istringstream<wchar_t> wistringstream;

  // 27.7.3  Template class basic_ostringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_ostringstream : public basic_ostream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors/destructor:
    explicit basic_ostringstream (ios_base::openmode __which = ios_base::out)
      : basic_ostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc>(__which | ios_base::out))
      { }

    explicit basic_ostringstream(
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = ios_base::out)
      : basic_ostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which | ios_base::out))
      { }

    virtual ~basic_ostringstream () {}

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
      { return const_cast<basic_stringbuf<_CharT,_Traits,_Alloc>*> (&_M_sb); }

    basic_string<_CharT,_Traits,_Alloc> str () const
     { return rdbuf() -> str(); }
 
    void str (const basic_string<_CharT,_Traits,_Alloc>& __s)
      { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits,_Alloc> _M_sb;
  };

  typedef basic_ostringstream<char> ostringstream;
  typedef basic_ostringstream<wchar_t> wostringstream;

  // 27.7.4  Template class basic_stringstream
  template <class _CharT, class _Traits, class _Alloc>
  class basic_stringstream : public basic_iostream<_CharT,_Traits>
  {
  public:
    // Types
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    typedef _Traits                    traits_type;

    // Constructors/destructors
    explicit basic_stringstream(
      ios_base::openmode __which = (ios_base::out | ios_base::in))
      : basic_iostream<_CharT,_Traits> (&_M_sb),
        _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__which))
      { }

    explicit basic_stringstream(
      const basic_string<_CharT,_Traits,_Alloc>& __str,
      ios_base::openmode __which = (ios_base::out | ios_base::in))
      : basic_iostream<_CharT,_Traits> (&_M_sb),
       _M_sb (basic_stringbuf<_CharT,_Traits,_Alloc> (__str, __which))
      { }

    // Members:
    basic_stringbuf<_CharT,_Traits,_Alloc>* rdbuf () const
      { return const_cast<basic_stringbuf<_CharT,_Traits,_Alloc>*> (&_M_sb); }

    basic_string<_CharT,_Traits,_Alloc> str () const
      { return rdbuf() -> str(); }

    void str (const basic_string<_CharT,_Traits,_Alloc>& __str)
     { return rdbuf() -> str(__s); }

  private:
    basic_stringbuf<_CharT,_Traits> _M_sb;
  };

  typedef basic_stringstream<char> stringstream;
  typedef basic_stringstream<wchar_t> wstringstream;

} // namespace std



#ifdef _G_NO_TEMPLATE_EXPORT
# define export
# include <bits/os_raw.h>
# include <bits/sstream.tcc>
# include <bits/std_cstring.h>  // memmove
#endif


#endif	/* _CPP_SSTREAM */









