// Explicit instantiation file.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882:
//

#include <bits/std_string.h>
#include <bits/std_algorithm.h>
#include <bits/std_locale.h>
#include <bits/std_vector.h>
#include <bits/std_iterator.h>
#include <bits/std_streambuf.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>
#include <bits/std_sstream.h>
#include <bits/std_fstream.h>

//
// string
//
template string::basic_string(char*, char*, allocator<char> const&);

template wstring::basic_string(wchar_t*, wchar_t*, allocator<wchar_t> const&);

template char* string::_S_construct<char *>(char *, char *, allocator<char> const &, forward_iterator_tag);

template char* string::_S_construct<const char *>(const char *, const char *, allocator<char> const &, forward_iterator_tag);

template wchar_t* wstring::_S_construct<wchar_t *>(wchar_t *, wchar_t *, allocator<wchar_t> const &, forward_iterator_tag);

template wchar_t* wstring::_S_construct<const wchar_t *>(const wchar_t *, const wchar_t *, allocator<wchar_t> const &, forward_iterator_tag);

template string& string::_M_replace<char *>(char *, char *, char *, char *, forward_iterator_tag);

template string& string::_M_replace<const char *>(char *, char *, const char *, const char *, forward_iterator_tag);

template wstring& wstring::_M_replace<wchar_t *>(wchar_t *, wchar_t *, wchar_t *, wchar_t *, forward_iterator_tag);

template wstring& wstring::_M_replace<const wchar_t *>(wchar_t *, wchar_t *, const wchar_t *, const wchar_t *, forward_iterator_tag);


//
// iterator/locale
//
typedef istreambuf_iterator<char,char_traits<char> > istreambuf_iter;
typedef istreambuf_iterator<wchar_t,char_traits<wchar_t> > wistreambuf_iter;
typedef ostreambuf_iterator<char,char_traits<char> > ostreambuf_iter;
typedef ostreambuf_iterator<wchar_t,char_traits<wchar_t> > wostreambuf_iter;

template istreambuf_iter __match_parallel<istreambuf_iter, char>(
  istreambuf_iter, istreambuf_iter, int, const string *, int *, int &, bool &);

template wistreambuf_iter __match_parallel<wistreambuf_iter, wchar_t>(
 wistreambuf_iter, wistreambuf_iter, int, const string *, int *, int &, bool &);

template void vector<locale::facet *, allocator<locale::facet *> >::insert(
  locale::facet **, unsigned int, locale::facet *const &);

template bool istreambuf_iter::_M_equal_helper(const istreambuf_iter &) const;

template bool wistreambuf_iter::_M_equal_helper(const wistreambuf_iter &) const;

//
// locale
//
template class _Format_cache<char>;
template class _Format_cache<wchar_t>;

template
  ostreambuf_iterator<char>
  _S_fill<char,ostreambuf_iterator<char>,output_iterator_tag>(
     ostreambuf_iterator<char> __s, char __fill, int __padding, 
     output_iterator_tag);

template
  ostreambuf_iterator<wchar_t>
  _S_fill<wchar_t,ostreambuf_iterator<wchar_t>,output_iterator_tag>(
     ostreambuf_iterator<wchar_t> __s, wchar_t __fill, int __padding, 
     output_iterator_tag);

template 
  ostreambuf_iterator<char>
  _S_pad_numeric<char,ostreambuf_iterator<char> >(
    ostreambuf_iterator<char> __s, ios_base::fmtflags __flags,
    char __fill, int __width, char const* __first,
    char const* __middle, char const* __last);

template 
  ostreambuf_iterator<wchar_t>
  _S_pad_numeric<wchar_t,ostreambuf_iterator<wchar_t> >(
    ostreambuf_iterator<wchar_t> __s, ios_base::fmtflags __flags,
    wchar_t __fill, int __width, wchar_t const* __first,
    wchar_t const* __middle, wchar_t const* __last);

template
  char*
  _S_group_digits<char>(
    char* __s, char __grsep, char const* __grouping,
    char const* __grend, char const* __first, char const* __last);

template
  wchar_t*
  _S_group_digits<wchar_t>(
    wchar_t* __s, wchar_t __grsep, char const* __grouping,
    char const* __grend, wchar_t const* __first, wchar_t const* __last);

template ostreambuf_iterator<char> 
  _S_format_long<char, ostreambuf_iterator<char> >(
    ostreambuf_iterator<char>, ios_base &, char, bool, unsigned long);

template ostreambuf_iterator<wchar_t> 
  _S_format_long<wchar_t, ostreambuf_iterator<wchar_t> >(
    ostreambuf_iterator<wchar_t>, ios_base &, wchar_t, bool, unsigned long);

//
// streambuf
// 
template class streambuf;

template class wstreambuf;

#if 0
template streambuf::basic_streambuf();

template wint_t wstreambuf::_M_snextc_helper(void);

template wint_t wstreambuf::sungetc(void);

template wint_t wstreambuf::sputbackc(wchar_t);

template wstreambuf::~basic_streambuf();

template wstreambuf::basic_streambuf();
#endif

//
// istream
//
template istream::~basic_istream();

template wistream::~basic_istream();

template istream::basic_istream(streambuf *);

template wistream::basic_istream(wstreambuf *);

template wistream& wistream::get(wchar_t *, unsigned int, wchar_t);

template wistream& wistream::get(wstreambuf &, wchar_t);

template wistream& wistream::getline(wchar_t *, unsigned int, wchar_t);


//
// ostream
//
template ostream::~basic_ostream();

template wostream::~basic_ostream();


//
// stringstream
//
template class stringbuf;

//template class wstringbuf;


//
// fstream
//
template class filebuf;

//template filebuf::basic_filebuf(int, ios_base::_Fd_selector);

//template wfilebuf::basic_filebuf(int, ios_base::_Fd_selector);


//
// algorithm
//
template const wchar_t*  find_if<const wchar_t *, _Char_traits_match<wchar_t, char_traits<wchar_t> > >(const wchar_t *, const wchar_t *, _Char_traits_match<wchar_t, char_traits<wchar_t> >, random_access_iterator_tag);

template const char*  find_if<const char *, _Char_traits_match<char, char_traits<char> > >(const char *, const char *, _Char_traits_match<char, char_traits<char> >, random_access_iterator_tag);

template string* __uninitialized_fill_n_aux<string*, unsigned int, string>
(string*, unsigned int, string const &, _Bool<false>);

template string* __uninitialized_copy_aux<string const *, string *>
(string const *, string const *, string*, _Bool<false>);

template locale::facet ** fill_n<locale::facet **, unsigned int, locale::facet *>(locale::facet **, unsigned int, locale::facet * const &);

template void fill<locale::facet **, locale::facet *>(locale::facet **, locale::facet *, locale::facet * const &);


