
// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#ifndef _CPP_BIN_CPPCONFIG
#define _CPP_BIN_CPPCONFIG 1

// The current version of the C++ library in compressed ISO date format.
#define __GLIBCPP__ 19990518

// This flag controls the error handling in string, and perhaps other
// bits as time goes on: check out bits/utility.h for more info.
# define _G_USE_EXCEPTIONS 1 

// This is necessary until Egcs supports separate template compilation.
#define _G_NO_TEMPLATE_EXPORT 1

// Implies the use of the GNU libio library, and the inclusion of libio.h
#define _G_USE_LIBIO 1

// To enable older, ARM-style iostreams and other anachronisms use this.
//#define _G_DEPRICATED 1

// Implies that wchar_t should be used.
#define _G_USE_WCHAR_T 1

// Implies that long long should be used.
//#define _G_USE_LONG_LONG 1

// CYGNUS LOCAL 9/3/1998
// This is required for limits.h to define LONG_LONG_MIN and LONG_LONG_MAX,
// which are used in std_limits.h if __STL_LONG_LONG is defined.
#if defined __linux__
// We assume glibc here.
#  ifndef __USE_GNU
#    define __USE_GNU 1
#  endif
#endif

// Use a faster strtof instead of strtod. Valid only if the target has
// strtof as part of the "C" library. For linux, activate. For
// solaris, deactivate. See the relevant parts of num_get::do_get.
#ifdef __linux__
#  define _G_USE_STRTOF 1
#endif

// Use a faster strtold instead of sscanf. Valid only if the target has
// strtold as part of the "C" library. For linux, activate. For
// solaris, deactivate.
#ifdef __linux__
#  define _G_USE_STRTOLD 1
#endif

// Use corrected code from the committee library group's issues list.
#define _G_RESOLVE_LIB_DEFECTS 1

#ifdef __sun__
/* When we auto-generate this file this definition will done automatically
   as well.  */
typedef struct {
  int __fill[6];
} mbstate_t;

#endif

#endif /* _CPP_BIN_CPPCONFIG_ */

// Local Variables:
// mode:c++
// End:




