
// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

#ifndef _CPP_BITS_UTILITY_H
#define _CPP_BITS_UTILITY_H 1

// #include <bits/std_climits.h>
// #include <bits/std_cstddef.h>

namespace std {
  // _Count_ones: compile-time computation of number of 1-bits in a value N
  //   This takes only 5 (or 6) instantiations, doing recursive descent
  //     in parallel -- ncm

  template<unsigned _Num, int _Shift = (sizeof(unsigned)*CHAR_BIT)/2,
           unsigned _Mask = (~0u>>_Shift)>
    struct _Count_ones;
  template<unsigned _Num, unsigned _Mask>
    struct _Count_ones<_Num,0,_Mask> { static const unsigned _S_count = _Num; };
  template<unsigned _Num, int _Shift, unsigned _Mask>
    struct _Count_ones {
      static const unsigned _S_halfcount =
        _Count_ones<_Num, _Shift/2, (_Mask^((~_Mask)>>(_Shift/2))) >::_S_count;
      static const unsigned _S_count
        = (_S_halfcount&_Mask) + ((_S_halfcount>>_Shift)&_Mask);
  };

#if _G_USE_EXCEPTIONS
// Internal functions for string implementation.
  extern void __out_of_range (const char *__str);
  extern void __length_error (const char *__str);

# define __OUTOFRANGE(__cond) \
  do { if (__cond) __out_of_range (#__cond); } while (0)
# define __LENGTHERROR(__cond) \
  do { if (__cond) __length_error (#__cond); } while (0)
#else
# include <bits/std_cassert.h>
# define __OUTOFRANGE(__cond) assert (!(__cond))
# define __LENGTHERROR(__cond) assert (!(__cond))
#endif

#ifdef _G_NO_MBSTATE_T
typedef long mbstate_t;
#endif

} // namespace std

#endif /* _CPP_BITS_UTILITY_ */
