/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

#include <builtin.h>
#include <math.h>
#include <stdio.h>
#include <stdarg.h>
#include "libconfig.h"


/*
 common functions on built-in types
*/

long gcd(long x, long y)        // euclid's algorithm
{
  long a = abs(x);
  long b = abs(y);

  long tmp;
  
  if (b > a)
  {
    tmp = a; a = b; b = a;
  }
  for(;;)
  {
    if (b == 0)
      return a;
    else if (b == 1)
      return b;
    else
    {
      tmp = b;
      b = a % b;
      a = tmp;
    }
  }
}

double pow(double x, long p)
{
  double r;
  if (x == 0.0)
    r = 0.0;
  else if (p == 0)
  {
    if (x < 0 && (p & 1))
      r = -1.0;
    else
      r = 1.0;
  }
  else
  {
    double b = x;
    if (p < 0)
    {
      p = -p;
      b = 1.0 / b;
    }
    r = 1.0;
    for(;;)
    {
      if (p & 1)
        r *= b;
      if ((p >>= 1) == 0)
        break;
      else
        b *= b;
    }
  }
  return r;
}

long lg(long x)
{
  long l = 0;
  unsigned long a = abs(x);

  while (a > 1)
  {
    a = a >> 1;
    ++l;
  }
  return l;
}

long  pow(long  x, long y)
{
  if (x == 0 || y < 0)
    return  0;
  else if (y == 0 || x == 1)
    return  1;
  else if (x == -1)
    return (y & 1)? -1 : 1;
  else
  {
    long r = 1;
    for(;;)
    {
      if (y & 1)
        r *= x;
      if ((y >>= 1) == 0)
        return r;
      else
        x *= x;
    }
  }
}

long sqrt(long x)
{
  if (x <= 0)
    return 0;                   // no int error handler, so ...
  else if (x == 1)
    return 1;
  else
  {
    long r = x >> 1;
    long q;
    for(;;)
    {
      q = x / r;
      if (q >= r)
        return r;
      else
        r = (r + q) >> 1;
    }
  }
}


