// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


#ifndef _std_h
#define _std_h 1


#ifndef DECLARE_C_EXTERN
#define DECLARE_C_EXTERN(RETVAL, FNAME, ARGTYPES)  \
  extern RETVAL FNAME ARGTYPES asm ("_" #FNAME)
#endif

DECLARE_C_EXTERN(void,     _exit, (int));
DECLARE_C_EXTERN(void,     abort, ());
DECLARE_C_EXTERN(int,      abs, (int));
DECLARE_C_EXTERN(int,      access, (const char*, int));
DECLARE_C_EXTERN(int,      acct, (const char*));
DECLARE_C_EXTERN(unsigned, alarm, (unsigned));
DECLARE_C_EXTERN(void*,    alloca, (int));
DECLARE_C_EXTERN(double,   atof, (const char*));
DECLARE_C_EXTERN(int,      atoi, (const char*));
DECLARE_C_EXTERN(long,     atol, (const char*));
DECLARE_C_EXTERN(int,      bcmp, (const void*, const void*, int));
DECLARE_C_EXTERN(int,      bcopy, (const void*, void*, int));
DECLARE_C_EXTERN(void*,    brk, (void*));
DECLARE_C_EXTERN(int,      bzero, (void*, int));
DECLARE_C_EXTERN(void*,    calloc, (unsigned, unsigned));
DECLARE_C_EXTERN(void,     cfree, (void*));
DECLARE_C_EXTERN(int,      chdir, (const char*));
DECLARE_C_EXTERN(int,      chmod, (const char*, int));
DECLARE_C_EXTERN(int,      chown, (const char*, int, int));
DECLARE_C_EXTERN(long,     clock, ());
DECLARE_C_EXTERN(int,      close, (int));
DECLARE_C_EXTERN(int,      creat, (const char*, int));
DECLARE_C_EXTERN(char*,    crypt, (const char*, const char*));
DECLARE_C_EXTERN(char*,    ctermid, (char*));
DECLARE_C_EXTERN(char*,    cuserid, (char*));
DECLARE_C_EXTERN(double,   drand48, ());
DECLARE_C_EXTERN(int,      dup, (int));
DECLARE_C_EXTERN(int,      dup2, (int, int));
DECLARE_C_EXTERN(int,      dysize, (int));
DECLARE_C_EXTERN(char*,    ecvt, (double, int, int*, int*));
DECLARE_C_EXTERN(char*,    encrypt, (char*, int));
DECLARE_C_EXTERN(double,   erand, (short*));
DECLARE_C_EXTERN(int,      execl, (const char*, const char *, ...));
DECLARE_C_EXTERN(int,      execle, (const char*, const char *, ...));
DECLARE_C_EXTERN(int,      execlp, (const char*, const char*, ...));
DECLARE_C_EXTERN(int,      exect, (const char*,  const char**,  char**));
DECLARE_C_EXTERN(int,      execv, (const char*,  const char**));
DECLARE_C_EXTERN(int,      execve, (const char*, const char**, char**));
DECLARE_C_EXTERN(int,      execvp, (const char*,  const char**));
DECLARE_C_EXTERN(void,     exit, (int));
DECLARE_C_EXTERN(int,      fchmod, (int, int));
DECLARE_C_EXTERN(int,      fchown, (int, int, int));
DECLARE_C_EXTERN(int,      fcntl, (int, int, int));
DECLARE_C_EXTERN(char*,    fcvt, (double, int, int*, int*));
DECLARE_C_EXTERN(int,      ffs, (int));
DECLARE_C_EXTERN(int,      flock, (int, int));
DECLARE_C_EXTERN(int,      fork, ());
DECLARE_C_EXTERN(void,     free, (void*));
DECLARE_C_EXTERN(int,      fsync, (int));
DECLARE_C_EXTERN(long,     ftok, (const char*, int));
DECLARE_C_EXTERN(int,      ftruncate, (int, unsigned long));
DECLARE_C_EXTERN(char*,    gcvt, (double, int, char*));
DECLARE_C_EXTERN(char*,    getcwd, (char*, int));
DECLARE_C_EXTERN(int,      getdomainname, (char*, int));
DECLARE_C_EXTERN(int,      getdtablesize, ());
DECLARE_C_EXTERN(int,      getegid, ());
DECLARE_C_EXTERN(char*,    getenv, (const char*));
DECLARE_C_EXTERN(int,      geteuid, ());
DECLARE_C_EXTERN(int,      getgid, ());
DECLARE_C_EXTERN(int,      getgroups, (int, int*));
DECLARE_C_EXTERN(long,     gethostid, ());
DECLARE_C_EXTERN(int,      gethostname, (char*, int));
DECLARE_C_EXTERN(char*,    getlogin, ());
DECLARE_C_EXTERN(int,      getopt, (int, char**, char*));
DECLARE_C_EXTERN(int,      getpagesize, ());
DECLARE_C_EXTERN(char*,    getpass, (const char*));
DECLARE_C_EXTERN(int,      getpgrp, ());
DECLARE_C_EXTERN(int,      getpid, ());
DECLARE_C_EXTERN(int,      getppid, ());
DECLARE_C_EXTERN(int,      getpriority, (int, int));
DECLARE_C_EXTERN(int,      getpw, (int, char*));
DECLARE_C_EXTERN(unsigned, int getuid, ());
DECLARE_C_EXTERN(char*,    getwd, (const char*));
DECLARE_C_EXTERN(char*,    index, (const char*, int));
DECLARE_C_EXTERN(char*,    initstate, (unsigned, char*, int));
DECLARE_C_EXTERN(int,      ioctl, (int, int, char*));
DECLARE_C_EXTERN(int,      isatty, (int));
DECLARE_C_EXTERN(long,     jrand48, (short*));
DECLARE_C_EXTERN(int,      kill, (int, int));
DECLARE_C_EXTERN(int,      killpg, (int, int));
DECLARE_C_EXTERN(void,     lcong48, (short*));
DECLARE_C_EXTERN(int,      link, (const char*, const char*));
DECLARE_C_EXTERN(int,      lock, (int, int, long));
DECLARE_C_EXTERN(long,     lrand48, ());
DECLARE_C_EXTERN(long,     lseek, (int, long, int));
DECLARE_C_EXTERN(void*,    malloc, (unsigned));
DECLARE_C_EXTERN(void*,    memalign, (unsigned, unsigned));
DECLARE_C_EXTERN(void*,    memccpy, (void*, const void*, int, int));
DECLARE_C_EXTERN(void*,    memchr, (const void*, int, int));
DECLARE_C_EXTERN(int,      memcmp, (const void*, const void*, int));
DECLARE_C_EXTERN(void*,    memcpy, (void*, const void*, int));
DECLARE_C_EXTERN(void*,    memset, (void*, int, int));
DECLARE_C_EXTERN(int,      mkdir, (const char*, int));
DECLARE_C_EXTERN(int,      mknod, (const char*, int, int));
DECLARE_C_EXTERN(char*,    mkstemp, (char*));
DECLARE_C_EXTERN(char*,    mktemp, (char*));
DECLARE_C_EXTERN(long,     mrand48, ());
DECLARE_C_EXTERN(int,      nice, (int));
DECLARE_C_EXTERN(long,     nrand48, (short*));
DECLARE_C_EXTERN(int,      open, (const char*, int, int));
DECLARE_C_EXTERN(void,     pause, ());
DECLARE_C_EXTERN(void,     perror, (const char*));
DECLARE_C_EXTERN(int,      pipe , (int));
DECLARE_C_EXTERN(void,     profil, (char*, int, int, int));
DECLARE_C_EXTERN(int,      psignal, (unsigned, char*));
DECLARE_C_EXTERN(int,      ptrace, (int, int, int, int));
DECLARE_C_EXTERN(int,      putenv, (const char*));
DECLARE_C_EXTERN(int,      rand, ());
DECLARE_C_EXTERN(long,     random, ());
DECLARE_C_EXTERN(int,      read, (int, void*, unsigned));
DECLARE_C_EXTERN(int,      readlink, (const char*, char*, int));
DECLARE_C_EXTERN(void*,    realloc, (void*, unsigned));
DECLARE_C_EXTERN(int,      rename, (const char*, const char*));
DECLARE_C_EXTERN(char*,    rindex, (const char*, int));
DECLARE_C_EXTERN(int,      rmdir, (const char*));               
DECLARE_C_EXTERN(void*,    sbrk, (int));              
DECLARE_C_EXTERN(short*,   seed48, (short*));
DECLARE_C_EXTERN(int,      send, (int, char*, int, int));
DECLARE_C_EXTERN(int,      setgid, (int));
DECLARE_C_EXTERN(int,      sethostname, (char*, int));
DECLARE_C_EXTERN(int,      setkey, (const char*));
DECLARE_C_EXTERN(int,      setpgrp, (int, int));
DECLARE_C_EXTERN(int,      setpriority, (int, int, int));
DECLARE_C_EXTERN(int,      setregid, (int, int));
DECLARE_C_EXTERN(int,      setreuid, (int, int));
DECLARE_C_EXTERN(char*,    setstate, (char*));
DECLARE_C_EXTERN(int,      setuid, (int));
DECLARE_C_EXTERN(int,      sigblock, (int));
DECLARE_C_EXTERN(int,      siginterrupt, (int, int));
DECLARE_C_EXTERN(int,      sigpause, (int));
DECLARE_C_EXTERN(int,      sigsetmask, (int));
DECLARE_C_EXTERN(unsigned, sleep, (unsigned));
DECLARE_C_EXTERN(int,      srand, (int));
DECLARE_C_EXTERN(void,     srand48, (long));
DECLARE_C_EXTERN(int,      stime, (long*));
DECLARE_C_EXTERN(char*,    strcat, (char*, const char*));
DECLARE_C_EXTERN(char*,    strchr, (const char*, int));
DECLARE_C_EXTERN(int,      strcmp, (const char*, const char*));
DECLARE_C_EXTERN(char*,    strcpy, (char*, const char*));
DECLARE_C_EXTERN(int,      strcspn, (const char*, const char*));
DECLARE_C_EXTERN(char*,    strdup, (const char*));
DECLARE_C_EXTERN(int,      strlen, (const char*));
DECLARE_C_EXTERN(char*,    strncat, (char*, const char*, int));
DECLARE_C_EXTERN(int,      strncmp, (const char*, const char*, int));
DECLARE_C_EXTERN(char*,    strncpy, (char*, const char*, int));
DECLARE_C_EXTERN(char*,    strpbrk, (const char*, const char*));
DECLARE_C_EXTERN(char*,    strrchr, (const char*, int));
DECLARE_C_EXTERN(int,      strspn, (const char*, const char*));
DECLARE_C_EXTERN(double,   strtod, (const char*, char**));
DECLARE_C_EXTERN(char*,    strtok, (char*, const char*));
DECLARE_C_EXTERN(long,     strtol, (const char*, char**, int));
DECLARE_C_EXTERN(void,     swab, (void*, void*, int));
DECLARE_C_EXTERN(int,      symlink, (const char*, const char*));
DECLARE_C_EXTERN(int,      syscall, (int, ...));
DECLARE_C_EXTERN(int,      system, (const char*));
DECLARE_C_EXTERN(char*,    tempnam, (char*, char*));
DECLARE_C_EXTERN(long,     time, (long*));
//DECLARE_C_EXTERN(char*,    timezone, (int, int));
DECLARE_C_EXTERN(char*,    tmpnam, (char*));
DECLARE_C_EXTERN(int,      truncate, (const char*, unsigned long));
DECLARE_C_EXTERN(char*,    ttyname, (int));
DECLARE_C_EXTERN(int,      ttyslot, ());
DECLARE_C_EXTERN(unsigned, ualarm, (unsigned, unsigned));
DECLARE_C_EXTERN(long,     ulimit, (int, long));
DECLARE_C_EXTERN(int,      umask, (int));
DECLARE_C_EXTERN(int,      unlink, (const char*));
DECLARE_C_EXTERN(unsigned, usleep, (unsigned));
DECLARE_C_EXTERN(int,      vadvise, (int));
DECLARE_C_EXTERN(void*,    valloc, (unsigned));
DECLARE_C_EXTERN(int,      vfork, ());
DECLARE_C_EXTERN(int,      vhangup, ());
DECLARE_C_EXTERN(int,      wait, (int*));
DECLARE_C_EXTERN(int,      write, (int, const void*, unsigned));


extern char**   environ;
extern int      errno;
extern char*    sys_errlist[];
extern int      sys_nerr;                  
extern char*    optarg;
extern int      opterr;
extern int      optind;

#endif 
