/*
 test/demo of linked structures
*/

#include <stream.h>
#include "intSLList.h"
#include "intDLList.h"

void printint(int x)
{
  cout << x << " ";
}


void printlist(intSLList& l)
{
  for (intSLListTrav p(l); p; p.advance())
    cout << p.get() << " ";
  cout << "\n";
}

void printDlist(intDLList& l)
{
  for (intDLListTrav p(l); p; p.advance())
    cout << p.get() << " ";
  cout << "\n";
}

main()
{
  int i, x;
  intSLList a;
  cout << "intSLList a: length() = " << a.length() << "\n"; printlist(a);
  cout << "prepending...";
  for (i = 0; i < 10; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    a.prepend(x);
  }
  cout << "\n";
  cout << "a: length() = " << a.length() << "\n"; printlist(a);
  cout << "appending...";
  for (i = 0; i < 10; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    a.append(x);
  }
  cout << "\n";
  cout << "a: length() = " << a.length() << "\n"; printlist(a);
  intSLList b = a;
  cout << "b = a: length() = " << b.length() << "\n"; printlist(b);
  cout << "remove_front of first 10 elements:\n";
  for (i = 0; i < 10; ++i) cout << b.remove_front() << " ";
  cout << "\n";
  cout << "b: length() = " << b.length() << "\n"; printlist(b);

  cout << "inserting after sixth element...";
  intSLListTrav bp(b);
  for (i = 0; i < 5; ++i) bp.advance();
  x = rand() % 100;
  cout << x << " ";
  bp.insert_after(x);
  cout << "\n";
  cout << "b: length() = " << b.length() << "\n"; printlist(b);
  b.clear();
  cout << "after b.clear() ";
  cout << "b: length() = " << b.length() << "\n"; printlist(b);


  intSLStack s;
  cout << "pushing all of a onto stack s...";
  for (intSLListTrav ap = a; ap; ap.advance()) s.push(ap.get());
  cout << "popping all of s:\n";
  while (s) cout << s.pop() << " ";
  cout << "\n";

  intSLQueue q;
  cout << "enqueueing all of a onto queue q...";
  for (ap = a; ap; ap.advance()) q.enq(ap.get());
  cout << "dequeueing all of q:\n";
  while (q) cout << q.deq() << " ";
  cout << "\n";

  intDLList y;
  cout << "intDLList y: length() = " << y.length() << "\n"; printDlist(y);
  cout << "prepending...";
  for (i = 0; i < 10; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    y.prepend(x);
  }
  cout << "\n";
  cout << "y: length() = " << y.length() << "\n"; printDlist(y);
  cout << "appending...";
  for (i = 0; i < 10; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    y.append(x);
  }
  cout << "\n";
  cout << "y: length() = " << y.length() << "\n"; printDlist(y);
  intDLList z = y;
  cout << "z = y: length() = " << z.length() << "\n"; printDlist(z);
  cout << "remove_front of first 10 elements:\n";
  for (i = 0; i < 10; ++i) cout << z.remove_front() << " ";
  cout << "\n";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);

  cout << "remove_rear of last 5 elements:\n";
  for (i = 0; i < 5; ++i) cout << z.remove_rear() << " ";
  cout << "\n";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);

  cout << "inserting before alternate elements...";
  for (intDLListTrav zp(z); zp; zp.advance())
  {
    x = rand() % 100;
    cout << x << " ";
    zp.insert_before(x);
  }
  cout << "\n";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);

  cout << "inserting after sixth element...";
  zp.reset(z);
  for (i = 0; i < 5; ++i) zp.advance();
  x = rand() % 100;
  cout << x << " ";
  zp.insert_after(x);
  cout << "\n";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);

  cout << "deleting alternate elements of z...";
  for (zp.reset(); zp; zp.advance())
  {
    cout << zp.get() << " ";
    zp.del();
  }
  cout << "\n";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);
  
  cout << "z in reverse order via traverser:\n";
  for (zp.reset(-1); zp; zp.advance(-1))
    cout << zp.get() << " ";
  cout << "\n";
  z.clear();
  cout << "after z.clear() ";
  cout << "z: length() = " << z.length() << "\n"; printDlist(z);

  cout << "\nEnd of test\n";
}
