/* 
  some exception-handling macros from Marc Shapiro
*/

#ifndef TEST_EXCEPTIONS_H
#define TEST_EXCEPTIONS_H
#define DONT_DECLARE_EXCEPTION   // see math.h

#include <setjmp.h>
#include <signal.h>
#include <string.h>

// definitions of exception-raising for test purposes

jmp_buf exception_buf;
volatile jmp_buf *exceptn = &exception_buf;

#define raise(x) do {\
    cerr << "Raising exception: " << #x << " (" << __FILE__ << ":" << __LINE__ << ")\n"; \
    longjmp (*exceptn, (int) #x); \
} while(0)

#define raises(x)

#define succeed(x) do { \
    volatile char* name; \
    if (name = (char*) setjmp (*exceptn)) { \
       /* exceptional return: is a bug */ \
       cerr << __FILE__ << ":" << __LINE__ << \
           ": unexpected exception return: " << name << \
           ", from ``" << #x << "''\n"; \
       cerr.flush(); \
       assert(0); \
    } else { \
       x; \
    } \
} while (0)

#define fail(x,y) do { \
    volatile char* name; \
    if (name = (char*)setjmp (*exceptn)) { \
       if (strcmp(name,#y)!=0) {\
          cerr << __FILE__ << ":" << __LINE__ << \
              ": returned with exception: " << name << \
              ", instead of exception: " << #y << \
              ", from ``" << #x << "''\n"; \
          cerr.flush(); \
          assert(0); \
          } \
    } else { \
       x; \
       cerr << __FILE__ << ":" << __LINE__ << \
           ": exception not received; expected " << #y << \
           ", from ``" << #x << "''\n"; \
       cerr.flush(); \
       assert(0); \
    } \
} while(0)

#endif TEST_EXCEPTIONS_H
