// The template and inlines for the -*- C++ -*- gslice class.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// Written by Gabriel Dos Reis <Gabriel.Dos-Reis@DPTMaths.ENS-Cachan.Fr>

#ifndef _CPP_BITS_GSLICE_H
#define _CPP_BITS_GSLICE_H

namespace std {

class gslice
{
public:
    gslice ();
    gslice (size_t, const valarray<size_t>&, const valarray<size_t>&);
    ~gslice();
    
    size_t           start () const;
    valarray<size_t> size () const;
    valarray<size_t> stride () const;



private:
    const size_t _M_sz;
    const size_t _M_offset;
    const size_t _M_index_size;
    const valarray<size_t> _M_lengths;
    const valarray<size_t> _M_strides;
    const _Array<size_t> _M_index;

    //    template<> friend class _Array<size_t>;
    //    template<typename _Tp> friend class valarray<_Tp>;
    //    template<typename _Tp> friend class gslice_array<_Tp>;
    //    template<class _E> friend class _GsliceExpression<_E>;
    
    void _M_convert_to_index();
};

inline size_t
gslice::start () const
{ return _M_offset; }

inline valarray<size_t>
gslice::size () const
{ return _M_lengths; }

inline valarray<size_t>
gslice::stride () const
{ return _M_strides; }

inline void
gslice::_M_convert_to_index ()
{
    size_t __n = _M_lengths.size ();
    size_t* __tmp_idx (static_cast<size_t*> (alloca (__n*sizeof (size_t))));
    fill (__tmp_idx, __tmp_idx+__n, static_cast<size_t> (0));
    __valarray_fill (_M_index, _M_index_size, _M_offset);
    for (size_t __i=0; __i<_M_index_size; ++__i) {
        for (size_t __k=0; __k<__n; ++__k) 
	  _M_index._M_data[__i] += _M_strides[__k]*__tmp_idx[__k];
        ++__tmp_idx[__n-1];
        for (size_t __l=__n-1; __l; --__l) {
            if (__tmp_idx[__l] >= _M_lengths[__l]) {
                __tmp_idx[__l] = 0;
                ++__tmp_idx[__l-1];
            }
        }
    }
}

inline gslice::gslice () 
  : _M_sz(0), _M_offset(0), _M_index_size(0),
    _M_index(static_cast<size_t> (0)) 
  {}

inline
gslice::gslice (size_t __s, const valarray<size_t>& __l, 
                const valarray<size_t>& __d)
  : _M_sz (__l.size ()), _M_offset (__s), _M_index_size (__l.product ()), 
    _M_lengths (__l), _M_strides (__d), _M_index (_M_index_size)
{
    _M_convert_to_index ();
}

inline gslice::~gslice() { _M_index.free_data(); }

} // std::


#endif /* _CPP_BITS_GSLICE_H */

// Local Variables:
// mode:c++
// End:
