/*
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */

#ifndef _CPP_BITS_STL_PAIR_H
#define _CPP_BITS_STL_PAIR_H 1

__STL_BEGIN_NAMESPACE

template <class _Tp1, class _Tp2>
struct pair {
  typedef _Tp1 first_type;
  typedef _Tp2 second_type;

  _Tp1 first;
  _Tp2 second;
  pair() : first(_Tp1()), second(_Tp2()) {}
  pair(const _Tp1& __a, const _Tp2& __b) : first(__a), second(__b) {}

#ifdef __STL_MEMBER_TEMPLATES
  template <class _U1, class _U2>
  pair(const pair<_U1, _U2>& __p) : first(__p.first), second(__p.second) {}
#endif
};

template <class _Tp1, class _Tp2>
inline bool operator==(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return __x.first == __y.first && __x.second == __y.second; 
}

// CYGNUS LOCAL 10/28/1998
template <class _Tp1, class _Tp2>
inline bool operator!=(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return !(__x == __y);
}

template <class _Tp1, class _Tp2>
inline bool operator<(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return __x.first < __y.first || 
         (!(__y.first < __x.first) && __x.second < __y.second); 
}

// CYGNUS LOCAL 10/28/1998
template <class _Tp1, class _Tp2>
inline bool operator>(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return __y < __x;
}

// CYGNUS LOCAL 10/28/1998
template <class _Tp1, class _Tp2>
inline bool operator<=(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return !(__x > __y);
}

// CYGNUS LOCAL 10/28/1998
template <class _Tp1, class _Tp2>
inline bool operator>=(const pair<_Tp1, _Tp2>& __x, const pair<_Tp1, _Tp2>& __y)
{ 
  return !(__x < __y);
}

template <class _Tp1, class _Tp2>
inline pair<_Tp1, _Tp2> make_pair(const _Tp1& __x, const _Tp2& __y)
{
  return pair<_Tp1, _Tp2>(__x, __y);
}

__STL_END_NAMESPACE

#endif /* _CPP_BITS_STL_PAIR_H */

// Local Variables:
// mode:C++
// End:
