// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// XXX not used.

#include <locale>
#include <cstring>


// Implementation of ctype<char>.
bool
ctype<char>::do_is (mask m, char c) const
{
  return (__ctype_b[(int) c] & (unsigned short int) m) != 0;
}


const char *
ctype<char>::do_is (const char *low, const char *high, mask *vec) const
{
  while (low < high)
    *vec++ = static_cast<mask> (__ctype_b[(int) *low++]);
  return high;
}


const char *
ctype<char>::do_scan_is (mask m, const char *low, const char *high) const
{
  while (low < high && (__ctype_b[(int) *low] & (unsigned short int) m) == 0)
    ++low;
  return low;
}


const char *
ctype<char>::do_scan_not (mask m, const char *low, const char *high) const
{
  while (low < high && (__ctype_b[(int) *low] & (unsigned short int) m) == 0)
    ++low;
  return low;
}


char
ctype<char>::do_toupper (char c) const
{
  return __ctype_toupper[(int) c];
}


const char *
ctype<char>::do_toupper (char *low, const char *high) const
{
  while (low < high)
    {
      *low = __ctype_toupper[(int) *low];
      ++low;
    }
  return high;
}


char
ctype<char>::do_tolower (char c) const
{
  return __ctype_tolower[(int) c];
}


const char *
ctype<char>::do_tolower (char *low, const char *high) const
{
  while (low < high)
    {
      *low = __ctype_tolower[(int) *low];
      ++low;
    }
  return high;
}


char
ctype<char>::do_widen (char c) const
{
  return c;
}


const char *
ctype<char>::do_widen (const char *low, const char *high, char *dest)
{
  memcpy (dest, low, high - low);
  return high;
}


char
ctype<char>::do_narrow (char c, char dfault) const
{
  return c;
}


const char *
ctype<char>::do_narrow (const char *low, const char *high, char dfault,
			char *dest) const
{
  memcpy (dest, low, high - low);
  return high;
}


// Implementation of ctype<wchar_t>.
bool
ctype<wchar_t>::do_is (mask m, wchar_t c) const
{
  return iswctype (c, m) != 0;
}


#define _ISall (_ISspace|_ISprint|_IScntrl|_ISupper|_ISlower|_ISalpha \
		|_ISdigit|_ISpunct|_ISxdigit|_ISalnum|_ISgraph)

const wchar_t *
ctype<wchar_t>::do_is (const wchar_t *low, const wchar_t *high,
		       mask *vec) const
{
  while (low < high)
    *vec++ = static_cast<mask> (iswctype (*low++, _ISall));
  return high;
}


const wchar_t *
ctype<wchar_t>::do_scan_is (mask m, const wchar_t *low,
			    const wchar_t *high) const
{
  while (low < high && iswctype (*low, m) == 0)
    ++low;
  return low;
}


const wchar_t *
ctype<wchar_t>::do_scan_not (mask m, const wchar_t *low,
			     const wchar_t *high) const
{
  while (low < high && iswctype (*low, m) != 0)
    ++low;
  return low;
}


wchar_t
ctype<wchar_t>::do_toupper (wchar_t c) const
{
  return towupper (c);
}


const wchar_t *
ctype<wchar_t>::do_toupper (wchar_t *low, const wchar_t *high) const
{
  while (low < high)
    {
      *low = towupper (*low);
      ++low;
    }
  return high;
}


wchar_t
ctype<wchar_t>::do_tolower (wchar_t c) const
{
  return towlower (c);
}


const wchar_t *
ctype<wchar_t>::do_tolower (wchar_t *low, const wchar_t *high) const
{
  while (low < high)
    {
      *low = towlower (*low);
      ++low;
    }
  return high;
}


wchar_t
ctype<wchar_t>::do_widen (wchar_t c) const
{
  return static_cast<wchar_t> (c);
}


const char *
ctype<wchar_t>::do_widen (const char *low, const char *high, wchar_t *dest)
{
  while (low < high)
    *dest++ = static_cast<wchar_t> (*low++);
  return high;
}


char
ctype<char>::do_narrow (wchar_t c, char dfault) const
{
  return c > 0xff ? dfault : static_cast<char> (c);
}


const char *
ctype<char>::do_narrow (const wchar_t *low, const wchar_t *high, char dfault,
			char *dest) const
{
  while (low < high)
    {
      *dest++ = *low > 0xff ? dfault : static_cast<char> (*low);
      ++low;
    }
  return high;
}
