/* Opcode table for m680[012346]0/m6888[12]/m68851/mcf5200.
   Copyright 1989, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
   2000, 2001
   Free Software Foundation, Inc.

This file is part of GDB, GAS, and the GNU binutils.

GDB, GAS, and the GNU binutils are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
1, or (at your option) any later version.

GDB, GAS, and the GNU binutils are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include "sysdep.h"
#include "opcode/m68k.h"

#define one(x) ((unsigned int) (x) << 16)
#define two(x, y) (((unsigned int) (x) << 16) + (y))

/* The assembler requires that all instances of the same mnemonic must
   be consecutive.  If they aren't, the assembler will bomb at
   runtime.  */

const struct m68k_opcode m68k_opcodes[] =
{
{"abcd",	one(0140400),	one(0170770), "DsDd", m68000up },
{"abcd",	one(0140410),	one(0170770), "-s-d", m68000up },

{"addaw",	one(0150300),	one(0170700), "*wAd", m68000up },
{"addal",	one(0150700),	one(0170700), "*lAd", m68000up | mcf },

{"addib",	one(0003000),	one(0177700), "#b$s", m68000up },
{"addiw",	one(0003100),	one(0177700), "#w$s", m68000up },
{"addil",	one(0003200),	one(0177700), "#l$s", m68000up },
{"addil",	one(0003200),	one(0177700), "#lDs", mcf },

{"addqb",	one(0050000),	one(0170700), "Qd$b", m68000up },
{"addqw",	one(0050100),	one(0170700), "Qd%w", m68000up },
{"addql",	one(0050200),	one(0170700), "Qd%l", m68000up | mcf },

/* The add opcode can generate the adda, addi, and addq instructions.  */
{"addb",	one(0050000),	one(0170700), "Qd$b", m68000up },
{"addb",	one(0003000),	one(0177700), "#b$s", m68000up },
{"addb",	one(0150000),	one(0170700), ";bDd", m68000up },
{"addb",	one(0150400),	one(0170700), "Dd~b", m68000up },
{"addw",	one(0050100),	one(0170700), "Qd%w", m68000up },
{"addw",	one(0150300),	one(0170700), "*wAd", m68000up },
{"addw",	one(0003100),	one(0177700), "#w$s", m68000up },
{"addw",	one(0150100),	one(0170700), "*wDd", m68000up },
{"addw",	one(0150500),	one(0170700), "Dd~w", m68000up },
{"addl",	one(0050200),	one(0170700), "Qd%l", m68000up | mcf },
{"addl",	one(0003200),	one(0177700), "#l$s", m68000up },
{"addl",	one(0003200),	one(0177700), "#lDs", mcf },
{"addl",	one(0150700),	one(0170700), "*lAd", m68000up | mcf },
{"addl",	one(0150200),	one(0170700), "*lDd", m68000up | mcf },
{"addl",	one(0150600),	one(0170700), "Dd~l", m68000up | mcf },

{"addxb",	one(0150400),	one(0170770), "DsDd", m68000up },
{"addxb",	one(0150410),	one(0170770), "-s-d", m68000up },
{"addxw",	one(0150500),	one(0170770), "DsDd", m68000up },
{"addxw",	one(0150510),	one(0170770), "-s-d", m68000up },
{"addxl",	one(0150600),	one(0170770), "DsDd", m68000up | mcf },
{"addxl",	one(0150610),	one(0170770), "-s-d", m68000up },

{"andib",	one(0001000),	one(0177700), "#b$s", m68000up },
{"andib",	one(0001074),	one(0177777), "#bCs", m68000up },
{"andiw",	one(0001100),	one(0177700), "#w$s", m68000up },
{"andiw",	one(0001174),	one(0177777), "#wSs", m68000up },
{"andil",	one(0001200),	one(0177700), "#l$s", m68000up },
{"andil",	one(0001200),	one(0177700), "#lDs", mcf },
{"andi",	one(0001100),	one(0177700), "#w$s", m68000up },
{"andi",	one(0001074),	one(0177777), "#bCs", m68000up },
{"andi",	one(0001174),	one(0177777), "#wSs", m68000up },

/* The and opcode can generate the andi instruction.  */
{"andb",	one(0001000),	one(0177700), "#b$s", m68000up },
{"andb",	one(0001074),	one(0177777), "#bCs", m68000up },
{"andb",	one(0140000),	one(0170700), ";bDd", m68000up },
{"andb",	one(0140400),	one(0170700), "Dd~b", m68000up },
{"andw",	one(0001100),	one(0177700), "#w$s", m68000up },
{"andw",	one(0001174),	one(0177777), "#wSs", m68000up },
{"andw",	one(0140100),	one(0170700), ";wDd", m68000up },
{"andw",	one(0140500),	one(0170700), "Dd~w", m68000up },
{"andl",	one(0001200),	one(0177700), "#l$s", m68000up },
{"andl",	one(0001200),	one(0177700), "#lDs", mcf },
{"andl",	one(0140200),	one(0170700), ";lDd", m68000up | mcf },
{"andl",	one(0140600),	one(0170700), "Dd~l", m68000up | mcf },
{"and",		one(0001100),	one(0177700), "#w$w", m68000up },
{"and",		one(0001074),	one(0177777), "#bCs", m68000up },
{"and",		one(0001174),	one(0177777), "#wSs", m68000up },
{"and",		one(0140100),	one(0170700), ";wDd", m68000up },
{"and",		one(0140500),	one(0170700), "Dd~w", m68000up },

{"aslb",	one(0160400),	one(0170770), "QdDs", m68000up },
{"aslb",	one(0160440),	one(0170770), "DdDs", m68000up },
{"aslw",	one(0160500),	one(0170770), "QdDs", m68000up },
{"aslw",	one(0160540),	one(0170770), "DdDs", m68000up },
{"aslw",	one(0160700),	one(0177700), "~s",   m68000up },
{"asll",	one(0160600),	one(0170770), "QdDs", m68000up | mcf },
{"asll",	one(0160640),	one(0170770), "DdDs", m68000up | mcf },

{"asrb",	one(0160000),	one(0170770), "QdDs", m68000up },
{"asrb",	one(0160040),	one(0170770), "DdDs", m68000up },
{"asrw",	one(0160100),	one(0170770), "QdDs", m68000up },
{"asrw",	one(0160140),	one(0170770), "DdDs", m68000up },
{"asrw",	one(0160300),	one(0177700), "~s",   m68000up },
{"asrl",	one(0160200),	one(0170770), "QdDs", m68000up | mcf },
{"asrl",	one(0160240),	one(0170770), "DdDs", m68000up | mcf },

{"bhiw",	one(0061000),	one(0177777), "BW", m68000up | mcf },
{"blsw",	one(0061400),	one(0177777), "BW", m68000up | mcf },
{"bccw",	one(0062000),	one(0177777), "BW", m68000up | mcf },
{"bcsw",	one(0062400),	one(0177777), "BW", m68000up | mcf },
{"bnew",	one(0063000),	one(0177777), "BW", m68000up | mcf },
{"beqw",	one(0063400),	one(0177777), "BW", m68000up | mcf },
{"bvcw",	one(0064000),	one(0177777), "BW", m68000up | mcf },
{"bvsw",	one(0064400),	one(0177777), "BW", m68000up | mcf },
{"bplw",	one(0065000),	one(0177777), "BW", m68000up | mcf },
{"bmiw",	one(0065400),	one(0177777), "BW", m68000up | mcf },
{"bgew",	one(0066000),	one(0177777), "BW", m68000up | mcf },
{"bltw",	one(0066400),	one(0177777), "BW", m68000up | mcf },
{"bgtw",	one(0067000),	one(0177777), "BW", m68000up | mcf },
{"blew",	one(0067400),	one(0177777), "BW", m68000up | mcf },

{"bhil",	one(0061377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"blsl",	one(0061777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bccl",	one(0062377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bcsl",	one(0062777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bnel",	one(0063377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"beql",	one(0063777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bvcl",	one(0064377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bvsl",	one(0064777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bpll",	one(0065377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bmil",	one(0065777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bgel",	one(0066377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bltl",	one(0066777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bgtl",	one(0067377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"blel",	one(0067777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},

{"bhis",	one(0061000),	one(0177400), "BB", m68000up | mcf },
{"blss",	one(0061400),	one(0177400), "BB", m68000up | mcf },
{"bccs",	one(0062000),	one(0177400), "BB", m68000up | mcf },
{"bcss",	one(0062400),	one(0177400), "BB", m68000up | mcf },
{"bnes",	one(0063000),	one(0177400), "BB", m68000up | mcf },
{"beqs",	one(0063400),	one(0177400), "BB", m68000up | mcf },
{"bvcs",	one(0064000),	one(0177400), "BB", m68000up | mcf },
{"bvss",	one(0064400),	one(0177400), "BB", m68000up | mcf },
{"bpls",	one(0065000),	one(0177400), "BB", m68000up | mcf },
{"bmis",	one(0065400),	one(0177400), "BB", m68000up | mcf },
{"bges",	one(0066000),	one(0177400), "BB", m68000up | mcf },
{"blts",	one(0066400),	one(0177400), "BB", m68000up | mcf },
{"bgts",	one(0067000),	one(0177400), "BB", m68000up | mcf },
{"bles",	one(0067400),	one(0177400), "BB", m68000up | mcf },

{"jhi",		one(0061000),	one(0177400), "Bg", m68000up | mcf },
{"jls",		one(0061400),	one(0177400), "Bg", m68000up | mcf },
{"jcc",		one(0062000),	one(0177400), "Bg", m68000up | mcf },
{"jcs",		one(0062400),	one(0177400), "Bg", m68000up | mcf },
{"jne",		one(0063000),	one(0177400), "Bg", m68000up | mcf },
{"jeq",		one(0063400),	one(0177400), "Bg", m68000up | mcf },
{"jvc",		one(0064000),	one(0177400), "Bg", m68000up | mcf },
{"jvs",		one(0064400),	one(0177400), "Bg", m68000up | mcf },
{"jpl",		one(0065000),	one(0177400), "Bg", m68000up | mcf },
{"jmi",		one(0065400),	one(0177400), "Bg", m68000up | mcf },
{"jge",		one(0066000),	one(0177400), "Bg", m68000up | mcf },
{"jlt",		one(0066400),	one(0177400), "Bg", m68000up | mcf },
{"jgt",		one(0067000),	one(0177400), "Bg", m68000up | mcf },
{"jle",		one(0067400),	one(0177400), "Bg", m68000up | mcf },

{"bchg",	one(0000500),	one(0170700), "Dd$s", m68000up | mcf },
{"bchg",	one(0004100),	one(0177700), "#b$s", m68000up },
{"bchg",	one(0004100),	one(0177700), "#bqs", mcf },

{"bclr",	one(0000600),	one(0170700), "Dd$s", m68000up },
{"bclr",	one(0000600),	one(0170700), "Ddvs", mcf },
{"bclr",	one(0004200),	one(0177700), "#b$s", m68000up },
{"bclr",	one(0004200),	one(0177700), "#bqs", mcf },

{"bfchg",	two(0165300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bfclr",	two(0166300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bfexts",	two(0165700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfextu",	two(0164700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfffo",	two(0166700, 0), two(0177700, 0100000),	"/sO2O3D1", m68020up },
{"bfins",	two(0167700, 0), two(0177700, 0100000),	"D1?sO2O3", m68020up },
{"bfset",	two(0167300, 0), two(0177700, 0170000),	"?sO2O3",   m68020up },
{"bftst",	two(0164300, 0), two(0177700, 0170000),	"/sO2O3",   m68020up },

{"bgnd",	one(0045372),		one(0177777), "", cpu32 },

{"bkpt",	one(0044110),		one(0177770), "ts", m68010up },

{"braw",	one(0060000),	one(0177777), "BW", m68000up | mcf },
{"bral",	one(0060377),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bras",	one(0060000),	one(0177400), "BB", m68000up | mcf },

{"bset",	one(0000700),	one(0170700), "Dd$s", m68000up },
{"bset",	one(0000700),	one(0170700), "Ddvs", mcf },
{"bset",	one(0004300),	one(0177700), "#b$s", m68000up },
{"bset",	one(0004300),	one(0177700), "#bqs", mcf },

{"bsrw",	one(0060400),	one(0177777), "BW", m68000up | mcf },
{"bsrl",	one(0060777),	one(0177777), "BL", m68020up | cpu32 | mcf5407},
{"bsrs",	one(0060400),	one(0177400), "BB", m68000up | mcf },

{"btst",	one(0000400),	one(0170700), "Dd;b", m68000up | mcf },
{"btst",	one(0004000),	one(0177700), "#b@s", m68000up },
{"btst",	one(0004000),	one(0177700), "#bqs", mcf },

{"callm",	one(0003300),		one(0177700), "#b!s", m68020 },

{"cas2w",     two(0006374,0), two(0177777,0007070), "D3D6D2D5r1r4", m68020up },
{"cas2w",     two(0006374,0), two(0177777,0007070), "D3D6D2D5R1R4", m68020up },
{"cas2l",     two(0007374,0), two(0177777,0007070), "D3D6D2D5r1r4", m68020up },
{"cas2l",     two(0007374,0), two(0177777,0007070), "D3D6D2D5R1R4", m68020up },

{"casb",	two(0005300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },
{"casw",	two(0006300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },
{"casl",	two(0007300, 0), two(0177700, 0177070),	"D3D2~s", m68020up },

{"chk2b", two(0000300,0004000), two(0177700,07777), "!sR1", m68020up | cpu32 },
{"chk2w", two(0001300,0004000),	two(0177700,07777), "!sR1", m68020up | cpu32 },
{"chk2l", two(0002300,0004000),	two(0177700,07777), "!sR1", m68020up | cpu32 },

{"chkl",	one(0040400),		one(0170700), ";lDd", m68000up },
{"chkw",	one(0040600),		one(0170700), ";wDd", m68000up },

#define SCOPE_LINE (0x1 << 3)
#define SCOPE_PAGE (0x2 << 3)
#define SCOPE_ALL  (0x3 << 3)

{"cinva",	one(0xf400|SCOPE_ALL),  one(0xff38), "ce",   m68040up },
{"cinvl",	one(0xf400|SCOPE_LINE), one(0xff38), "ceas", m68040up },
{"cinvp",	one(0xf400|SCOPE_PAGE), one(0xff38), "ceas", m68040up },

{"cpusha",	one(0xf420|SCOPE_ALL),  one(0xff38), "ce",   m68040up },
{"cpushl",	one(0xf420|SCOPE_LINE), one(0xff38), "ceas", m68040up | mcf },
{"cpushp",	one(0xf420|SCOPE_PAGE), one(0xff38), "ceas", m68040up },

#undef SCOPE_LINE
#undef SCOPE_PAGE
#undef SCOPE_ALL

{"clrb",	one(0041000),	one(0177700), "$s", m68000up | mcf },
{"clrw",	one(0041100),	one(0177700), "$s", m68000up | mcf },
{"clrl",	one(0041200),	one(0177700), "$s", m68000up | mcf },

{"cmp2b",	two(0000300,0), two(0177700,07777), "!sR1", m68020up | cpu32 },
{"cmp2w",	two(0001300,0),	two(0177700,07777), "!sR1", m68020up | cpu32 },
{"cmp2l",	two(0002300,0),	two(0177700,07777), "!sR1", m68020up | cpu32 },

{"cmpaw",	one(0130300),	one(0170700), "*wAd", m68000up },
{"cmpal",	one(0130700),	one(0170700), "*lAd", m68000up | mcf },

{"cmpib",	one(0006000),	one(0177700), "#b@s", m68000up },
{"cmpib",	one(0006000),	one(0177700), "#bDs", mcf5407 },
{"cmpiw",	one(0006100),	one(0177700), "#w@s", m68000up },
{"cmpiw",	one(0006100),	one(0177700), "#wDs", mcf5407 },
{"cmpil",	one(0006200),	one(0177700), "#l@s", m68000up },
{"cmpil",	one(0006200),	one(0177700), "#lDs", mcf },

{"cmpmb",	one(0130410),	one(0170770), "+s+d", m68000up },
{"cmpmw",	one(0130510),	one(0170770), "+s+d", m68000up },
{"cmpml",	one(0130610),	one(0170770), "+s+d", m68000up },

/* The cmp opcode can generate the cmpa, cmpm, and cmpi instructions.  */
{"cmpb",	one(0006000),	one(0177700), "#b@s", m68000up },
{"cmpb",	one(0006000),	one(0177700), "#bDs", mcf5407 },
{"cmpb",	one(0130410),	one(0170770), "+s+d", m68000up },
{"cmpb",	one(0130000),	one(0170700), ";bDd", m68000up },
{"cmpb",	one(0130000),	one(0170700), "*bDd", mcf5407 },
{"cmpw",	one(0130300),	one(0170700), "*wAd", m68000up },
{"cmpw",	one(0006100),	one(0177700), "#w@s", m68000up },
{"cmpw",	one(0006100),	one(0177700), "#wDs", mcf5407 },
{"cmpw",	one(0130510),	one(0170770), "+s+d", m68000up },
{"cmpw",	one(0130100),	one(0170700), "*wDd", m68000up | mcf5407 },
{"cmpl",	one(0130700),	one(0170700), "*lAd", m68000up | mcf },
{"cmpl",	one(0006200),	one(0177700), "#l@s", m68000up },
{"cmpl",	one(0006200),	one(0177700), "#lDs", mcf },
{"cmpl",	one(0130610),	one(0170770), "+s+d", m68000up },
{"cmpl",	one(0130200),	one(0170700), "*lDd", m68000up | mcf },

{"dbcc",	one(0052310),	one(0177770), "DsBw", m68000up },
{"dbcs",	one(0052710),	one(0177770), "DsBw", m68000up },
{"dbeq",	one(0053710),	one(0177770), "DsBw", m68000up },
{"dbf",		one(0050710),	one(0177770), "DsBw", m68000up },
{"dbge",	one(0056310),	one(0177770), "DsBw", m68000up },
{"dbgt",	one(0057310),	one(0177770), "DsBw", m68000up },
{"dbhi",	one(0051310),	one(0177770), "DsBw", m68000up },
{"dble",	one(0057710),	one(0177770), "DsBw", m68000up },
{"dbls",	one(0051710),	one(0177770), "DsBw", m68000up },
{"dblt",	one(0056710),	one(0177770), "DsBw", m68000up },
{"dbmi",	one(0055710),	one(0177770), "DsBw", m68000up },
{"dbne",	one(0053310),	one(0177770), "DsBw", m68000up },
{"dbpl",	one(0055310),	one(0177770), "DsBw", m68000up },
{"dbt",		one(0050310),	one(0177770), "DsBw", m68000up },
{"dbvc",	one(0054310),	one(0177770), "DsBw", m68000up },
{"dbvs",	one(0054710),	one(0177770), "DsBw", m68000up },

{"divsw",	one(0100700),	one(0170700), ";wDd", m68000up | mcf5307up | mcf5206e },

{"divsl", two(0046100,0006000),two(0177700,0107770),";lD3D1", m68020up|cpu32 },
{"divsl", two(0046100,0004000),two(0177700,0107770),";lDD",   m68020up|cpu32 },
{"divsl", two(0046100,0004000),two(0177700,0107770),"qsDD",   mcf5307up | mcf5206e },

{"divsll", two(0046100,0004000),two(0177700,0107770),";lD3D1",m68020up|cpu32 },
{"divsll", two(0046100,0004000),two(0177700,0107770),";lDD",  m68020up|cpu32 },

{"divuw",	one(0100300),		one(0170700), ";wDd", m68000up | mcf5307up | mcf5206e },

{"divul", two(0046100,0002000),two(0177700,0107770),";lD3D1", m68020up|cpu32 },
{"divul", two(0046100,0000000),two(0177700,0107770),";lDD",   m68020up|cpu32 },
{"divul", two(0046100,0000000),two(0177700,0107770),"qsDD",   mcf5307up | mcf5206e },

{"divull", two(0046100,0000000),two(0177700,0107770),";lD3D1",m68020up|cpu32 },
{"divull", two(0046100,0000000),two(0177700,0107770),";lDD",  m68020up|cpu32 },

{"eorib",	one(0005000),	one(0177700), "#b$s", m68000up },
{"eorib",	one(0005074),	one(0177777), "#bCs", m68000up },
{"eoriw",	one(0005100),	one(0177700), "#w$s", m68000up },
{"eoriw",	one(0005174),	one(0177777), "#wSs", m68000up },
{"eoril",	one(0005200),	one(0177700), "#l$s", m68000up },
{"eoril",	one(0005200),	one(0177700), "#lDs", mcf },
{"eori",	one(0005074),	one(0177777), "#bCs", m68000up },
{"eori",	one(0005174),	one(0177777), "#wSs", m68000up },
{"eori",	one(0005100),	one(0177700), "#w$s", m68000up },

/* The eor opcode can generate the eori instruction.  */
{"eorb",	one(0005000),	one(0177700), "#b$s", m68000up },
{"eorb",	one(0005074),	one(0177777), "#bCs", m68000up },
{"eorb",	one(0130400),	one(0170700), "Dd$s", m68000up },
{"eorw",	one(0005100),	one(0177700), "#w$s", m68000up },
{"eorw",	one(0005174),	one(0177777), "#wSs", m68000up },
{"eorw",	one(0130500),	one(0170700), "Dd$s", m68000up },
{"eorl",	one(0005200),	one(0177700), "#l$s", m68000up },
{"eorl",	one(0005200),	one(0177700), "#lDs", mcf },
{"eorl",	one(0130600),	one(0170700), "Dd$s", m68000up | mcf },
{"eor",		one(0005074),	one(0177777), "#bCs", m68000up },
{"eor",		one(0005174),	one(0177777), "#wSs", m68000up },
{"eor",		one(0005100),	one(0177700), "#w$s", m68000up },
{"eor",		one(0130500),	one(0170700), "Dd$s", m68000up },

{"exg",		one(0140500),	one(0170770), "DdDs", m68000up },
{"exg",		one(0140510),	one(0170770), "AdAs", m68000up },
{"exg",		one(0140610),	one(0170770), "DdAs", m68000up },
{"exg",		one(0140610),	one(0170770), "AsDd", m68000up },

{"extw",	one(0044200),	one(0177770), "Ds", m68000up|mcf },
{"extl",	one(0044300),	one(0177770), "Ds", m68000up|mcf },
{"extbl",	one(0044700),	one(0177770), "Ds", m68020up|cpu32|mcf },

/* float stuff starts here */

{"fabsb",	two(0xF000, 0x5818), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fabsd",	two(0xF000, 0x5418), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fabsl",	two(0xF000, 0x4018), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fabsp",	two(0xF000, 0x4C18), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fabss",	two(0xF000, 0x4418), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fabsw",	two(0xF000, 0x5018), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fabsx",	two(0xF000, 0x0018), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fabsx",	two(0xF000, 0x4818), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fabsx",	two(0xF000, 0x0018), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsabsb",	two(0xF000, 0x5858), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsabsd",	two(0xF000, 0x5458), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsabsl",	two(0xF000, 0x4058), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsabsp",	two(0xF000, 0x4C58), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsabss",	two(0xF000, 0x4458), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsabsw",	two(0xF000, 0x5058), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsabsx",	two(0xF000, 0x0058), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsabsx",	two(0xF000, 0x4858), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsabsx",	two(0xF000, 0x0058), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdabsb",	two(0xF000, 0x585c), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up},
{"fdabsd",	two(0xF000, 0x545c), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up},
{"fdabsl",	two(0xF000, 0x405c), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up},
{"fdabsp",	two(0xF000, 0x4C5c), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up},
{"fdabss",	two(0xF000, 0x445c), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up},
{"fdabsw",	two(0xF000, 0x505c), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up},
{"fdabsx",	two(0xF000, 0x005c), two(0xF1C0, 0xE07F), "IiF8F7", m68040up},
{"fdabsx",	two(0xF000, 0x485c), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up},
{"fdabsx",	two(0xF000, 0x005c), two(0xF1C0, 0xE07F), "IiFt",   m68040up},

{"facosb",	two(0xF000, 0x581C), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"facosd",	two(0xF000, 0x541C), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"facosl",	two(0xF000, 0x401C), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"facosp",	two(0xF000, 0x4C1C), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"facoss",	two(0xF000, 0x441C), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"facosw",	two(0xF000, 0x501C), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"facosx",	two(0xF000, 0x001C), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"facosx",	two(0xF000, 0x481C), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"facosx",	two(0xF000, 0x001C), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"faddb",	two(0xF000, 0x5822), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"faddd",	two(0xF000, 0x5422), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"faddl",	two(0xF000, 0x4022), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"faddp",	two(0xF000, 0x4C22), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fadds",	two(0xF000, 0x4422), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"faddw",	two(0xF000, 0x5022), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"faddx",	two(0xF000, 0x0022), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"faddx",	two(0xF000, 0x4822), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsaddb",	two(0xF000, 0x5862), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsaddd",	two(0xF000, 0x5462), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsaddl",	two(0xF000, 0x4062), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsaddp",	two(0xF000, 0x4C62), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsadds",	two(0xF000, 0x4462), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsaddw",	two(0xF000, 0x5062), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsaddx",	two(0xF000, 0x0062), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsaddx",	two(0xF000, 0x4862), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fdaddb",	two(0xF000, 0x5866), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdaddd",	two(0xF000, 0x5466), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdaddl",	two(0xF000, 0x4066), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdaddp",	two(0xF000, 0x4C66), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdadds",	two(0xF000, 0x4466), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdaddw",	two(0xF000, 0x5066), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdaddx",	two(0xF000, 0x0066), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdaddx",	two(0xF000, 0x4866), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fasinb",	two(0xF000, 0x580C), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fasind",	two(0xF000, 0x540C), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fasinl",	two(0xF000, 0x400C), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fasinp",	two(0xF000, 0x4C0C), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fasins",	two(0xF000, 0x440C), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fasinw",	two(0xF000, 0x500C), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fasinx",	two(0xF000, 0x000C), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fasinx",	two(0xF000, 0x480C), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fasinx",	two(0xF000, 0x000C), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fatanb",	two(0xF000, 0x580A), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fatand",	two(0xF000, 0x540A), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fatanl",	two(0xF000, 0x400A), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fatanp",	two(0xF000, 0x4C0A), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fatans",	two(0xF000, 0x440A), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fatanw",	two(0xF000, 0x500A), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fatanx",	two(0xF000, 0x000A), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fatanx",	two(0xF000, 0x480A), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fatanx",	two(0xF000, 0x000A), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fatanhb",	two(0xF000, 0x580D), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fatanhd",	two(0xF000, 0x540D), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fatanhl",	two(0xF000, 0x400D), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fatanhp",	two(0xF000, 0x4C0D), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fatanhs",	two(0xF000, 0x440D), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fatanhw",	two(0xF000, 0x500D), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fatanhx",	two(0xF000, 0x000D), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fatanhx",	two(0xF000, 0x480D), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fatanhx",	two(0xF000, 0x000D), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fbeq",	one(0xF081),		one(0xF1FF), "IdBW", mfloat },
{"fbf",		one(0xF080),		one(0xF1FF), "IdBW", mfloat },
{"fbge",	one(0xF093),		one(0xF1FF), "IdBW", mfloat },
{"fbgl",	one(0xF096),		one(0xF1FF), "IdBW", mfloat },
{"fbgle",	one(0xF097),		one(0xF1FF), "IdBW", mfloat },
{"fbgt",	one(0xF092),		one(0xF1FF), "IdBW", mfloat },
{"fble",	one(0xF095),		one(0xF1FF), "IdBW", mfloat },
{"fblt",	one(0xF094),		one(0xF1FF), "IdBW", mfloat },
{"fbne",	one(0xF08E),		one(0xF1FF), "IdBW", mfloat },
{"fbnge",	one(0xF09C),		one(0xF1FF), "IdBW", mfloat },
{"fbngl",	one(0xF099),		one(0xF1FF), "IdBW", mfloat },
{"fbngle",	one(0xF098),		one(0xF1FF), "IdBW", mfloat },
{"fbngt",	one(0xF09D),		one(0xF1FF), "IdBW", mfloat },
{"fbnle",	one(0xF09A),		one(0xF1FF), "IdBW", mfloat },
{"fbnlt",	one(0xF09B),		one(0xF1FF), "IdBW", mfloat },
{"fboge",	one(0xF083),		one(0xF1FF), "IdBW", mfloat },
{"fbogl",	one(0xF086),		one(0xF1FF), "IdBW", mfloat },
{"fbogt",	one(0xF082),		one(0xF1FF), "IdBW", mfloat },
{"fbole",	one(0xF085),		one(0xF1FF), "IdBW", mfloat },
{"fbolt",	one(0xF084),		one(0xF1FF), "IdBW", mfloat },
{"fbor",	one(0xF087),		one(0xF1FF), "IdBW", mfloat },
{"fbseq",	one(0xF091),		one(0xF1FF), "IdBW", mfloat },
{"fbsf",	one(0xF090),		one(0xF1FF), "IdBW", mfloat },
{"fbsne",	one(0xF09E),		one(0xF1FF), "IdBW", mfloat },
{"fbst",	one(0xF09F),		one(0xF1FF), "IdBW", mfloat },
{"fbt",		one(0xF08F),		one(0xF1FF), "IdBW", mfloat },
{"fbueq",	one(0xF089),		one(0xF1FF), "IdBW", mfloat },
{"fbuge",	one(0xF08B),		one(0xF1FF), "IdBW", mfloat },
{"fbugt",	one(0xF08A),		one(0xF1FF), "IdBW", mfloat },
{"fbule",	one(0xF08D),		one(0xF1FF), "IdBW", mfloat },
{"fbult",	one(0xF08C),		one(0xF1FF), "IdBW", mfloat },
{"fbun",	one(0xF088),		one(0xF1FF), "IdBW", mfloat },

{"fbeql",	one(0xF0C1),		one(0xF1FF), "IdBC", mfloat },
{"fbfl",	one(0xF0C0),		one(0xF1FF), "IdBC", mfloat },
{"fbgel",	one(0xF0D3),		one(0xF1FF), "IdBC", mfloat },
{"fbgll",	one(0xF0D6),		one(0xF1FF), "IdBC", mfloat },
{"fbglel",	one(0xF0D7),		one(0xF1FF), "IdBC", mfloat },
{"fbgtl",	one(0xF0D2),		one(0xF1FF), "IdBC", mfloat },
{"fblel",	one(0xF0D5),		one(0xF1FF), "IdBC", mfloat },
{"fbltl",	one(0xF0D4),		one(0xF1FF), "IdBC", mfloat },
{"fbnel",	one(0xF0CE),		one(0xF1FF), "IdBC", mfloat },
{"fbngel",	one(0xF0DC),		one(0xF1FF), "IdBC", mfloat },
{"fbngll",	one(0xF0D9),		one(0xF1FF), "IdBC", mfloat },
{"fbnglel",	one(0xF0D8),		one(0xF1FF), "IdBC", mfloat },
{"fbngtl",	one(0xF0DD),		one(0xF1FF), "IdBC", mfloat },
{"fbnlel",	one(0xF0DA),		one(0xF1FF), "IdBC", mfloat },
{"fbnltl",	one(0xF0DB),		one(0xF1FF), "IdBC", mfloat },
{"fbogel",	one(0xF0C3),		one(0xF1FF), "IdBC", mfloat },
{"fbogll",	one(0xF0C6),		one(0xF1FF), "IdBC", mfloat },
{"fbogtl",	one(0xF0C2),		one(0xF1FF), "IdBC", mfloat },
{"fbolel",	one(0xF0C5),		one(0xF1FF), "IdBC", mfloat },
{"fboltl",	one(0xF0C4),		one(0xF1FF), "IdBC", mfloat },
{"fborl",	one(0xF0C7),		one(0xF1FF), "IdBC", mfloat },
{"fbseql",	one(0xF0D1),		one(0xF1FF), "IdBC", mfloat },
{"fbsfl",	one(0xF0D0),		one(0xF1FF), "IdBC", mfloat },
{"fbsnel",	one(0xF0DE),		one(0xF1FF), "IdBC", mfloat },
{"fbstl",	one(0xF0DF),		one(0xF1FF), "IdBC", mfloat },
{"fbtl",	one(0xF0CF),		one(0xF1FF), "IdBC", mfloat },
{"fbueql",	one(0xF0C9),		one(0xF1FF), "IdBC", mfloat },
{"fbugel",	one(0xF0CB),		one(0xF1FF), "IdBC", mfloat },
{"fbugtl",	one(0xF0CA),		one(0xF1FF), "IdBC", mfloat },
{"fbulel",	one(0xF0CD),		one(0xF1FF), "IdBC", mfloat },
{"fbultl",	one(0xF0CC),		one(0xF1FF), "IdBC", mfloat },
{"fbunl",	one(0xF0C8),		one(0xF1FF), "IdBC", mfloat },

{"fjeq",	one(0xF081),		one(0xF1BF), "IdBc", mfloat },
{"fjf",		one(0xF080),		one(0xF1BF), "IdBc", mfloat },
{"fjge",	one(0xF093),		one(0xF1BF), "IdBc", mfloat },
{"fjgl",	one(0xF096),		one(0xF1BF), "IdBc", mfloat },
{"fjgle",	one(0xF097),		one(0xF1BF), "IdBc", mfloat },
{"fjgt",	one(0xF092),		one(0xF1BF), "IdBc", mfloat },
{"fjle",	one(0xF095),		one(0xF1BF), "IdBc", mfloat },
{"fjlt",	one(0xF094),		one(0xF1BF), "IdBc", mfloat },
{"fjne",	one(0xF08E),		one(0xF1BF), "IdBc", mfloat },
{"fjnge",	one(0xF09C),		one(0xF1BF), "IdBc", mfloat },
{"fjngl",	one(0xF099),		one(0xF1BF), "IdBc", mfloat },
{"fjngle",	one(0xF098),		one(0xF1BF), "IdBc", mfloat },
{"fjngt",	one(0xF09D),		one(0xF1BF), "IdBc", mfloat },
{"fjnle",	one(0xF09A),		one(0xF1BF), "IdBc", mfloat },
{"fjnlt",	one(0xF09B),		one(0xF1BF), "IdBc", mfloat },
{"fjoge",	one(0xF083),		one(0xF1BF), "IdBc", mfloat },
{"fjogl",	one(0xF086),		one(0xF1BF), "IdBc", mfloat },
{"fjogt",	one(0xF082),		one(0xF1BF), "IdBc", mfloat },
{"fjole",	one(0xF085),		one(0xF1BF), "IdBc", mfloat },
{"fjolt",	one(0xF084),		one(0xF1BF), "IdBc", mfloat },
{"fjor",	one(0xF087),		one(0xF1BF), "IdBc", mfloat },
{"fjseq",	one(0xF091),		one(0xF1BF), "IdBc", mfloat },
{"fjsf",	one(0xF090),		one(0xF1BF), "IdBc", mfloat },
{"fjsne",	one(0xF09E),		one(0xF1BF), "IdBc", mfloat },
{"fjst",	one(0xF09F),		one(0xF1BF), "IdBc", mfloat },
{"fjt",		one(0xF08F),		one(0xF1BF), "IdBc", mfloat },
{"fjueq",	one(0xF089),		one(0xF1BF), "IdBc", mfloat },
{"fjuge",	one(0xF08B),		one(0xF1BF), "IdBc", mfloat },
{"fjugt",	one(0xF08A),		one(0xF1BF), "IdBc", mfloat },
{"fjule",	one(0xF08D),		one(0xF1BF), "IdBc", mfloat },
{"fjult",	one(0xF08C),		one(0xF1BF), "IdBc", mfloat },
{"fjun",	one(0xF088),		one(0xF1BF), "IdBc", mfloat },

{"fcmpb",	two(0xF000, 0x5838), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcmpd",	two(0xF000, 0x5438), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcmpl",	two(0xF000, 0x4038), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcmpp",	two(0xF000, 0x4C38), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcmps",	two(0xF000, 0x4438), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcmpw",	two(0xF000, 0x5038), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcmpx",	two(0xF000, 0x0038), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcmpx",	two(0xF000, 0x4838), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fcosb",	two(0xF000, 0x581D), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcosd",	two(0xF000, 0x541D), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcosl",	two(0xF000, 0x401D), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcosp",	two(0xF000, 0x4C1D), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcoss",	two(0xF000, 0x441D), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcosw",	two(0xF000, 0x501D), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcosx",	two(0xF000, 0x001D), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcosx",	two(0xF000, 0x481D), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fcosx",	two(0xF000, 0x001D), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fcoshb",	two(0xF000, 0x5819), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fcoshd",	two(0xF000, 0x5419), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fcoshl",	two(0xF000, 0x4019), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fcoshp",	two(0xF000, 0x4C19), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fcoshs",	two(0xF000, 0x4419), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fcoshw",	two(0xF000, 0x5019), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fcoshx",	two(0xF000, 0x0019), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fcoshx",	two(0xF000, 0x4819), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fcoshx",	two(0xF000, 0x0019), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fdbeq",	two(0xF048, 0x0001), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbf",	two(0xF048, 0x0000), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbge",	two(0xF048, 0x0013), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgl",	two(0xF048, 0x0016), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgle",	two(0xF048, 0x0017), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbgt",	two(0xF048, 0x0012), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdble",	two(0xF048, 0x0015), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdblt",	two(0xF048, 0x0014), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbne",	two(0xF048, 0x000E), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnge",	two(0xF048, 0x001C), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngl",	two(0xF048, 0x0019), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngle",	two(0xF048, 0x0018), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbngt",	two(0xF048, 0x001D), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnle",	two(0xF048, 0x001A), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbnlt",	two(0xF048, 0x001B), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdboge",	two(0xF048, 0x0003), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbogl",	two(0xF048, 0x0006), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbogt",	two(0xF048, 0x0002), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbole",	two(0xF048, 0x0005), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbolt",	two(0xF048, 0x0004), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbor",	two(0xF048, 0x0007), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbseq",	two(0xF048, 0x0011), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbsf",	two(0xF048, 0x0010), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbsne",	two(0xF048, 0x001E), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbst",	two(0xF048, 0x001F), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbt",	two(0xF048, 0x000F), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbueq",	two(0xF048, 0x0009), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbuge",	two(0xF048, 0x000B), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbugt",	two(0xF048, 0x000A), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbule",	two(0xF048, 0x000D), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbult",	two(0xF048, 0x000C), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },
{"fdbun",	two(0xF048, 0x0008), two(0xF1F8, 0xFFFF), "IiDsBw", mfloat },

{"fdivb",	two(0xF000, 0x5820), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fdivd",	two(0xF000, 0x5420), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fdivl",	two(0xF000, 0x4020), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fdivp",	two(0xF000, 0x4C20), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fdivs",	two(0xF000, 0x4420), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fdivw",	two(0xF000, 0x5020), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fdivx",	two(0xF000, 0x0020), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fdivx",	two(0xF000, 0x4820), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsdivb",	two(0xF000, 0x5860), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsdivd",	two(0xF000, 0x5460), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsdivl",	two(0xF000, 0x4060), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsdivp",	two(0xF000, 0x4C60), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsdivs",	two(0xF000, 0x4460), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsdivw",	two(0xF000, 0x5060), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsdivx",	two(0xF000, 0x0060), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsdivx",	two(0xF000, 0x4860), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fddivb",	two(0xF000, 0x5864), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fddivd",	two(0xF000, 0x5464), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fddivl",	two(0xF000, 0x4064), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fddivp",	two(0xF000, 0x4C64), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fddivs",	two(0xF000, 0x4464), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fddivw",	two(0xF000, 0x5064), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fddivx",	two(0xF000, 0x0064), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fddivx",	two(0xF000, 0x4864), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fetoxb",	two(0xF000, 0x5810), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fetoxd",	two(0xF000, 0x5410), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fetoxl",	two(0xF000, 0x4010), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fetoxp",	two(0xF000, 0x4C10), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fetoxs",	two(0xF000, 0x4410), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fetoxw",	two(0xF000, 0x5010), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fetoxx",	two(0xF000, 0x0010), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fetoxx",	two(0xF000, 0x4810), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fetoxx",	two(0xF000, 0x0010), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fetoxm1b",	two(0xF000, 0x5808), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fetoxm1d",	two(0xF000, 0x5408), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fetoxm1l",	two(0xF000, 0x4008), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fetoxm1p",	two(0xF000, 0x4C08), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fetoxm1s",	two(0xF000, 0x4408), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fetoxm1w",	two(0xF000, 0x5008), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fetoxm1x",	two(0xF000, 0x0008), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fetoxm1x",	two(0xF000, 0x4808), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fetoxm1x",	two(0xF000, 0x0008), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fgetexpb",	two(0xF000, 0x581E), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fgetexpd",	two(0xF000, 0x541E), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fgetexpl",	two(0xF000, 0x401E), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fgetexpp",	two(0xF000, 0x4C1E), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fgetexps",	two(0xF000, 0x441E), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fgetexpw",	two(0xF000, 0x501E), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fgetexpx",	two(0xF000, 0x001E), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fgetexpx",	two(0xF000, 0x481E), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fgetexpx",	two(0xF000, 0x001E), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fgetmanb",	two(0xF000, 0x581F), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fgetmand",	two(0xF000, 0x541F), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fgetmanl",	two(0xF000, 0x401F), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fgetmanp",	two(0xF000, 0x4C1F), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fgetmans",	two(0xF000, 0x441F), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fgetmanw",	two(0xF000, 0x501F), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fgetmanx",	two(0xF000, 0x001F), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fgetmanx",	two(0xF000, 0x481F), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fgetmanx",	two(0xF000, 0x001F), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fintb",	two(0xF000, 0x5801), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fintd",	two(0xF000, 0x5401), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fintl",	two(0xF000, 0x4001), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fintp",	two(0xF000, 0x4C01), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fints",	two(0xF000, 0x4401), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fintw",	two(0xF000, 0x5001), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fintx",	two(0xF000, 0x0001), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fintx",	two(0xF000, 0x4801), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fintx",	two(0xF000, 0x0001), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fintrzb",	two(0xF000, 0x5803), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fintrzd",	two(0xF000, 0x5403), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fintrzl",	two(0xF000, 0x4003), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fintrzp",	two(0xF000, 0x4C03), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fintrzs",	two(0xF000, 0x4403), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fintrzw",	two(0xF000, 0x5003), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fintrzx",	two(0xF000, 0x0003), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fintrzx",	two(0xF000, 0x4803), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fintrzx",	two(0xF000, 0x0003), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flog10b",	two(0xF000, 0x5815), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flog10d",	two(0xF000, 0x5415), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flog10l",	two(0xF000, 0x4015), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flog10p",	two(0xF000, 0x4C15), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flog10s",	two(0xF000, 0x4415), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flog10w",	two(0xF000, 0x5015), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flog10x",	two(0xF000, 0x0015), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flog10x",	two(0xF000, 0x4815), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flog10x",	two(0xF000, 0x0015), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flog2b",	two(0xF000, 0x5816), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flog2d",	two(0xF000, 0x5416), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flog2l",	two(0xF000, 0x4016), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flog2p",	two(0xF000, 0x4C16), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flog2s",	two(0xF000, 0x4416), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flog2w",	two(0xF000, 0x5016), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flog2x",	two(0xF000, 0x0016), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flog2x",	two(0xF000, 0x4816), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flog2x",	two(0xF000, 0x0016), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flognb",	two(0xF000, 0x5814), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flognd",	two(0xF000, 0x5414), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flognl",	two(0xF000, 0x4014), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flognp",	two(0xF000, 0x4C14), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flogns",	two(0xF000, 0x4414), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flognw",	two(0xF000, 0x5014), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flognx",	two(0xF000, 0x0014), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flognx",	two(0xF000, 0x4814), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flognx",	two(0xF000, 0x0014), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"flognp1b",	two(0xF000, 0x5806), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"flognp1d",	two(0xF000, 0x5406), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"flognp1l",	two(0xF000, 0x4006), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"flognp1p",	two(0xF000, 0x4C06), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"flognp1s",	two(0xF000, 0x4406), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"flognp1w",	two(0xF000, 0x5006), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"flognp1x",	two(0xF000, 0x0006), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"flognp1x",	two(0xF000, 0x4806), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"flognp1x",	two(0xF000, 0x0006), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fmodb",	two(0xF000, 0x5821), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmodd",	two(0xF000, 0x5421), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmodl",	two(0xF000, 0x4021), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmodp",	two(0xF000, 0x4C21), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmods",	two(0xF000, 0x4421), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmodw",	two(0xF000, 0x5021), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmodx",	two(0xF000, 0x0021), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fmodx",	two(0xF000, 0x4821), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fmoveb",	two(0xF000, 0x5800), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmoveb",	two(0xF000, 0x7800), two(0xF1C0, 0xFC7F), "IiF7$b", mfloat },
{"fmoved",	two(0xF000, 0x5400), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmoved",	two(0xF000, 0x7400), two(0xF1C0, 0xFC7F), "IiF7~F", mfloat },
{"fmovel",	two(0xF000, 0x4000), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmovel",	two(0xF000, 0x6000), two(0xF1C0, 0xFC7F), "IiF7$l", mfloat },
/* FIXME: the next two variants should not permit moving an address
   register to anything but the floating point instruction register.  */
{"fmovel",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmovel",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*ls8", mfloat },
{"fmovep",	two(0xF000, 0x4C00), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmovep",	two(0xF000, 0x6C00), two(0xF1C0, 0xFC00), "IiF7~pkC", mfloat },
{"fmovep",	two(0xF000, 0x7C00), two(0xF1C0, 0xFC0F), "IiF7~pDk", mfloat },
{"fmoves",	two(0xF000, 0x4400), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmoves",	two(0xF000, 0x6400), two(0xF1C0, 0xFC7F), "IiF7$f", mfloat },
{"fmovew",	two(0xF000, 0x5000), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmovew",	two(0xF000, 0x7000), two(0xF1C0, 0xFC7F), "IiF7$w", mfloat },
{"fmovex",	two(0xF000, 0x0000), two(0xF1FF, 0xE07F), "IiF8F7", mfloat },
{"fmovex",	two(0xF000, 0x4800), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fmovex",	two(0xF000, 0x6800), two(0xF1C0, 0xFC7F), "IiF7~x", mfloat },

{"fsmoveb",	two(0xF000, 0x5840), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsmoved",	two(0xF000, 0x5440), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsmovel",	two(0xF000, 0x4040), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsmoves",	two(0xF000, 0x4440), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsmovew",	two(0xF000, 0x5040), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsmovex",	two(0xF000, 0x0040), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsmovex",	two(0xF000, 0x4840), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsmovep",	two(0xF000, 0x4C40), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },

{"fdmoveb",	two(0xF000, 0x5844), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdmoved",	two(0xF000, 0x5444), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdmovel",	two(0xF000, 0x4044), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdmoves",	two(0xF000, 0x4444), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdmovew",	two(0xF000, 0x5044), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdmovex",	two(0xF000, 0x0044), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdmovex",	two(0xF000, 0x4844), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdmovep",	two(0xF000, 0x4C44), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },

{"fmovecrx",	two(0xF000, 0x5C00), two(0xF1FF, 0xFC00), "Ii#CF7", mfloat },

{"fmovemx",	two(0xF000, 0xF800), two(0xF1C0, 0xFF8F), "IiDk&s", mfloat },
{"fmovemx",	two(0xF020, 0xE800), two(0xF1F8, 0xFF8F), "IiDk-s", mfloat },
{"fmovemx",	two(0xF000, 0xD800), two(0xF1C0, 0xFF8F), "Ii&sDk", mfloat },
{"fmovemx",	two(0xF018, 0xD800), two(0xF1F8, 0xFF8F), "Ii+sDk", mfloat },
{"fmovemx",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Idl3&s", mfloat },
{"fmovemx",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Id#3&s", mfloat },
{"fmovemx",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&sl3", mfloat },
{"fmovemx",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&s#3", mfloat },
{"fmovemx",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "IdL3-s", mfloat },
{"fmovemx",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "Id#3-s", mfloat },
{"fmovemx",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+sl3", mfloat },
{"fmovemx",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+s#3", mfloat },

{"fmoveml",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmoveml",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "IiL8~s", mfloat },
/* FIXME: In the next instruction, we should only permit %dn if the
   target is a single register.  We should only permit %an if the
   target is a single %fpiar.  */
{"fmoveml",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*lL8", mfloat },

{"fmovem",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "IdL3-s", mfloat },
{"fmovem",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Idl3&s", mfloat },
{"fmovem",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+sl3", mfloat },
{"fmovem",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&sl3", mfloat },
{"fmovem",	two(0xF020, 0xE000), two(0xF1F8, 0xFF00), "Id#3-s", mfloat },
{"fmovem",	two(0xF020, 0xE800), two(0xF1F8, 0xFF8F), "IiDk-s", mfloat },
{"fmovem",	two(0xF000, 0xF000), two(0xF1C0, 0xFF00), "Id#3&s", mfloat },
{"fmovem",	two(0xF000, 0xF800), two(0xF1C0, 0xFF8F), "IiDk&s", mfloat },
{"fmovem",	two(0xF018, 0xD000), two(0xF1F8, 0xFF00), "Id+s#3", mfloat },
{"fmovem",	two(0xF018, 0xD800), two(0xF1F8, 0xFF8F), "Ii+sDk", mfloat },
{"fmovem",	two(0xF000, 0xD000), two(0xF1C0, 0xFF00), "Id&s#3", mfloat },
{"fmovem",	two(0xF000, 0xD800), two(0xF1C0, 0xFF8F), "Ii&sDk", mfloat },
{"fmovem",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "Iis8%s", mfloat },
{"fmovem",	two(0xF000, 0x8000), two(0xF1C0, 0xE3FF), "Ii*ss8", mfloat },
{"fmovem",	two(0xF000, 0xA000), two(0xF1C0, 0xE3FF), "IiL8~s", mfloat },
{"fmovem",	two(0xF000, 0x8000), two(0xF2C0, 0xE3FF), "Ii*sL8", mfloat },

{"fmulb",	two(0xF000, 0x5823), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fmuld",	two(0xF000, 0x5423), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fmull",	two(0xF000, 0x4023), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fmulp",	two(0xF000, 0x4C23), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fmuls",	two(0xF000, 0x4423), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fmulw",	two(0xF000, 0x5023), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fmulx",	two(0xF000, 0x0023), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fmulx",	two(0xF000, 0x4823), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"fsmulb",	two(0xF000, 0x5863), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsmuld",	two(0xF000, 0x5463), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsmull",	two(0xF000, 0x4063), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsmulp",	two(0xF000, 0x4C63), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsmuls",	two(0xF000, 0x4463), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsmulw",	two(0xF000, 0x5063), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsmulx",	two(0xF000, 0x0063), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsmulx",	two(0xF000, 0x4863), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fdmulb",	two(0xF000, 0x5867), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdmuld",	two(0xF000, 0x5467), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdmull",	two(0xF000, 0x4067), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdmulp",	two(0xF000, 0x4C67), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdmuls",	two(0xF000, 0x4467), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdmulw",	two(0xF000, 0x5067), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdmulx",	two(0xF000, 0x0067), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdmulx",	two(0xF000, 0x4867), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },

{"fnegb",	two(0xF000, 0x581A), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fnegd",	two(0xF000, 0x541A), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fnegl",	two(0xF000, 0x401A), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fnegp",	two(0xF000, 0x4C1A), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fnegs",	two(0xF000, 0x441A), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fnegw",	two(0xF000, 0x501A), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fnegx",	two(0xF000, 0x001A), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fnegx",	two(0xF000, 0x481A), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fnegx",	two(0xF000, 0x001A), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsnegb",	two(0xF000, 0x585A), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fsnegd",	two(0xF000, 0x545A), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fsnegl",	two(0xF000, 0x405A), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fsnegp",	two(0xF000, 0x4C5A), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fsnegs",	two(0xF000, 0x445A), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fsnegw",	two(0xF000, 0x505A), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fsnegx",	two(0xF000, 0x005A), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fsnegx",	two(0xF000, 0x485A), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fsnegx",	two(0xF000, 0x005A), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdnegb",	two(0xF000, 0x585E), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdnegd",	two(0xF000, 0x545E), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdnegl",	two(0xF000, 0x405E), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdnegp",	two(0xF000, 0x4C5E), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdnegs",	two(0xF000, 0x445E), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdnegw",	two(0xF000, 0x505E), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdnegx",	two(0xF000, 0x005E), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdnegx",	two(0xF000, 0x485E), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdnegx",	two(0xF000, 0x005E), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fnop",	two(0xF280, 0x0000), two(0xFFFF, 0xFFFF), "Ii", mfloat },

{"fremb",	two(0xF000, 0x5825), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fremd",	two(0xF000, 0x5425), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"freml",	two(0xF000, 0x4025), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fremp",	two(0xF000, 0x4C25), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"frems",	two(0xF000, 0x4425), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fremw",	two(0xF000, 0x5025), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fremx",	two(0xF000, 0x0025), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fremx",	two(0xF000, 0x4825), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

{"frestore",	one(0xF140),		one(0xF1C0), "Id<s", mfloat },

{"fsave",	one(0xF100),		one(0xF1C0), "Id>s", mfloat },

{"fscaleb",	two(0xF000, 0x5826), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fscaled",	two(0xF000, 0x5426), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fscalel",	two(0xF000, 0x4026), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fscalep",	two(0xF000, 0x4C26), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fscales",	two(0xF000, 0x4426), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fscalew",	two(0xF000, 0x5026), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fscalex",	two(0xF000, 0x0026), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fscalex",	two(0xF000, 0x4826), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },

/* $ is necessary to prevent the assembler from using PC-relative.
   If @ were used, "label: fseq label" could produce "ftrapeq",
   because "label" became "pc@label".  */
{"fseq",	two(0xF040, 0x0001), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsf",		two(0xF040, 0x0000), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsge",	two(0xF040, 0x0013), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgl",	two(0xF040, 0x0016), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgle",	two(0xF040, 0x0017), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsgt",	two(0xF040, 0x0012), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsle",	two(0xF040, 0x0015), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fslt",	two(0xF040, 0x0014), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsne",	two(0xF040, 0x000E), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnge",	two(0xF040, 0x001C), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngl",	two(0xF040, 0x0019), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngle",	two(0xF040, 0x0018), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsngt",	two(0xF040, 0x001D), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnle",	two(0xF040, 0x001A), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsnlt",	two(0xF040, 0x001B), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsoge",	two(0xF040, 0x0003), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsogl",	two(0xF040, 0x0006), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsogt",	two(0xF040, 0x0002), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsole",	two(0xF040, 0x0005), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsolt",	two(0xF040, 0x0004), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsor",	two(0xF040, 0x0007), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsseq",	two(0xF040, 0x0011), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fssf",	two(0xF040, 0x0010), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fssne",	two(0xF040, 0x001E), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsst",	two(0xF040, 0x001F), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fst",		two(0xF040, 0x000F), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsueq",	two(0xF040, 0x0009), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsuge",	two(0xF040, 0x000B), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsugt",	two(0xF040, 0x000A), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsule",	two(0xF040, 0x000D), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsult",	two(0xF040, 0x000C), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },
{"fsun",	two(0xF040, 0x0008), two(0xF1C0, 0xFFFF), "Ii$s", mfloat },

{"fsgldivb",	two(0xF000, 0x5824), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsgldivd",	two(0xF000, 0x5424), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsgldivl",	two(0xF000, 0x4024), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsgldivp",	two(0xF000, 0x4C24), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsgldivs",	two(0xF000, 0x4424), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsgldivw",	two(0xF000, 0x5024), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsgldivx",	two(0xF000, 0x0024), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsgldivx",	two(0xF000, 0x4824), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsgldivx",	two(0xF000, 0x0024), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsglmulb",	two(0xF000, 0x5827), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsglmuld",	two(0xF000, 0x5427), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsglmull",	two(0xF000, 0x4027), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsglmulp",	two(0xF000, 0x4C27), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsglmuls",	two(0xF000, 0x4427), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsglmulw",	two(0xF000, 0x5027), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsglmulx",	two(0xF000, 0x0027), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsglmulx",	two(0xF000, 0x4827), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsglmulx",	two(0xF000, 0x0027), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsinb",	two(0xF000, 0x580E), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsind",	two(0xF000, 0x540E), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsinl",	two(0xF000, 0x400E), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsinp",	two(0xF000, 0x4C0E), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsins",	two(0xF000, 0x440E), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsinw",	two(0xF000, 0x500E), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsinx",	two(0xF000, 0x000E), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsinx",	two(0xF000, 0x480E), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsinx",	two(0xF000, 0x000E), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsincosb",	two(0xF000, 0x5830), two(0xF1C0, 0xFC78), "Ii;bF3F7", mfloat },
{"fsincosd",	two(0xF000, 0x5430), two(0xF1C0, 0xFC78), "Ii;FF3F7", mfloat },
{"fsincosl",	two(0xF000, 0x4030), two(0xF1C0, 0xFC78), "Ii;lF3F7", mfloat },
{"fsincosp",	two(0xF000, 0x4C30), two(0xF1C0, 0xFC78), "Ii;pF3F7", mfloat },
{"fsincoss",	two(0xF000, 0x4430), two(0xF1C0, 0xFC78), "Ii;fF3F7", mfloat },
{"fsincosw",	two(0xF000, 0x5030), two(0xF1C0, 0xFC78), "Ii;wF3F7", mfloat },
{"fsincosx",	two(0xF000, 0x0030), two(0xF1C0, 0xE078), "IiF8F3F7", mfloat },
{"fsincosx",	two(0xF000, 0x4830), two(0xF1C0, 0xFC78), "Ii;xF3F7", mfloat },

{"fsinhb",	two(0xF000, 0x5802), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsinhd",	two(0xF000, 0x5402), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsinhl",	two(0xF000, 0x4002), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsinhp",	two(0xF000, 0x4C02), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsinhs",	two(0xF000, 0x4402), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsinhw",	two(0xF000, 0x5002), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsinhx",	two(0xF000, 0x0002), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsinhx",	two(0xF000, 0x4802), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsinhx",	two(0xF000, 0x0002), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fsqrtb",	two(0xF000, 0x5804), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsqrtd",	two(0xF000, 0x5404), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsqrtl",	two(0xF000, 0x4004), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsqrtp",	two(0xF000, 0x4C04), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsqrts",	two(0xF000, 0x4404), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsqrtw",	two(0xF000, 0x5004), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsqrtx",	two(0xF000, 0x0004), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsqrtx",	two(0xF000, 0x4804), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsqrtx",	two(0xF000, 0x0004), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fssqrtb",	two(0xF000, 0x5841), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fssqrtd",	two(0xF000, 0x5441), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fssqrtl",	two(0xF000, 0x4041), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fssqrtp",	two(0xF000, 0x4C41), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fssqrts",	two(0xF000, 0x4441), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fssqrtw",	two(0xF000, 0x5041), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fssqrtx",	two(0xF000, 0x0041), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fssqrtx",	two(0xF000, 0x4841), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fssqrtx",	two(0xF000, 0x0041), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdsqrtb",	two(0xF000, 0x5845), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdsqrtd",	two(0xF000, 0x5445), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdsqrtl",	two(0xF000, 0x4045), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdsqrtp",	two(0xF000, 0x4C45), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdsqrts",	two(0xF000, 0x4445), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdsqrtw",	two(0xF000, 0x5045), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdsqrtx",	two(0xF000, 0x0045), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdsqrtx",	two(0xF000, 0x4845), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdsqrtx",	two(0xF000, 0x0045), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fsubb",	two(0xF000, 0x5828), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"fsubd",	two(0xF000, 0x5428), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"fsubl",	two(0xF000, 0x4028), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"fsubp",	two(0xF000, 0x4C28), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"fsubs",	two(0xF000, 0x4428), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"fsubw",	two(0xF000, 0x5028), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"fsubx",	two(0xF000, 0x0028), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"fsubx",	two(0xF000, 0x4828), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"fsubx",	two(0xF000, 0x0028), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"fssubb",	two(0xF000, 0x5868), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fssubd",	two(0xF000, 0x5468), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fssubl",	two(0xF000, 0x4068), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fssubp",	two(0xF000, 0x4C68), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fssubs",	two(0xF000, 0x4468), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fssubw",	two(0xF000, 0x5068), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fssubx",	two(0xF000, 0x0068), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fssubx",	two(0xF000, 0x4868), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fssubx",	two(0xF000, 0x0068), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"fdsubb",	two(0xF000, 0x586c), two(0xF1C0, 0xFC7F), "Ii;bF7", m68040up },
{"fdsubd",	two(0xF000, 0x546c), two(0xF1C0, 0xFC7F), "Ii;FF7", m68040up },
{"fdsubl",	two(0xF000, 0x406c), two(0xF1C0, 0xFC7F), "Ii;lF7", m68040up },
{"fdsubp",	two(0xF000, 0x4C6c), two(0xF1C0, 0xFC7F), "Ii;pF7", m68040up },
{"fdsubs",	two(0xF000, 0x446c), two(0xF1C0, 0xFC7F), "Ii;fF7", m68040up },
{"fdsubw",	two(0xF000, 0x506c), two(0xF1C0, 0xFC7F), "Ii;wF7", m68040up },
{"fdsubx",	two(0xF000, 0x006c), two(0xF1C0, 0xE07F), "IiF8F7", m68040up },
{"fdsubx",	two(0xF000, 0x486c), two(0xF1C0, 0xFC7F), "Ii;xF7", m68040up },
{"fdsubx",	two(0xF000, 0x006c), two(0xF1C0, 0xE07F), "IiFt",   m68040up },

{"ftanb",	two(0xF000, 0x580F), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftand",	two(0xF000, 0x540F), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftanl",	two(0xF000, 0x400F), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftanp",	two(0xF000, 0x4C0F), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftans",	two(0xF000, 0x440F), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftanw",	two(0xF000, 0x500F), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftanx",	two(0xF000, 0x000F), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftanx",	two(0xF000, 0x480F), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftanx",	two(0xF000, 0x000F), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftanhb",	two(0xF000, 0x5809), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftanhd",	two(0xF000, 0x5409), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftanhl",	two(0xF000, 0x4009), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftanhp",	two(0xF000, 0x4C09), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftanhs",	two(0xF000, 0x4409), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftanhw",	two(0xF000, 0x5009), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftanhx",	two(0xF000, 0x0009), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftanhx",	two(0xF000, 0x4809), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftanhx",	two(0xF000, 0x0009), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftentoxb",	two(0xF000, 0x5812), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftentoxd",	two(0xF000, 0x5412), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftentoxl",	two(0xF000, 0x4012), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftentoxp",	two(0xF000, 0x4C12), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftentoxs",	two(0xF000, 0x4412), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftentoxw",	two(0xF000, 0x5012), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftentoxx",	two(0xF000, 0x0012), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftentoxx",	two(0xF000, 0x4812), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftentoxx",	two(0xF000, 0x0012), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"ftrapeq",	two(0xF07C, 0x0001), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapf",	two(0xF07C, 0x0000), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapge",	two(0xF07C, 0x0013), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgl",	two(0xF07C, 0x0016), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgle",	two(0xF07C, 0x0017), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapgt",	two(0xF07C, 0x0012), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftraple",	two(0xF07C, 0x0015), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftraplt",	two(0xF07C, 0x0014), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapne",	two(0xF07C, 0x000E), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnge",	two(0xF07C, 0x001C), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngl",	two(0xF07C, 0x0019), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngle",	two(0xF07C, 0x0018), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapngt",	two(0xF07C, 0x001D), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnle",	two(0xF07C, 0x001A), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapnlt",	two(0xF07C, 0x001B), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapoge",	two(0xF07C, 0x0003), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapogl",	two(0xF07C, 0x0006), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapogt",	two(0xF07C, 0x0002), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapole",	two(0xF07C, 0x0005), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapolt",	two(0xF07C, 0x0004), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapor",	two(0xF07C, 0x0007), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapseq",	two(0xF07C, 0x0011), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapsf",	two(0xF07C, 0x0010), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapsne",	two(0xF07C, 0x001E), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapst",	two(0xF07C, 0x001F), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapt",	two(0xF07C, 0x000F), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapueq",	two(0xF07C, 0x0009), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapuge",	two(0xF07C, 0x000B), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapugt",	two(0xF07C, 0x000A), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapule",	two(0xF07C, 0x000D), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapult",	two(0xF07C, 0x000C), two(0xF1FF, 0xFFFF), "Ii", mfloat },
{"ftrapun",	two(0xF07C, 0x0008), two(0xF1FF, 0xFFFF), "Ii", mfloat },
        
{"ftrapeqw",	two(0xF07A, 0x0001), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapfw",	two(0xF07A, 0x0000), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapgew",	two(0xF07A, 0x0013), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapglw",	two(0xF07A, 0x0016), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapglew",	two(0xF07A, 0x0017), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapgtw",	two(0xF07A, 0x0012), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftraplew",	two(0xF07A, 0x0015), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapltw",	two(0xF07A, 0x0014), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnew",	two(0xF07A, 0x000E), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapngew",	two(0xF07A, 0x001C), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnglw",	two(0xF07A, 0x0019), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnglew",	two(0xF07A, 0x0018), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapngtw",	two(0xF07A, 0x001D), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnlew",	two(0xF07A, 0x001A), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapnltw",	two(0xF07A, 0x001B), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapogew",	two(0xF07A, 0x0003), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapoglw",	two(0xF07A, 0x0006), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapogtw",	two(0xF07A, 0x0002), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapolew",	two(0xF07A, 0x0005), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapoltw",	two(0xF07A, 0x0004), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftraporw",	two(0xF07A, 0x0007), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapseqw",	two(0xF07A, 0x0011), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapsfw",	two(0xF07A, 0x0010), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapsnew",	two(0xF07A, 0x001E), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapstw",	two(0xF07A, 0x001F), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftraptw",	two(0xF07A, 0x000F), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapueqw",	two(0xF07A, 0x0009), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapugew",	two(0xF07A, 0x000B), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapugtw",	two(0xF07A, 0x000A), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapulew",	two(0xF07A, 0x000D), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapultw",	two(0xF07A, 0x000C), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },
{"ftrapunw",	two(0xF07A, 0x0008), two(0xF1FF, 0xFFFF), "Ii^w", mfloat },

{"ftrapeql",	two(0xF07B, 0x0001), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapfl",	two(0xF07B, 0x0000), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgel",	two(0xF07B, 0x0013), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgll",	two(0xF07B, 0x0016), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapglel",	two(0xF07B, 0x0017), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapgtl",	two(0xF07B, 0x0012), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftraplel",	two(0xF07B, 0x0015), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapltl",	two(0xF07B, 0x0014), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnel",	two(0xF07B, 0x000E), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngel",	two(0xF07B, 0x001C), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngll",	two(0xF07B, 0x0019), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnglel",	two(0xF07B, 0x0018), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapngtl",	two(0xF07B, 0x001D), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnlel",	two(0xF07B, 0x001A), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapnltl",	two(0xF07B, 0x001B), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapogel",	two(0xF07B, 0x0003), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapogll",	two(0xF07B, 0x0006), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapogtl",	two(0xF07B, 0x0002), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapolel",	two(0xF07B, 0x0005), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapoltl",	two(0xF07B, 0x0004), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftraporl",	two(0xF07B, 0x0007), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapseql",	two(0xF07B, 0x0011), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapsfl",	two(0xF07B, 0x0010), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapsnel",	two(0xF07B, 0x001E), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapstl",	two(0xF07B, 0x001F), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftraptl",	two(0xF07B, 0x000F), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapueql",	two(0xF07B, 0x0009), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapugel",	two(0xF07B, 0x000B), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapugtl",	two(0xF07B, 0x000A), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapulel",	two(0xF07B, 0x000D), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapultl",	two(0xF07B, 0x000C), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },
{"ftrapunl",	two(0xF07B, 0x0008), two(0xF1FF, 0xFFFF), "Ii^l", mfloat },

{"ftstb",	two(0xF000, 0x583A), two(0xF1C0, 0xFC7F), "Ii;b", mfloat },
{"ftstd",	two(0xF000, 0x543A), two(0xF1C0, 0xFC7F), "Ii;F", mfloat },
{"ftstl",	two(0xF000, 0x403A), two(0xF1C0, 0xFC7F), "Ii;l", mfloat },
{"ftstp",	two(0xF000, 0x4C3A), two(0xF1C0, 0xFC7F), "Ii;p", mfloat },
{"ftsts",	two(0xF000, 0x443A), two(0xF1C0, 0xFC7F), "Ii;f", mfloat },
{"ftstw",	two(0xF000, 0x503A), two(0xF1C0, 0xFC7F), "Ii;w", mfloat },
{"ftstx",	two(0xF000, 0x003A), two(0xF1C0, 0xE07F), "IiF8", mfloat },
{"ftstx",	two(0xF000, 0x483A), two(0xF1C0, 0xFC7F), "Ii;x", mfloat },

{"ftwotoxb",	two(0xF000, 0x5811), two(0xF1C0, 0xFC7F), "Ii;bF7", mfloat },
{"ftwotoxd",	two(0xF000, 0x5411), two(0xF1C0, 0xFC7F), "Ii;FF7", mfloat },
{"ftwotoxl",	two(0xF000, 0x4011), two(0xF1C0, 0xFC7F), "Ii;lF7", mfloat },
{"ftwotoxp",	two(0xF000, 0x4C11), two(0xF1C0, 0xFC7F), "Ii;pF7", mfloat },
{"ftwotoxs",	two(0xF000, 0x4411), two(0xF1C0, 0xFC7F), "Ii;fF7", mfloat },
{"ftwotoxw",	two(0xF000, 0x5011), two(0xF1C0, 0xFC7F), "Ii;wF7", mfloat },
{"ftwotoxx",	two(0xF000, 0x0011), two(0xF1C0, 0xE07F), "IiF8F7", mfloat },
{"ftwotoxx",	two(0xF000, 0x4811), two(0xF1C0, 0xFC7F), "Ii;xF7", mfloat },
{"ftwotoxx",	two(0xF000, 0x0011), two(0xF1C0, 0xE07F), "IiFt",   mfloat },

{"halt",	one(0045310),	one(0177777), "",     m68060 | mcf },

{"illegal",	one(0045374),	one(0177777), "",     m68000up },

{"jmp",		one(0047300),	one(0177700), "!s", m68000up | mcf },

{"jra",		one(0060000),	one(0177400), "Bg", m68000up | mcf },
{"jra",		one(0047300),	one(0177700), "!s", m68000up | mcf },

{"jsr",		one(0047200),	one(0177700), "!s", m68000up | mcf },

{"jbsr",	one(0060400),	one(0177400), "Bg", m68000up | mcf },
{"jbsr",	one(0047200),	one(0177700), "!s", m68000up | mcf },

{"lea",		one(0040700),	one(0170700), "!sAd", m68000up | mcf },

{"lpstop",	two(0174000,0000700),two(0177777,0177777),"#w", cpu32|m68060 },

{"linkw",	one(0047120),	one(0177770), "As#w", m68000up | mcf },
{"linkl",	one(0044010),	one(0177770), "As#l", m68020up | cpu32 },
{"link",	one(0047120),	one(0177770), "As#W", m68000up | mcf },
{"link",	one(0044010),	one(0177770), "As#l", m68020up | cpu32 },

{"lslb",	one(0160410),	one(0170770), "QdDs", m68000up },
{"lslb",	one(0160450),	one(0170770), "DdDs", m68000up },
{"lslw",	one(0160510),	one(0170770), "QdDs", m68000up },
{"lslw",	one(0160550),	one(0170770), "DdDs", m68000up },
{"lslw",	one(0161700),	one(0177700), "~s",   m68000up },
{"lsll",	one(0160610),	one(0170770), "QdDs", m68000up | mcf },
{"lsll",	one(0160650),	one(0170770), "DdDs", m68000up | mcf },

{"lsrb",	one(0160010),	one(0170770), "QdDs", m68000up },
{"lsrb",	one(0160050),	one(0170770), "DdDs", m68000up },
{"lsrw",	one(0160110),	one(0170770), "QdDs", m68000up },
{"lsrw",	one(0160150),	one(0170770), "DdDs", m68000up },
{"lsrw",	one(0161300),	one(0177700), "~s",   m68000up },
{"lsrl",	one(0160210),	one(0170770), "QdDs", m68000up | mcf },
{"lsrl",	one(0160250),	one(0170770), "DdDs", m68000up | mcf },

  /* FIXME: add MAM mode (`&' after <ea> operand) / remove MACM */
{"macw",  two(0120000, 0000000), two(0170660, 0005400), "uMum", mcf5307up | mcf5206e },
{"macw",  two(0120000, 0001000), two(0170660, 0005400), "uMumMh",mcf5307up | mcf5206e },
{"macw",  two(0120220, 0000000), two(0170670, 0005460), "uNuoasRn", mcf5307up | mcf5206e },
{"macw",  two(0120230, 0000000), two(0170670, 0005460), "uNuo+sRn", mcf5307up | mcf5206e },
{"macw",  two(0120240, 0000000), two(0170670, 0005460), "uNuo-sRn", mcf5307up | mcf5206e },
{"macw",  two(0120250, 0000000), two(0170670, 0005460), "uNuodsRn", mcf5307up | mcf5206e },
{"macw",  two(0120220, 0001000), two(0170670, 0005460), "uNuoMhasRn", mcf5307up | mcf5206e },
{"macw",  two(0120230, 0001000), two(0170670, 0005460), "uNuoMh+sRn", mcf5307up | mcf5206e },
{"macw",  two(0120240, 0001000), two(0170670, 0005460), "uNuoMh-sRn", mcf5307up | mcf5206e },
{"macw",  two(0120250, 0001000), two(0170670, 0005460), "uNuoMhdsRn", mcf5307up | mcf5206e },
{"macmw", two(0120220, 0000040), two(0170670, 0005460), "uNuoasRn", mcf5307up | mcf5206e },
{"macmw", two(0120230, 0000040), two(0170670, 0005460), "uNuo+sRn", mcf5307up | mcf5206e },
{"macmw", two(0120240, 0000040), two(0170670, 0005460), "uNuo-sRn", mcf5307up | mcf5206e },
{"macmw", two(0120250, 0000040), two(0170670, 0005460), "uNuodsRn", mcf5307up | mcf5206e },
{"macmw", two(0120220, 0001040), two(0170670, 0005460), "uNuoMhasRn", mcf5307up | mcf5206e },
{"macmw", two(0120230, 0001040), two(0170670, 0005460), "uNuoMh+sRn", mcf5307up | mcf5206e },
{"macmw", two(0120240, 0001040), two(0170670, 0005460), "uNuoMh-sRn", mcf5307up | mcf5206e },
{"macmw", two(0120250, 0001040), two(0170670, 0005460), "uNuoMhdsRn", mcf5307up | mcf5206e },

{"macl",  two(0120000, 0004000), two(0170660, 0005400), "RsRm", mcf5307up | mcf5206e },
{"macl",  two(0120000, 0005000), two(0170660, 0005400), "RsRmMh", mcf5307up | mcf5206e },
{"macl",  two(0120220, 0004000), two(0170670, 0005460), "R3R1asRn", mcf5307up | mcf5206e },
{"macl",  two(0120230, 0004000), two(0170670, 0005460), "R3R1+sRn", mcf5307up | mcf5206e },
{"macl",  two(0120240, 0004000), two(0170670, 0005460), "R3R1-sRn", mcf5307up | mcf5206e },
{"macl",  two(0120250, 0004000), two(0170670, 0005460), "R3R1dsRn", mcf5307up | mcf5206e },
{"macl",  two(0120220, 0005000), two(0170670, 0005460), "R3R1MhasRn", mcf5307up | mcf5206e },
{"macl",  two(0120230, 0005000), two(0170670, 0005460), "R3R1Mh+sRn", mcf5307up | mcf5206e },
{"macl",  two(0120240, 0005000), two(0170670, 0005460), "R3R1Mh-sRn", mcf5307up | mcf5206e },
{"macl",  two(0120250, 0005000), two(0170670, 0005460), "R3R1MhdsRn", mcf5307up | mcf5206e },
{"macml", two(0120220, 0004040), two(0170670, 0005460), "R3R1asRn", mcf5307up | mcf5206e },
{"macml", two(0120230, 0004040), two(0170670, 0005460), "R3R1+sRn", mcf5307up | mcf5206e },
{"macml", two(0120240, 0004040), two(0170670, 0005460), "R3R1-sRn", mcf5307up | mcf5206e },
{"macml", two(0120250, 0004040), two(0170670, 0005460), "R3R1dsRn", mcf5307up | mcf5206e },
{"macml", two(0120220, 0005040), two(0170670, 0005460), "R3R1MhasRn", mcf5307up | mcf5206e },
{"macml", two(0120230, 0005040), two(0170670, 0005460), "R3R1Mh+sRn", mcf5307up | mcf5206e },
{"macml", two(0120240, 0005040), two(0170670, 0005460), "R3R1Mh-sRn", mcf5307up | mcf5206e },
{"macml", two(0120250, 0005040), two(0170670, 0005460), "R3R1MhdsRn", mcf5307up | mcf5206e },

/* NOTE: The mcf5200 family programmer's reference manual does not 
   indicate the byte form of the movea instruction is invalid (as it
   is on 68000 family cpus).  However, experiments on the 5202 yeild
   unexpected results.  The value is copied, but it is not sign extended
   (as is done with movea.w) and the top three bytes in the address 
   register are not disturbed.  I don't know if this is the intended
   behavior --- it could be a hole in instruction decoding (Motorola
   decided not to trap all invalid instructions for performance reasons)
   --- but I suspect that it is not.   

   I reported this to Motorola ISD Technical Communications Support, 
   which replied that other coldfire assemblers reject movea.b.  For 
   this reason I've decided to not allow moveab. 

	jtc@cygnus.com - 97/01/24
 */

{"moveal",	one(0020100),	one(0170700), "*lAd", m68000up | mcf },
{"moveaw",	one(0030100),	one(0170700), "*wAd", m68000up | mcf },

{"movec",	one(0047173),	one(0177777), "R1Jj", m68010up | mcf },
{"movec",	one(0047173),	one(0177777), "R1#j", m68010up | mcf },
{"movec",	one(0047172),	one(0177777), "JjR1", m68010up },
{"movec",	one(0047172),	one(0177777), "#jR1", m68010up },

{"movemw",	one(0044200),	one(0177700), "Lw&s", m68000up },
{"movemw",	one(0044240),	one(0177770), "lw-s", m68000up },
{"movemw",	one(0044200),	one(0177700), "#w>s", m68000up },
{"movemw",	one(0046200),	one(0177700), "<sLw", m68000up },
{"movemw",	one(0046200),	one(0177700), "<s#w", m68000up },
{"moveml",	one(0044300),	one(0177700), "Lw&s", m68000up },
{"moveml",	one(0044340),	one(0177770), "lw-s", m68000up },
{"moveml",	one(0044300),	one(0177700), "#w>s", m68000up },
{"moveml",	one(0046300),	one(0177700), "<sLw", m68000up },
{"moveml",	one(0046300),	one(0177700), "<s#w", m68000up },
/* FIXME: need specifier for mode 2 and 5 to simplify below insn patterns */
{"moveml",	one(0044320),	one(0177770), "Lwas", mcf },
{"moveml",	one(0044320),	one(0177770), "#was", mcf },
{"moveml",	one(0044350),	one(0177770), "Lwds", mcf },
{"moveml",	one(0044350),	one(0177770), "#wds", mcf },
{"moveml",	one(0046320),	one(0177770), "asLw", mcf },
{"moveml",	one(0046320),	one(0177770), "as#w", mcf },
{"moveml",	one(0046350),	one(0177770), "dsLw", mcf },
{"moveml",	one(0046350),	one(0177770), "ds#w", mcf },

{"movepw",	one(0000410),	one(0170770), "dsDd", m68000up },
{"movepw",	one(0000610),	one(0170770), "Ddds", m68000up },
{"movepl",	one(0000510),	one(0170770), "dsDd", m68000up },
{"movepl",	one(0000710),	one(0170770), "Ddds", m68000up },

{"moveq",	one(0070000),	one(0170400), "MsDd", m68000up | mcf },
{"moveq",	one(0070000),	one(0170400), "#BDd", m68000up | mcf },

/* The move opcode can generate the movea and moveq instructions.  */
{"moveb",	one(0010000),	one(0170000), ";b$d", m68000up },
{"moveb",	one(0010000),	one(0170070), "Ds$d", mcf },
{"moveb",	one(0010020),	one(0170070), "as$d", mcf },
{"moveb",	one(0010030),	one(0170070), "+s$d", mcf },
{"moveb",	one(0010040),	one(0170070), "-s$d", mcf },
{"moveb",	one(0010000),	one(0170000), "nsqd", mcf },
{"moveb",	one(0010000),	one(0170700), "obDd", mcf },
{"moveb",	one(0010200),	one(0170700), "obad", mcf },
{"moveb",	one(0010300),	one(0170700), "ob+d", mcf },
{"moveb",	one(0010400),	one(0170700), "ob-d", mcf },
{"moveb",	one(0010000),	one(0170000), "obnd", mcf5407 },

{"movew",	one(0030000),	one(0170000), "*w%d", m68000up },
{"movew",	one(0030000),	one(0170000), "ms%d", mcf },
{"movew",	one(0030000),	one(0170000), "nspd", mcf },
{"movew",	one(0030000),	one(0170000), "owmd", mcf },
{"movew",	one(0030000),	one(0170000), "ownd", mcf5407 },
{"movew",	one(0040300),	one(0177700), "Ss$s", m68000up },
{"movew",	one(0040300),	one(0177770), "SsDs", mcf },
{"movew",	one(0041300),	one(0177700), "Cs$s", m68010up },
{"movew",	one(0041300),	one(0177770), "CsDs", mcf },
{"movew",	one(0042300),	one(0177700), ";wCd", m68000up },
{"movew",	one(0042300),	one(0177700), "DsCd", mcf },
{"movew",	one(0042374),	one(0177777), "#wCd", mcf },
{"movew",	one(0043300),	one(0177700), ";wSd", m68000up },
{"movew",	one(0043300),	one(0177700), "DsSd", mcf },
{"movew",	one(0043374),	one(0177777), "#wSd", mcf },

{"movel",	one(0070000),	one(0170400), "MsDd", m68000up | mcf },
{"movel",	one(0020000),	one(0170000), "*l%d", m68000up },
{"movel",	one(0020000),	one(0170000), "ms%d", mcf },
{"movel",	one(0020000),	one(0170000), "nspd", mcf },
{"movel",	one(0020000),	one(0170000), "olmd", mcf },
{"movel",	one(0020000),	one(0170000), "olnd", mcf5407 },
{"movel",	one(0047140),	one(0177770), "AsUd", m68000up },
{"movel",	one(0047150),	one(0177770), "UdAs", m68000up },
{"movel",	one(0120600),	one(0177760), "EsRs", mcf5307up | mcf5206e },
{"movel",	one(0120400),	one(0177760), "RsEs", mcf5307up | mcf5206e },
{"movel",	one(0120474),	one(0177777), "#lEs", mcf5307up | mcf5206e },
{"movel",	one(0124600),	one(0177760), "GsRs", mcf5307up | mcf5206e },
{"movel",	one(0124400),	one(0177760), "RsGs", mcf5307up | mcf5206e },
{"movel",	one(0124474),	one(0177777), "#lGs", mcf5307up | mcf5206e },
{"movel",	one(0126600),	one(0177760), "HsRs", mcf5307up | mcf5206e },
{"movel",	one(0126400),	one(0177760), "RsHs", mcf5307up | mcf5206e },
{"movel",	one(0126474),	one(0177777), "#lHs", mcf5307up | mcf5206e },
{"movel",	one(0124700),	one(0177777), "GsCs", mcf5307up | mcf5206e },

{"move",	one(0030000),	one(0170000), "*w%d", m68000up },
{"move",	one(0030000),	one(0170000), "ms%d", mcf },
{"move",	one(0030000),	one(0170000), "nspd", mcf },
{"move",	one(0030000),	one(0170000), "owmd", mcf },
{"move",	one(0030000),	one(0170000), "ownd", mcf5407 },
{"move",	one(0040300),	one(0177700), "Ss$s", m68000up },
{"move",	one(0040300),	one(0177770), "SsDs", mcf },
{"move",	one(0041300),	one(0177700), "Cs$s", m68010up },
{"move",	one(0041300),	one(0177770), "CsDs", mcf },
{"move",	one(0042300),	one(0177700), ";wCd", m68000up },
{"move",	one(0042300),	one(0177700), "DsCd", mcf },
{"move",	one(0042374),	one(0177777), "#wCd", mcf },
{"move",	one(0043300),	one(0177700), ";wSd", m68000up },
{"move",	one(0043300),	one(0177700), "DsSd", mcf },
{"move",	one(0043374),	one(0177777), "#wSd", mcf },

{"move",	one(0047140),	one(0177770), "AsUd", m68000up },
{"move",	one(0047150),	one(0177770), "UdAs", m68000up },

{"mov3ql",	one(0120500),	one(0170700), "Qd%s", mcf5407 },
{"mvsb",	one(0070400),	one(0170700), "*bDd", mcf5407 },
{"mvsw",	one(0070500),	one(0170700), "*wDd", mcf5407 },
{"mvzb",	one(0070600),	one(0170700), "*bDd", mcf5407 },
{"mvzw",	one(0070700),	one(0170700), "*wDd", mcf5407 },

{"movesb",	two(0007000, 0),     two(0177700, 07777), "~sR1", m68010up },
{"movesb",	two(0007000, 04000), two(0177700, 07777), "R1~s", m68010up },
{"movesw",	two(0007100, 0),     two(0177700, 07777), "~sR1", m68010up },
{"movesw",	two(0007100, 04000), two(0177700, 07777), "R1~s", m68010up },
{"movesl",	two(0007200, 0),     two(0177700, 07777), "~sR1", m68010up },
{"movesl",	two(0007200, 04000), two(0177700, 07777), "R1~s", m68010up },

{"move16",	two(0xf620, 0x8000), two(0xfff8, 0x8fff), "+s+1", m68040up },
{"move16",	one(0xf600),		one(0xfff8), "+s_L", m68040up },
{"move16",	one(0xf608),		one(0xfff8), "_L+s", m68040up },
{"move16",	one(0xf610),		one(0xfff8), "as_L", m68040up },
{"move16",	one(0xf618),		one(0xfff8), "_Las", m68040up },

  /* FIXME: add MAM mode (`&' after <ea> operand) / remove MSACM */
{"msacw",  two(0120000, 0000400), two(0170660, 0005400), "uMum", mcf5307up | mcf5206e },
{"msacw",  two(0120000, 0001400), two(0170660, 0005400), "uMumMh", mcf5307up | mcf5206e },
{"msacw",  two(0120220, 0000400), two(0170670, 0005460), "uNuoasRn", mcf5307up | mcf5206e },
{"msacw",  two(0120230, 0000400), two(0170670, 0005460), "uNuo+sRn", mcf5307up | mcf5206e },
{"msacw",  two(0120240, 0000400), two(0170670, 0005460), "uNuo-sRn", mcf5307up | mcf5206e },
{"msacw",  two(0120250, 0000400), two(0170670, 0005460), "uNuodsRn", mcf5307up | mcf5206e },
{"msacw",  two(0120220, 0001400), two(0170670, 0005460), "uNuoMhasRn", mcf5307up | mcf5206e },
{"msacw",  two(0120230, 0001400), two(0170670, 0005460), "uNuoMh+sRn", mcf5307up | mcf5206e },
{"msacw",  two(0120240, 0001400), two(0170670, 0005460), "uNuoMh-sRn", mcf5307up | mcf5206e },
{"msacw",  two(0120250, 0001400), two(0170670, 0005460), "uNuoMhdsRn", mcf5307up | mcf5206e },
{"msacmw", two(0120220, 0000440), two(0170670, 0005460), "uNuoasRn", mcf5307up | mcf5206e },
{"msacmw", two(0120230, 0000440), two(0170670, 0005460), "uNuo+sRn", mcf5307up | mcf5206e },
{"msacmw", two(0120240, 0000440), two(0170670, 0005460), "uNuo-sRn", mcf5307up | mcf5206e },
{"msacmw", two(0120250, 0000440), two(0170670, 0005460), "uNuodsRn", mcf5307up | mcf5206e },
{"msacmw", two(0120220, 0001440), two(0170670, 0005460), "uNuoMhasRn", mcf5307up | mcf5206e },
{"msacmw", two(0120230, 0001440), two(0170670, 0005460), "uNuoMh+sRn", mcf5307up | mcf5206e },
{"msacmw", two(0120240, 0001440), two(0170670, 0005460), "uNuoMh-sRn", mcf5307up | mcf5206e },
{"msacmw", two(0120250, 0001440), two(0170670, 0005460), "uNuoMhdsRn", mcf5307up | mcf5206e },

{"msacl",  two(0120000, 0004400), two(0170660, 0005400), "RsRm", mcf5307up | mcf5206e },
{"msacl",  two(0120000, 0005400), two(0170660, 0005400), "RsRmMh", mcf5307up | mcf5206e },
{"msacl",  two(0120220, 0004400), two(0170670, 0005460), "R3R1asRn", mcf5307up | mcf5206e },
{"msacl",  two(0120230, 0004400), two(0170670, 0005460), "R3R1+sRn", mcf5307up | mcf5206e },
{"msacl",  two(0120240, 0004400), two(0170670, 0005460), "R3R1-sRn", mcf5307up | mcf5206e },
{"msacl",  two(0120250, 0004400), two(0170670, 0005460), "R3R1dsRn", mcf5307up | mcf5206e },
{"msacl",  two(0120220, 0005400), two(0170670, 0005460), "R3R1MhasRn", mcf5307up | mcf5206e },
{"msacl",  two(0120230, 0005400), two(0170670, 0005460), "R3R1Mh+sRn", mcf5307up | mcf5206e },
{"msacl",  two(0120240, 0005400), two(0170670, 0005460), "R3R1Mh-sRn", mcf5307up | mcf5206e },
{"msacl",  two(0120250, 0005400), two(0170670, 0005460), "R3R1MhdsRn", mcf5307up | mcf5206e },
{"msacml", two(0120220, 0004440), two(0170670, 0005460), "R3R1asRn", mcf5307up | mcf5206e },
{"msacml", two(0120230, 0004440), two(0170670, 0005460), "R3R1+sRn", mcf5307up | mcf5206e },
{"msacml", two(0120240, 0004440), two(0170670, 0005460), "R3R1-sRn", mcf5307up | mcf5206e },
{"msacml", two(0120250, 0004440), two(0170670, 0005460), "R3R1dsRn", mcf5307up | mcf5206e },
{"msacml", two(0120220, 0005440), two(0170670, 0005460), "R3R1MhasRn", mcf5307up | mcf5206e },
{"msacml", two(0120230, 0005440), two(0170670, 0005460), "R3R1Mh+sRn", mcf5307up | mcf5206e },
{"msacml", two(0120240, 0005440), two(0170670, 0005460), "R3R1Mh-sRn", mcf5307up | mcf5206e },
{"msacml", two(0120250, 0005440), two(0170670, 0005460), "R3R1MhdsRn", mcf5307up | mcf5206e },

{"mulsw",	one(0140700),		one(0170700), ";wDd", m68000up|mcf },
{"mulsl",	two(0046000,004000), two(0177700,0107770), ";lD1", m68020up|cpu32 },
{"mulsl",	two(0046000,004000), two(0177700,0107770), "qsD1", mcf },
{"mulsl",	two(0046000,006000), two(0177700,0107770), ";lD3D1",m68020up|cpu32 },

{"muluw",	one(0140300),		one(0170700), ";wDd", m68000up|mcf },
{"mulul",	two(0046000,000000), two(0177700,0107770), ";lD1", m68020up|cpu32 },
{"mulul",	two(0046000,000000), two(0177700,0107770), "qsD1", mcf },
{"mulul",	two(0046000,002000), two(0177700,0107770), ";lD3D1",m68020up|cpu32 },

{"nbcd",	one(0044000),	one(0177700), "$s", m68000up },

{"negb",	one(0042000),	one(0177700), "$s", m68000up },
{"negw",	one(0042100),	one(0177700), "$s", m68000up },
{"negl",	one(0042200),	one(0177700), "$s", m68000up },
{"negl",	one(0042200),	one(0177700), "Ds", mcf},

{"negxb",	one(0040000),	one(0177700), "$s", m68000up },
{"negxw",	one(0040100),	one(0177700), "$s", m68000up },
{"negxl",	one(0040200),	one(0177700), "$s", m68000up },
{"negxl",	one(0040200),	one(0177700), "Ds", mcf},

{"nop",		one(0047161),	one(0177777), "", m68000up | mcf},

{"notb",	one(0043000),	one(0177700), "$s", m68000up },
{"notw",	one(0043100),	one(0177700), "$s", m68000up },
{"notl",	one(0043200),	one(0177700), "$s", m68000up },
{"notl",	one(0043200),	one(0177700), "Ds", mcf},

{"orib",	one(0000000),	one(0177700), "#b$s", m68000up },
{"orib",	one(0000074),	one(0177777), "#bCs", m68000up },
{"oriw",	one(0000100),	one(0177700), "#w$s", m68000up },
{"oriw",	one(0000174),	one(0177777), "#wSs", m68000up },
{"oril",	one(0000200),	one(0177700), "#l$s", m68000up },
{"oril",	one(0000200),	one(0177700), "#lDs", mcf },
{"ori",		one(0000074),	one(0177777), "#bCs", m68000up },
{"ori",		one(0000100),	one(0177700), "#w$s", m68000up },
{"ori",		one(0000174),	one(0177777), "#wSs", m68000up },

/* The or opcode can generate the ori instruction.  */
{"orb",		one(0000000),	one(0177700), "#b$s", m68000up },
{"orb",		one(0000074),	one(0177777), "#bCs", m68000up },
{"orb",		one(0100000),	one(0170700), ";bDd", m68000up },
{"orb",		one(0100400),	one(0170700), "Dd~s", m68000up },
{"orw",		one(0000100),	one(0177700), "#w$s", m68000up },
{"orw",		one(0000174),	one(0177777), "#wSs", m68000up },
{"orw",		one(0100100),	one(0170700), ";wDd", m68000up },
{"orw",		one(0100500),	one(0170700), "Dd~s", m68000up },
{"orl",		one(0000200),	one(0177700), "#l$s", m68000up },
{"orl",		one(0000200),	one(0177700), "#lDs", mcf },
{"orl",		one(0100200),	one(0170700), ";lDd", m68000up | mcf },
{"orl",		one(0100600),	one(0170700), "Dd~s", m68000up | mcf },
{"or",		one(0000074),	one(0177777), "#bCs", m68000up },
{"or",		one(0000100),	one(0177700), "#w$s", m68000up },
{"or",		one(0000174),	one(0177777), "#wSs", m68000up },
{"or",		one(0100100),	one(0170700), ";wDd", m68000up },
{"or",		one(0100500),	one(0170700), "Dd~s", m68000up },

{"pack",	one(0100500),	one(0170770), "DsDd#w", m68020up },
{"pack",	one(0100510),	one(0170770), "-s-d#w", m68020up },

{"pbac",	one(0xf087),		one(0xffbf), "Bc", m68851 },
{"pbacw",	one(0xf087),		one(0xffff), "BW", m68851 },
{"pbas",	one(0xf086),		one(0xffbf), "Bc", m68851 },
{"pbasw",	one(0xf086),		one(0xffff), "BW", m68851 },
{"pbbc",	one(0xf081),		one(0xffbf), "Bc", m68851 },
{"pbbcw",	one(0xf081),		one(0xffff), "BW", m68851 },
{"pbbs",	one(0xf080),		one(0xffbf), "Bc", m68851 },
{"pbbsw",	one(0xf080),		one(0xffff), "BW", m68851 },
{"pbcc",	one(0xf08f),		one(0xffbf), "Bc", m68851 },
{"pbccw",	one(0xf08f),		one(0xffff), "BW", m68851 },
{"pbcs",	one(0xf08e),		one(0xffbf), "Bc", m68851 },
{"pbcsw",	one(0xf08e),		one(0xffff), "BW", m68851 },
{"pbgc",	one(0xf08d),		one(0xffbf), "Bc", m68851 },
{"pbgcw",	one(0xf08d),		one(0xffff), "BW", m68851 },
{"pbgs",	one(0xf08c),		one(0xffbf), "Bc", m68851 },
{"pbgsw",	one(0xf08c),		one(0xffff), "BW", m68851 },
{"pbic",	one(0xf08b),		one(0xffbf), "Bc", m68851 },
{"pbicw",	one(0xf08b),		one(0xffff), "BW", m68851 },
{"pbis",	one(0xf08a),		one(0xffbf), "Bc", m68851 },
{"pbisw",	one(0xf08a),		one(0xffff), "BW", m68851 },
{"pblc",	one(0xf083),		one(0xffbf), "Bc", m68851 },
{"pblcw",	one(0xf083),		one(0xffff), "BW", m68851 },
{"pbls",	one(0xf082),		one(0xffbf), "Bc", m68851 },
{"pblsw",	one(0xf082),		one(0xffff), "BW", m68851 },
{"pbsc",	one(0xf085),		one(0xffbf), "Bc", m68851 },
{"pbscw",	one(0xf085),		one(0xffff), "BW", m68851 },
{"pbss",	one(0xf084),		one(0xffbf), "Bc", m68851 },
{"pbssw",	one(0xf084),		one(0xffff), "BW", m68851 },
{"pbwc",	one(0xf089),		one(0xffbf), "Bc", m68851 },
{"pbwcw",	one(0xf089),		one(0xffff), "BW", m68851 },
{"pbws",	one(0xf088),		one(0xffbf), "Bc", m68851 },
{"pbwsw",	one(0xf088),		one(0xffff), "BW", m68851 },

{"pdbac",	two(0xf048, 0x0007),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbas",	two(0xf048, 0x0006),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbbc",	two(0xf048, 0x0001),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbbs",	two(0xf048, 0x0000),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbcc",	two(0xf048, 0x000f),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbcs",	two(0xf048, 0x000e),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbgc",	two(0xf048, 0x000d),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbgs",	two(0xf048, 0x000c),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbic",	two(0xf048, 0x000b),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbis",	two(0xf048, 0x000a),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdblc",	two(0xf048, 0x0003),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbls",	two(0xf048, 0x0002),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbsc",	two(0xf048, 0x0005),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbss",	two(0xf048, 0x0004),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbwc",	two(0xf048, 0x0009),	two(0xfff8, 0xffff), "DsBw", m68851 },
{"pdbws",	two(0xf048, 0x0008),	two(0xfff8, 0xffff), "DsBw", m68851 },

{"pea",		one(0044100),		one(0177700), "!s", m68000up|mcf },

{"pflusha",	one(0xf518),		one(0xfff8), "", m68040up },
{"pflusha",	two(0xf000,0x2400), two(0xffff,0xffff), "", m68030 | m68851 },

{"pflush",   two(0xf000,0x3010), two(0xffc0,0xfe10), "T3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3810), two(0xffc0,0xfe10), "T3T9&s", m68030|m68851 },
{"pflush",   two(0xf000,0x3008), two(0xffc0,0xfe18), "D3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3808), two(0xffc0,0xfe18), "D3T9&s", m68030|m68851 },
{"pflush",   two(0xf000,0x3000), two(0xffc0,0xfe1e), "f3T9", m68030|m68851 },
{"pflush",   two(0xf000,0x3800), two(0xffc0,0xfe1e), "f3T9&s", m68030|m68851 },
{"pflush",	one(0xf508),		one(0xfff8), "as", m68040up },
{"pflush",	one(0xf508),		one(0xfff8), "As", m68040up },

{"pflushan",	one(0xf510),		one(0xfff8), "", m68040up },
{"pflushn",	one(0xf500),		one(0xfff8), "as", m68040up },
{"pflushn",	one(0xf500),		one(0xfff8), "As", m68040up },

{"pflushr",	two(0xf000, 0xa000), two(0xffc0, 0xffff), "|s", m68851 },

{"pflushs",	two(0xf000, 0x3410), two(0xfff8, 0xfe10), "T3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c10), two(0xfff8, 0xfe10), "T3T9&s", m68851 },
{"pflushs",	two(0xf000, 0x3408), two(0xfff8, 0xfe18), "D3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c08), two(0xfff8, 0xfe18), "D3T9&s", m68851 },
{"pflushs",	two(0xf000, 0x3400), two(0xfff8, 0xfe1e), "f3T9", m68851 },
{"pflushs",	two(0xf000, 0x3c00), two(0xfff8, 0xfe1e), "f3T9&s", m68851 },

{"ploadr",     two(0xf000,0x2210), two(0xffc0,0xfff0), "T3&s", m68030|m68851 },
{"ploadr",     two(0xf000,0x2208), two(0xffc0,0xfff8), "D3&s", m68030|m68851 },
{"ploadr",     two(0xf000,0x2200), two(0xffc0,0xfffe), "f3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2010), two(0xffc0,0xfff0), "T3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2008), two(0xffc0,0xfff8), "D3&s", m68030|m68851 },
{"ploadw",     two(0xf000,0x2000), two(0xffc0,0xfffe), "f3&s", m68030|m68851 },

{"plpar",	one(0xf5c8),		one(0xfff8), "as", m68060 },
{"plpaw",	one(0xf588),		one(0xfff8), "as", m68060 },

{"pmove",      two(0xf000,0x4000), two(0xffc0,0xffff), "*l08", m68030|m68851 },
{"pmove",      two(0xf000,0x5c00), two(0xffc0,0xffff), "*w18", m68851 },
{"pmove",      two(0xf000,0x4000), two(0xffc0,0xe3ff), "*b28", m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xffff), "08%s", m68030|m68851 },
{"pmove",      two(0xf000,0x5e00), two(0xffc0,0xffff), "18%s", m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xe3ff), "28%s", m68851 },
{"pmove",      two(0xf000,0x4000), two(0xffc0,0xe3ff), "|sW8", m68030|m68851 },
{"pmove",      two(0xf000,0x4200), two(0xffc0,0xe3ff), "W8~s", m68030|m68851 },
{"pmove",      two(0xf000,0x6200), two(0xffc0,0xe3e3), "*wX3", m68851 },
{"pmove",      two(0xf000,0x6000), two(0xffc0,0xe3e3), "X3%s", m68851 },
{"pmove",      two(0xf000,0x6000), two(0xffc0,0xffff), "*wY8", m68030|m68851 },
{"pmove",      two(0xf000,0x6200), two(0xffc0,0xffff), "Y8%s", m68030|m68851 },
{"pmove",      two(0xf000,0x6600), two(0xffc0,0xffff), "Z8%s", m68851 },
{"pmove",      two(0xf000,0x0800), two(0xffc0,0xfbff), "*l38", m68030 },
{"pmove",      two(0xf000,0x0a00), two(0xffc0,0xfbff), "38%s", m68030 },

{"pmovefd",	two(0xf000, 0x4100),	two(0xffc0, 0xe3ff), "*l08", m68030 },
{"pmovefd",	two(0xf000, 0x4100),	two(0xffc0, 0xe3ff), "|sW8", m68030 },
{"pmovefd",	two(0xf000, 0x0900),	two(0xffc0, 0xfbff), "*l38", m68030 },

{"prestore",	one(0xf140),		one(0xffc0), "<s", m68851 },

{"psave",	one(0xf100),		one(0xffc0), ">s", m68851 },

{"psac",	two(0xf040, 0x0007),	two(0xffc0, 0xffff), "$s", m68851 },
{"psas",	two(0xf040, 0x0006),	two(0xffc0, 0xffff), "$s", m68851 },
{"psbc",	two(0xf040, 0x0001),	two(0xffc0, 0xffff), "$s", m68851 },
{"psbs",	two(0xf040, 0x0000),	two(0xffc0, 0xffff), "$s", m68851 },
{"pscc",	two(0xf040, 0x000f),	two(0xffc0, 0xffff), "$s", m68851 },
{"pscs",	two(0xf040, 0x000e),	two(0xffc0, 0xffff), "$s", m68851 },
{"psgc",	two(0xf040, 0x000d),	two(0xffc0, 0xffff), "$s", m68851 },
{"psgs",	two(0xf040, 0x000c),	two(0xffc0, 0xffff), "$s", m68851 },
{"psic",	two(0xf040, 0x000b),	two(0xffc0, 0xffff), "$s", m68851 },
{"psis",	two(0xf040, 0x000a),	two(0xffc0, 0xffff), "$s", m68851 },
{"pslc",	two(0xf040, 0x0003),	two(0xffc0, 0xffff), "$s", m68851 },
{"psls",	two(0xf040, 0x0002),	two(0xffc0, 0xffff), "$s", m68851 },
{"pssc",	two(0xf040, 0x0005),	two(0xffc0, 0xffff), "$s", m68851 },
{"psss",	two(0xf040, 0x0004),	two(0xffc0, 0xffff), "$s", m68851 },
{"pswc",	two(0xf040, 0x0009),	two(0xffc0, 0xffff), "$s", m68851 },
{"psws",	two(0xf040, 0x0008),	two(0xffc0, 0xffff), "$s", m68851 },

{"ptestr", two(0xf000,0x8210), two(0xffc0, 0xe3f0), "T3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8310), two(0xffc0,0xe310), "T3&st8A9", m68030|m68851 },
{"ptestr", two(0xf000,0x8208), two(0xffc0,0xe3f8), "D3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8308), two(0xffc0,0xe318), "D3&st8A9", m68030|m68851 },
{"ptestr", two(0xf000,0x8200), two(0xffc0,0xe3fe), "f3&st8", m68030|m68851 },
{"ptestr", two(0xf000,0x8300), two(0xffc0,0xe31e), "f3&st8A9", m68030|m68851 },
{"ptestr",	one(0xf568),		one(0xfff8), "as", m68040 },

{"ptestw", two(0xf000,0x8010), two(0xffc0,0xe3f0), "T3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8110), two(0xffc0,0xe310), "T3&st8A9", m68030|m68851 },
{"ptestw", two(0xf000,0x8008), two(0xffc0,0xe3f8), "D3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8108), two(0xffc0,0xe318), "D3&st8A9", m68030|m68851 },
{"ptestw", two(0xf000,0x8000), two(0xffc0,0xe3fe), "f3&st8", m68030|m68851 },
{"ptestw", two(0xf000,0x8100), two(0xffc0,0xe31e), "f3&st8A9", m68030|m68851 },
{"ptestw",	one(0xf548),		one(0xfff8), "as", m68040 },

{"ptrapacw",	two(0xf07a, 0x0007),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapacl",	two(0xf07b, 0x0007),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapac",	two(0xf07c, 0x0007),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapasw",	two(0xf07a, 0x0006),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapasl",	two(0xf07b, 0x0006),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapas",	two(0xf07c, 0x0006),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapbcw",	two(0xf07a, 0x0001),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapbcl",	two(0xf07b, 0x0001),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapbc",	two(0xf07c, 0x0001),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapbsw",	two(0xf07a, 0x0000),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapbsl",	two(0xf07b, 0x0000),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapbs",	two(0xf07c, 0x0000),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapccw",	two(0xf07a, 0x000f),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapccl",	two(0xf07b, 0x000f),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapcc",	two(0xf07c, 0x000f),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapcsw",	two(0xf07a, 0x000e),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapcsl",	two(0xf07b, 0x000e),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapcs",	two(0xf07c, 0x000e),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapgcw",	two(0xf07a, 0x000d),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapgcl",	two(0xf07b, 0x000d),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapgc",	two(0xf07c, 0x000d),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapgsw",	two(0xf07a, 0x000c),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapgsl",	two(0xf07b, 0x000c),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapgs",	two(0xf07c, 0x000c),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapicw",	two(0xf07a, 0x000b),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapicl",	two(0xf07b, 0x000b),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapic",	two(0xf07c, 0x000b),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapisw",	two(0xf07a, 0x000a),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapisl",	two(0xf07b, 0x000a),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapis",	two(0xf07c, 0x000a),	two(0xffff, 0xffff), "",   m68851 },

{"ptraplcw",	two(0xf07a, 0x0003),	two(0xffff, 0xffff), "#w", m68851 },
{"ptraplcl",	two(0xf07b, 0x0003),	two(0xffff, 0xffff), "#l", m68851 },
{"ptraplc",	two(0xf07c, 0x0003),	two(0xffff, 0xffff), "",   m68851 },

{"ptraplsw",	two(0xf07a, 0x0002),	two(0xffff, 0xffff), "#w", m68851 },
{"ptraplsl",	two(0xf07b, 0x0002),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapls",	two(0xf07c, 0x0002),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapscw",	two(0xf07a, 0x0005),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapscl",	two(0xf07b, 0x0005),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapsc",	two(0xf07c, 0x0005),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapssw",	two(0xf07a, 0x0004),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapssl",	two(0xf07b, 0x0004),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapss",	two(0xf07c, 0x0004),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapwcw",	two(0xf07a, 0x0009),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapwcl",	two(0xf07b, 0x0009),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapwc",	two(0xf07c, 0x0009),	two(0xffff, 0xffff), "",   m68851 },

{"ptrapwsw",	two(0xf07a, 0x0008),	two(0xffff, 0xffff), "#w", m68851 },
{"ptrapwsl",	two(0xf07b, 0x0008),	two(0xffff, 0xffff), "#l", m68851 },
{"ptrapws",	two(0xf07c, 0x0008),	two(0xffff, 0xffff), "",   m68851 },

{"pulse",	one(0045314),		one(0177777), "", m68060 | mcf },

{"pvalid",	two(0xf000, 0x2800),	two(0xffc0, 0xffff), "Vs&s", m68851 },
{"pvalid",	two(0xf000, 0x2c00),	two(0xffc0, 0xfff8), "A3&s", m68851 },

  /* FIXME: don't allow Dw==Dx. */
{"remsl",       two(0x4c40, 0x0800),    two(0xffc0, 0x8ff8), "qsD3D1", mcf5307up | mcf5206e },
{"remul",       two(0x4c40, 0x0000),    two(0xffc0, 0x8ff8), "qsD3D1", mcf5307up | mcf5206e },

{"reset",	one(0047160),		one(0177777), "", m68000up },

{"rolb",	one(0160430),		one(0170770), "QdDs", m68000up },
{"rolb",	one(0160470),		one(0170770), "DdDs", m68000up },
{"rolw",	one(0160530),		one(0170770), "QdDs", m68000up },
{"rolw",	one(0160570),		one(0170770), "DdDs", m68000up },
{"rolw",	one(0163700),		one(0177700), "~s",   m68000up },
{"roll",	one(0160630),		one(0170770), "QdDs", m68000up },
{"roll",	one(0160670),		one(0170770), "DdDs", m68000up },

{"rorb",	one(0160030),		one(0170770), "QdDs", m68000up },
{"rorb",	one(0160070),		one(0170770), "DdDs", m68000up },
{"rorw",	one(0160130),		one(0170770), "QdDs", m68000up },
{"rorw",	one(0160170),		one(0170770), "DdDs", m68000up },
{"rorw",	one(0163300),		one(0177700), "~s",   m68000up },
{"rorl",	one(0160230),		one(0170770), "QdDs", m68000up },
{"rorl",	one(0160270),		one(0170770), "DdDs", m68000up },

{"roxlb",	one(0160420),		one(0170770), "QdDs", m68000up },
{"roxlb",	one(0160460),		one(0170770), "DdDs", m68000up },
{"roxlw",	one(0160520),		one(0170770), "QdDs", m68000up },
{"roxlw",	one(0160560),		one(0170770), "DdDs", m68000up },
{"roxlw",	one(0162700),		one(0177700), "~s",   m68000up },
{"roxll",	one(0160620),		one(0170770), "QdDs", m68000up },
{"roxll",	one(0160660),		one(0170770), "DdDs", m68000up },

{"roxrb",	one(0160020),		one(0170770), "QdDs", m68000up },
{"roxrb",	one(0160060),		one(0170770), "DdDs", m68000up },
{"roxrw",	one(0160120),		one(0170770), "QdDs", m68000up },
{"roxrw",	one(0160160),		one(0170770), "DdDs", m68000up },
{"roxrw",	one(0162300),		one(0177700), "~s",   m68000up },
{"roxrl",	one(0160220),		one(0170770), "QdDs", m68000up },
{"roxrl",	one(0160260),		one(0170770), "DdDs", m68000up },

{"rtd",		one(0047164),		one(0177777), "#w", m68010up },

{"rte",		one(0047163),		one(0177777), "",   m68000up | mcf },

{"rtm",		one(0003300),		one(0177760), "Rs", m68020 },

{"rtr",		one(0047167),		one(0177777), "",   m68000up },

{"rts",		one(0047165),		one(0177777), "",   m68000up | mcf },

{"satsl",	one(0046200),		one(0177770), "Ds", mcf5407 },

{"sbcd",	one(0100400),		one(0170770), "DsDd", m68000up },
{"sbcd",	one(0100410),		one(0170770), "-s-d", m68000up },

{"scc",		one(0052300),	one(0177700), "$s", m68000up },
{"scc",		one(0052300),	one(0177700), "Ds", mcf },
{"scs",		one(0052700),	one(0177700), "$s", m68000up },
{"scs",		one(0052700),	one(0177700), "Ds", mcf },
{"seq",		one(0053700),	one(0177700), "$s", m68000up },
{"seq",		one(0053700),	one(0177700), "Ds", mcf },
{"sf",		one(0050700),	one(0177700), "$s", m68000up },
{"sf",		one(0050700),	one(0177700), "Ds", mcf },
{"sge",		one(0056300),	one(0177700), "$s", m68000up },
{"sge",		one(0056300),	one(0177700), "Ds", mcf },
{"sgt",		one(0057300),	one(0177700), "$s", m68000up },
{"sgt",		one(0057300),	one(0177700), "Ds", mcf },
{"shi",		one(0051300),	one(0177700), "$s", m68000up },
{"shi",		one(0051300),	one(0177700), "Ds", mcf },
{"sle",		one(0057700),	one(0177700), "$s", m68000up },
{"sle",		one(0057700),	one(0177700), "Ds", mcf },
{"sls",		one(0051700),	one(0177700), "$s", m68000up },
{"sls",		one(0051700),	one(0177700), "Ds", mcf },
{"slt",		one(0056700),	one(0177700), "$s", m68000up },
{"slt",		one(0056700),	one(0177700), "Ds", mcf },
{"smi",		one(0055700),	one(0177700), "$s", m68000up },
{"smi",		one(0055700),	one(0177700), "Ds", mcf },
{"sne",		one(0053300),	one(0177700), "$s", m68000up },
{"sne",		one(0053300),	one(0177700), "Ds", mcf },
{"spl",		one(0055300),	one(0177700), "$s", m68000up },
{"spl",		one(0055300),	one(0177700), "Ds", mcf },
{"st",		one(0050300),	one(0177700), "$s", m68000up },
{"st",		one(0050300),	one(0177700), "Ds", mcf },
{"svc",		one(0054300),	one(0177700), "$s", m68000up },
{"svc",		one(0054300),	one(0177700), "Ds", mcf },
{"svs",		one(0054700),	one(0177700), "$s", m68000up },
{"svs",		one(0054700),	one(0177700), "Ds", mcf },

{"stop",	one(0047162),	one(0177777), "#w", m68000up | mcf },

{"subal",	one(0110700),	one(0170700), "*lAd", m68000up | mcf },
{"subaw",	one(0110300),	one(0170700), "*wAd", m68000up },

{"subib",	one(0002000),	one(0177700), "#b$s", m68000up },
{"subiw",	one(0002100),	one(0177700), "#w$s", m68000up },
{"subil",	one(0002200),	one(0177700), "#l$s", m68000up },
{"subil",	one(0002200),	one(0177700), "#lDs", mcf },

{"subqb",	one(0050400),	one(0170700), "Qd%s", m68000up },
{"subqw",	one(0050500),	one(0170700), "Qd%s", m68000up },
{"subql",	one(0050600),	one(0170700), "Qd%s", m68000up | mcf },

/* The sub opcode can generate the suba, subi, and subq instructions.  */
{"subb",	one(0050400),	one(0170700), "Qd%s", m68000up },
{"subb",	one(0002000),	one(0177700), "#b$s", m68000up },
{"subb",	one(0110000),	one(0170700), ";bDd", m68000up },
{"subb",	one(0110400),	one(0170700), "Dd~s", m68000up },
{"subw",	one(0050500),	one(0170700), "Qd%s", m68000up },
{"subw",	one(0002100),	one(0177700), "#w$s", m68000up },
{"subw",	one(0110300),	one(0170700), "*wAd", m68000up },
{"subw",	one(0110100),	one(0170700), "*wDd", m68000up },
{"subw",	one(0110500),	one(0170700), "Dd~s", m68000up },
{"subl",	one(0050600),	one(0170700), "Qd%s", m68000up | mcf },
{"subl",	one(0002200),	one(0177700), "#l$s", m68000up },
{"subl",	one(0002200),	one(0177700), "#lDs", mcf },
{"subl",	one(0110700),	one(0170700), "*lAd", m68000up | mcf },
{"subl",	one(0110200),	one(0170700), "*lDd", m68000up | mcf },
{"subl",	one(0110600),	one(0170700), "Dd~s", m68000up | mcf },

{"subxb",	one(0110400),	one(0170770), "DsDd", m68000up },
{"subxb",	one(0110410),	one(0170770), "-s-d", m68000up },
{"subxw",	one(0110500),	one(0170770), "DsDd", m68000up },
{"subxw",	one(0110510),	one(0170770), "-s-d", m68000up },
{"subxl",	one(0110600),	one(0170770), "DsDd", m68000up | mcf },
{"subxl",	one(0110610),	one(0170770), "-s-d", m68000up },

{"swap",	one(0044100),	one(0177770), "Ds", m68000up | mcf },

/* swbeg and swbegl are magic constants used on sysV68.  The compiler
   generates them before a switch table.  They tell the debugger and
   disassembler that a switch table follows.  The parameter is the
   number of elements in the table.  swbeg means that the entries in
   the table are word (2 byte) sized, and swbegl means that the
   entries in the table are longword (4 byte) sized.  */
{"swbeg",	one(0045374),	one(0177777), "#w",   m68000up | mcf },
{"swbegl",	one(0045375),	one(0177777), "#l",   m68000up | mcf },

{"tas",		one(0045300),	one(0177700), "$s", m68000up | mcf5407},

#define TBL1(name,signed,round,size)					\
  {name, two(0174000, (signed<<11)|(!round<<10)|(size<<6)|0000400),	\
     two(0177700,0107777), "!sD1", cpu32 },				\
  {name, two(0174000, (signed<<11)|(!round<<10)|(size<<6)),		\
     two(0177770,0107770), "DsD3D1", cpu32 }
#define TBL(name1, name2, name3, s, r) \
  TBL1(name1, s, r, 0), TBL1(name2, s, r, 1), TBL1(name3, s, r, 2)
TBL("tblsb", "tblsw", "tblsl", 1, 1),
TBL("tblsnb", "tblsnw", "tblsnl", 1, 0),
TBL("tblub", "tbluw", "tblul", 0, 1),
TBL("tblunb", "tblunw", "tblunl", 0, 0),

{"trap",	one(0047100),	one(0177760), "Ts", m68000up | mcf },

{"trapcc",	one(0052374),	one(0177777), "", m68020up | cpu32 },
{"trapcs",	one(0052774),	one(0177777), "", m68020up | cpu32 },
{"trapeq",	one(0053774),	one(0177777), "", m68020up | cpu32 },
{"trapf",	one(0050774),	one(0177777), "", m68020up | cpu32 | mcf },
{"trapge",	one(0056374),	one(0177777), "", m68020up | cpu32 },
{"trapgt",	one(0057374),	one(0177777), "", m68020up | cpu32 },
{"traphi",	one(0051374),	one(0177777), "", m68020up | cpu32 },
{"traple",	one(0057774),	one(0177777), "", m68020up | cpu32 },
{"trapls",	one(0051774),	one(0177777), "", m68020up | cpu32 },
{"traplt",	one(0056774),	one(0177777), "", m68020up | cpu32 },
{"trapmi",	one(0055774),	one(0177777), "", m68020up | cpu32 },
{"trapne",	one(0053374),	one(0177777), "", m68020up | cpu32 },
{"trappl",	one(0055374),	one(0177777), "", m68020up | cpu32 },
{"trapt",	one(0050374),	one(0177777), "", m68020up | cpu32 },
{"trapvc",	one(0054374),	one(0177777), "", m68020up | cpu32 },
{"trapvs",	one(0054774),	one(0177777), "", m68020up | cpu32 },

{"trapccw",	one(0052372),	one(0177777), "#w", m68020up|cpu32 },
{"trapcsw",	one(0052772),	one(0177777), "#w", m68020up|cpu32 },
{"trapeqw",	one(0053772),	one(0177777), "#w", m68020up|cpu32 },
{"trapfw",	one(0050772),	one(0177777), "#w", m68020up|cpu32|mcf},
{"trapgew",	one(0056372),	one(0177777), "#w", m68020up|cpu32 },
{"trapgtw",	one(0057372),	one(0177777), "#w", m68020up|cpu32 },
{"traphiw",	one(0051372),	one(0177777), "#w", m68020up|cpu32 },
{"traplew",	one(0057772),	one(0177777), "#w", m68020up|cpu32 },
{"traplsw",	one(0051772),	one(0177777), "#w", m68020up|cpu32 },
{"trapltw",	one(0056772),	one(0177777), "#w", m68020up|cpu32 },
{"trapmiw",	one(0055772),	one(0177777), "#w", m68020up|cpu32 },
{"trapnew",	one(0053372),	one(0177777), "#w", m68020up|cpu32 },
{"trapplw",	one(0055372),	one(0177777), "#w", m68020up|cpu32 },
{"traptw",	one(0050372),	one(0177777), "#w", m68020up|cpu32 },
{"trapvcw",	one(0054372),	one(0177777), "#w", m68020up|cpu32 },
{"trapvsw",	one(0054772),	one(0177777), "#w", m68020up|cpu32 },

{"trapccl",	one(0052373),	one(0177777), "#l", m68020up|cpu32 },
{"trapcsl",	one(0052773),	one(0177777), "#l", m68020up|cpu32 },
{"trapeql",	one(0053773),	one(0177777), "#l", m68020up|cpu32 },
{"trapfl",	one(0050773),	one(0177777), "#l", m68020up|cpu32|mcf},
{"trapgel",	one(0056373),	one(0177777), "#l", m68020up|cpu32 },
{"trapgtl",	one(0057373),	one(0177777), "#l", m68020up|cpu32 },
{"traphil",	one(0051373),	one(0177777), "#l", m68020up|cpu32 },
{"traplel",	one(0057773),	one(0177777), "#l", m68020up|cpu32 },
{"traplsl",	one(0051773),	one(0177777), "#l", m68020up|cpu32 },
{"trapltl",	one(0056773),	one(0177777), "#l", m68020up|cpu32 },
{"trapmil",	one(0055773),	one(0177777), "#l", m68020up|cpu32 },
{"trapnel",	one(0053373),	one(0177777), "#l", m68020up|cpu32 },
{"trappll",	one(0055373),	one(0177777), "#l", m68020up|cpu32 },
{"traptl",	one(0050373),	one(0177777), "#l", m68020up|cpu32 },
{"trapvcl",	one(0054373),	one(0177777), "#l", m68020up|cpu32 },
{"trapvsl",	one(0054773),	one(0177777), "#l", m68020up|cpu32 },

{"trapv",	one(0047166),	one(0177777), "", m68000up },

{"tstb",	one(0045000),	one(0177700), ";b", m68020up|cpu32|mcf },
{"tstb",	one(0045000),	one(0177700), "$b", m68000up },
{"tstw",	one(0045100),	one(0177700), "*w", m68020up|cpu32|mcf },
{"tstw",	one(0045100),	one(0177700), "$w", m68000up },
{"tstl",	one(0045200),	one(0177700), "*l", m68020up|cpu32|mcf },
{"tstl",	one(0045200),	one(0177700), "$l", m68000up },

{"unlk",	one(0047130),	one(0177770), "As", m68000up | mcf },

{"unpk",	one(0100600),	one(0170770), "DsDd#w", m68020up },
{"unpk",	one(0100610),	one(0170770), "-s-d#w", m68020up },

{"wddatab",	one(0175400),   one(0177700), "~s", mcf },
{"wddataw",	one(0175500),   one(0177700), "~s", mcf },
{"wddatal",	one(0175600),   one(0177700), "~s", mcf },

{"wdebug",	two(0175720, 03),	two(0177770, 0xffff), "as", mcf },
{"wdebug",	two(0175750, 03),	two(0177770, 0xffff), "ds", mcf },
};

const int m68k_numopcodes = sizeof m68k_opcodes / sizeof m68k_opcodes[0];

/* These aliases used to be in the above table, each one duplicating
   all of the entries for its primary exactly.  This table was
   constructed by mechanical processing of the opcode table, with a
   small number of tweaks done by hand.  There are probably a lot more
   aliases above that could be moved down here, except for very minor
   differences.  */

const struct m68k_opcode_alias m68k_opcode_aliases[] =
{
  { "add",	"addw", },
  { "adda",	"addaw", },
  { "addi",	"addiw", },
  { "addq",	"addqw", },
  { "addx",	"addxw", },
  { "asl",	"aslw", },
  { "asr",	"asrw", },
  { "bhi",	"bhiw", },
  { "bls",	"blsw", },
  { "bcc",	"bccw", },
  { "bcs",	"bcsw", },
  { "bne",	"bnew", },
  { "beq",	"beqw", },
  { "bvc",	"bvcw", },
  { "bvs",	"bvsw", },
  { "bpl",	"bplw", },
  { "bmi",	"bmiw", },
  { "bge",	"bgew", },
  { "blt",	"bltw", },
  { "bgt",	"bgtw", },
  { "ble",	"blew", },
  { "bra",	"braw", },
  { "bsr",	"bsrw", },
  { "bhib",	"bhis", },
  { "blsb",	"blss", },
  { "bccb",	"bccs", },
  { "bcsb",	"bcss", },
  { "bneb",	"bnes", },
  { "beqb",	"beqs", },
  { "bvcb",	"bvcs", },
  { "bvsb",	"bvss", },
  { "bplb",	"bpls", },
  { "bmib",	"bmis", },
  { "bgeb",	"bges", },
  { "bltb",	"blts", },
  { "bgtb",	"bgts", },
  { "bleb",	"bles", },
  { "brab",	"bras", },
  { "bsrb",	"bsrs", },
  { "bhs",	"bccw" },
  { "bhss",	"bccs" },
  { "bhsb",	"bccs" },
  { "bhsw",	"bccw" },
  { "bhsl",	"bccl" },
  { "blo",	"bcsw" },
  { "blos",	"bcss" },
  { "blob",	"bcss" },
  { "blow",	"bcsw" },
  { "blol",	"bcsl" },
  { "br",	"braw", },
  { "brs",	"bras", },
  { "brb",	"bras", },
  { "brw",	"braw", },
  { "brl",	"bral", },
  { "jfnlt",	"bcc", },	/* apparently a sun alias */
  { "jfngt",	"ble", },	/* apparently a sun alias */
  { "jfeq",	"beqs", },	/* apparently a sun alias */
  { "bchgb",	"bchg", },
  { "bchgl",	"bchg", },
  { "bclrb",	"bclr", },
  { "bclrl",	"bclr", },
  { "bsetb",	"bset", },
  { "bsetl",	"bset", },
  { "btstb",	"btst", },
  { "btstl",	"btst", },
  { "cas2",	"cas2w", },
  { "cas",	"casw", },
  { "chk2",	"chk2w", },
  { "chk",	"chkw", },
  { "clr",	"clrw", },
  { "cmp2",	"cmp2w", },
  { "cmpa",	"cmpaw", },
  { "cmpi",	"cmpiw", },
  { "cmpm",	"cmpmw", },
  { "cmp",	"cmpw", },
  { "dbccw",	"dbcc", },
  { "dbcsw",	"dbcs", },
  { "dbeqw",	"dbeq", },
  { "dbfw",	"dbf", },
  { "dbgew",	"dbge", },
  { "dbgtw",	"dbgt", },
  { "dbhiw",	"dbhi", },
  { "dblew",	"dble", },
  { "dblsw",	"dbls", },
  { "dbltw",	"dblt", },
  { "dbmiw",	"dbmi", },
  { "dbnew",	"dbne", },
  { "dbplw",	"dbpl", },
  { "dbtw",	"dbt", },
  { "dbvcw",	"dbvc", },
  { "dbvsw",	"dbvs", },
  { "dbhs",	"dbcc", },
  { "dbhsw",	"dbcc", },
  { "dbra",	"dbf", },
  { "dbraw",	"dbf", },
  { "tdivsl",	"divsl", },
  { "divs",	"divsw", },
  { "divu",	"divuw", },
  { "ext",	"extw", },
  { "extbw",	"extw", },
  { "extwl",	"extl", },
  { "fbneq",	"fbne", },
  { "fbsneq",	"fbsne", },
  { "fdbneq",	"fdbne", },
  { "fdbsneq",	"fdbsne", },
  { "fmovecr",	"fmovecrx", },
  { "fmovm",	"fmovem", },
  { "fsneq",	"fsne", },
  { "fssneq",	"fssne", },
  { "ftrapneq",	"ftrapne", },
  { "ftrapsneq", "ftrapsne", },
  { "fjneq",	"fjne", },
  { "fjsneq",	"fjsne", },
  { "jmpl",	"jmp", },
  { "jmps",	"jmp", },
  { "jsrl",	"jsr", },
  { "jsrs",	"jsr", },
  { "leal",	"lea", },
  { "lsl",	"lslw", },
  { "lsr",	"lsrw", },
  { "mac",	"macw" },
  { "movea",	"moveaw", },
  { "movem",	"movemw", },
  { "movml",	"moveml", },
  { "movmw",	"movemw", },
  { "movm",	"movemw", },
  { "movep",	"movepw", },
  { "movpw",	"movepw", },
  { "moves",	"movesw" },
  { "muls",	"mulsw", },
  { "mulu",	"muluw", },
  { "msac",	"msacw" },
  { "nbcdb",	"nbcd" },
  { "neg",	"negw", },
  { "negx",	"negxw", },
  { "not",	"notw", },
  { "peal",	"pea", },
  { "rol",	"rolw", },
  { "ror",	"rorw", },
  { "roxl",	"roxlw", },
  { "roxr",	"roxrw", },
  { "sats",	"satsl", },
  { "sbcdb",	"sbcd", },
  { "sccb",	"scc", },
  { "scsb",	"scs", },
  { "seqb",	"seq", },
  { "sfb",	"sf", },
  { "sgeb",	"sge", },
  { "sgtb",	"sgt", },
  { "shib",	"shi", },
  { "sleb",	"sle", },
  { "slsb",	"sls", },
  { "sltb",	"slt", },
  { "smib",	"smi", },
  { "sneb",	"sne", },
  { "splb",	"spl", },
  { "stb",	"st", },
  { "svcb",	"svc", },
  { "svsb",	"svs", },
  { "sfge",	"sge", },
  { "sfgt",	"sgt", },
  { "sfle",	"sle", },
  { "sflt",	"slt", },
  { "sfneq",	"sne", },
  { "suba",	"subaw", },
  { "subi",	"subiw", },
  { "subq",	"subqw", },
  { "sub",	"subw", },
  { "subx",	"subxw", },
  { "swapw",	"swap", },
  { "tasb",	"tas", },
  { "tpcc",	"trapcc", },
  { "tcc",	"trapcc", },
  { "tst",	"tstw", },
  { "jbra",	"jra", },
  { "jbhi",	"jhi", },
  { "jbls",	"jls", },
  { "jbcc",	"jcc", },
  { "jbcs",	"jcs", },
  { "jbne",	"jne", },
  { "jbeq",	"jeq", },
  { "jbvc",	"jvc", },
  { "jbvs",	"jvs", },
  { "jbpl",	"jpl", },
  { "jbmi",	"jmi", },
  { "jbge",	"jge", },
  { "jblt",	"jlt", },
  { "jbgt",	"jgt", },
  { "jble",	"jle", },
  { "movql",	"moveq", },
  { "moveql",	"moveq", },
  { "movl",	"movel", },
  { "movq",	"moveq", },
  { "moval",	"moveal", },
  { "movaw",	"moveaw", },
  { "movb",	"moveb", },
  { "movc",	"movec", },
  { "movecl",	"movec", },
  { "movpl",	"movepl", },
  { "movw",	"movew", },
  { "movsb",	"movesb", },
  { "movsl",	"movesl", },
  { "movsw",	"movesw", },
  { "mov3q",	"mov3ql", },

  { "tdivul",	"divul", },	/* for m68k-svr4 */
  { "fmovb",	"fmoveb", },
  { "fsmovb",	"fsmoveb", },
  { "fdmovb",	"fdmoveb", },
  { "fmovd",	"fmoved", },
  { "fsmovd",	"fsmoved", },
  { "fmovl",	"fmovel", },
  { "fsmovl",	"fsmovel", },
  { "fdmovl",	"fdmovel", },
  { "fmovp",	"fmovep", },
  { "fsmovp",	"fsmovep", },
  { "fdmovp",	"fdmovep", },
  { "fmovs",	"fmoves", },
  { "fsmovs",	"fsmoves", },
  { "fdmovs",	"fdmoves", },
  { "fmovw",	"fmovew", },
  { "fsmovw",	"fsmovew", },
  { "fdmovw",	"fdmovew", },
  { "fmovx",	"fmovex", },
  { "fsmovx",	"fsmovex", },
  { "fdmovx",	"fdmovex", },
  { "fmovcr",	"fmovecr", },
  { "fmovcrx",	"fmovecrx", },
  { "ftestb",	"ftstb", },
  { "ftestd",	"ftstd", },
  { "ftestl",	"ftstl", },
  { "ftestp",	"ftstp", },
  { "ftests",	"ftsts", },
  { "ftestw",	"ftstw", },
  { "ftestx",	"ftstx", },
};

const int m68k_numaliases =
  sizeof m68k_opcode_aliases / sizeof m68k_opcode_aliases[0];
