/*
 * tools/lib/pv_read_already_red.c
 *
 * Copyright (C) 1997 - 2001  Heinz Mauelshagen, Sistina Software
 *
 * March-May,October-November 1997
 * May,August,November 1998
 * September 1999
 * January 2000
 * April 2001
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    29/10/1999 - fixed possible free() bug
 *    31/01/2000 - use debug_enter()/debug_leave()
 *    09/04/2001 - cleaned up debug output (Andreas Dilger)
 *
 */

#include <liblvm.h>


int pv_read_already_red ( char *pv_name) {
   int i = 0;
   int ret = FALSE;
   static int pv_count = 0;
   static char* pv_name_cache = NULL;
   char* pv_name_cache_sav = NULL;

   debug_enter ( "pv_read_already_red -- CALLED with PV %s\n", pv_name);

   if ( pv_name == 0 || strlen ( pv_name) > NAME_LEN - 1) ret = FALSE;
   else {
      for ( i = 0; i < pv_count; i++) {
         if ( strcmp ( pv_name, &pv_name_cache[i*NAME_LEN]) == 0) {
            ret = TRUE;
            goto pv_read_already_red_end;
         }
      }
   
      pv_name_cache_sav = pv_name_cache;
      if ( ( pv_name_cache = realloc ( pv_name_cache,
                                       ( pv_count + 1) * NAME_LEN)) == NULL) {
         fprintf ( stderr, "realloc error in %s [line %d]\n",
                           __FILE__, __LINE__);
         if ( pv_name_cache_sav != NULL) free ( pv_name_cache_sav);
         ret = FALSE;
         goto pv_read_already_red_end;
      }
   
      memset ( &pv_name_cache[pv_count * NAME_LEN], 0, NAME_LEN);
      strcpy ( &pv_name_cache[pv_count * NAME_LEN], pv_name);
      pv_count++;
   }

pv_read_already_red_end:

   debug_leave ( "pv_read_already_red -- LEAVING with ret: %d\n", ret);
   return ret;
}
