/*
  Copyright (C) 2004 Paul Mackerras <paulus@samba.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307, USA.

  The GNU General Public License is contained in the file COPYING.
*/
#include "core_asm.h"

	.globl VG_(helper_undefined_instruction)
VG_(helper_undefined_instruction):
1:	.long	0
	b	1b

	.globl VG_(load_vec_state)
VG_(load_vec_state):
	/* Here r3 contains the pointer to the thread state */
	addi	3,3,VGOFF_vr
	li	4,512
	lvx	0,4,3
	mtvscr	0
	lvx	0,0,3
	li	4,16
	lvx	1,4,3
	li	4,32
	lvx	2,4,3
	li	4,48
	lvx	3,4,3
	li	4,64
	lvx	4,4,3
	li	4,80
	lvx	5,4,3
	li	4,96
	lvx	6,4,3
	li	4,112
	lvx	7,4,3
	li	4,128
	lvx	8,4,3
	li	4,144
	lvx	9,4,3
	li	4,160
	lvx	10,4,3
	li	4,176
	lvx	11,4,3
	li	4,192
	lvx	12,4,3
	li	4,208
	lvx	13,4,3
	li	4,224
	lvx	14,4,3
	li	4,240
	lvx	15,4,3
	li	4,256
	lvx	16,4,3
	li	4,272
	lvx	17,4,3
	li	4,288
	lvx	18,4,3
	li	4,304
	lvx	19,4,3
	li	4,320
	lvx	20,4,3
	li	4,336
	lvx	21,4,3
	li	4,352
	lvx	22,4,3
	li	4,368
	lvx	23,4,3
	li	4,384
	lvx	24,4,3
	li	4,400
	lvx	25,4,3
	li	4,416
	lvx	26,4,3
	li	4,432
	lvx	27,4,3
	li	4,448
	lvx	28,4,3
	li	4,464
	lvx	29,4,3
	li	4,480
	lvx	30,4,3
	li	4,496
	lvx	31,4,3
	lwz	4,512(3)
	mtvrsave 4
	li	0,1
	stb	0,VGOFF_vr_live-VGOFF_vr(3)
	blr

	.globl	VG_(save_vec_state)
VG_(save_vec_state):
	/* Save the vector state in the thread state pointed to by r3 */
	addi	3,3,VGOFF_vr
	stvx	0,0,3
	li	4,16
	stvx	1,4,3
	li	4,32
	stvx	2,4,3
	li	4,48
	stvx	3,4,3
	li	4,64
	stvx	4,4,3
	li	4,80
	stvx	5,4,3
	li	4,96
	stvx	6,4,3
	li	4,112
	stvx	7,4,3
	li	4,128
	stvx	8,4,3
	li	4,144
	stvx	9,4,3
	li	4,160
	stvx	10,4,3
	li	4,176
	stvx	11,4,3
	li	4,192
	stvx	12,4,3
	li	4,208
	stvx	13,4,3
	li	4,224
	stvx	14,4,3
	li	4,240
	stvx	15,4,3
	li	4,256
	stvx	16,4,3
	li	4,272
	stvx	17,4,3
	li	4,288
	stvx	18,4,3
	li	4,304
	stvx	19,4,3
	li	4,320
	stvx	20,4,3
	li	4,336
	stvx	21,4,3
	li	4,352
	stvx	22,4,3
	li	4,368
	stvx	23,4,3
	li	4,384
	stvx	24,4,3
	li	4,400
	stvx	25,4,3
	li	4,416
	stvx	26,4,3
	li	4,432
	stvx	27,4,3
	li	4,448
	stvx	28,4,3
	li	4,464
	stvx	29,4,3
	li	4,480
	stvx	30,4,3
	li	4,496
	stvx	31,4,3
	li	4,512
	mfvscr	0
	stvx	0,4,3
	mfvrsave 4
	stw	4,512(3)
	li	0,0
	stb	0,VGOFF_vr_live-VGOFF_vr(3)
	blr
