/* Help-related definitions for Xconq.
   Copyright (C) 1991, 1992, 1993, 1994, 1996, 1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

enum nodeclass {
    miscnode,
    utypenode,
    mtypenode,
    ttypenode,
    atypenode
};

#include "obstack.h"

typedef struct a_textbuffer {
    char *text;
    int bufmax;
    struct obstack ostack;
} TextBuffer;

typedef struct a_helpnode {
    char *key;
    void (*fn) PARAMS ((int arg, char *key, TextBuffer *buf));
    enum nodeclass nclass;
    int arg;
    char *text;
    int textend;
    struct a_helpnode *prev;
    struct a_helpnode *next;
} HelpNode;

extern void tbprintf PARAMS ((TextBuffer *buf, char *str, ...));
extern void tbcat PARAMS ((TextBuffer *buf, char *str));

extern HelpNode *first_help_node;

extern HelpNode *copying_help_node;
extern HelpNode *warranty_help_node;

extern void init_help PARAMS ((void));
extern HelpNode *create_help_node PARAMS ((void));
extern HelpNode *add_help_node PARAMS ((char *key, void (*fn)(int, char *, TextBuffer *), int arg, HelpNode *prevnode));
extern HelpNode *find_help_node PARAMS ((HelpNode *node, char *str));
extern void create_game_help_nodes PARAMS ((void));
extern char *get_help_text PARAMS ((HelpNode *node));

extern void describe_topics PARAMS ((int arg, char *key, TextBuffer *buf));
extern void describe_command PARAMS ((int ch, char *name, char *help, int onechar, TextBuffer *buf));
extern void notify_instructions PARAMS ((void));

extern void print_any_news PARAMS ((void));
extern void print_game_description_to_file PARAMS ((FILE *fp));

extern void describe_copyright PARAMS ((int arg, char *key, TextBuffer *buf));
extern void describe_warranty PARAMS ((int arg, char *key, TextBuffer *buf));
