# tcl/tk browser for Xconq image families.
# Copyright (C) 1998 Stanley T. Shebs.

# Xconq is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.  See the file COPYING.

set showcolor 1
set shownames 1
set showmasks 1
set bgcolor gray

wm title . imftk

menu .menubar
. configure -menu .menubar

.menubar add cascade -label File -menu .menubar.file
menu .menubar.file
.menubar.file add command -label New \
	-command { new_images }
.menubar.file add command -label "Open Imf Dir..." -state disabled
.menubar.file add command -label "Add Imf File..." \
	-command { add_imf_file }
.menubar.file add command -label "Save Imf Dir..." -state disabled
.menubar.file add command -label "Save Imf File..." -state disabled
.menubar.file add command -label Quit \
	-command { exit }

.menubar add cascade -label View -menu .menubar.view
menu .menubar.view
.menubar.view add command -label 8x8 \
	-command { .images.content config -iwidth 8 -iheight 8 }
.menubar.view add command -label 16x16 \
	-command { .images.content config -iwidth 16 -iheight 16 }
.menubar.view add command -label 32x32 \
	-command { .images.content config -iwidth 32 -iheight 32 }
.menubar.view add command -label 64x64 \
	-command { .images.content config -iwidth 64 -iheight 64 }
.menubar.view add separator
.menubar.view add check -label Color -variable showcolor \
	-command toggle_show_color
.menubar.view add check -label Names -variable shownames \
	-command toggle_show_names
.menubar.view add check -label Masks -variable showmasks \
	-command toggle_show_masks
.menubar.view add cascade -label Background -menu .menubar.view.bg
menu .menubar.view.bg
.menubar.view.bg add radio -label black -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label gray -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label white -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label red -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label green -variable bgcolor \
	-command { .images.content config -bg $bgcolor }
.menubar.view.bg add radio -label blue -variable bgcolor \
	-command { .images.content config -bg $bgcolor }

frame .closeup -borderwidth 2 -relief sunken
pack .closeup -side top -fill x

canvas .closeup.content -height 170
pack .closeup.content -side top -fill both

.closeup.content create text 10 20 -tag selname -text "(nothing selected)" -anchor sw

set winbgcolor [ .closeup.content cget -background ]

set sy 30
.closeup.content create line 0 $sy 500 $sy -tag line1 -fill gray
incr sy 3
imfsample .closeup.content.line1 -bg $winbgcolor -width 8 -height 8 -iwidth 8 -iheight 8
.closeup.content create window 2 $sy -window .closeup.content.line1 -anchor nw
incr sy [ expr 8 + 2 ]
.closeup.content create line 0 $sy 500 $sy -tag line2 -fill gray
incr sy 3
imfsample .closeup.content.line2 -bg $winbgcolor -width 16 -height 16 -iwidth 16 -iheight 16
.closeup.content create window 2 $sy -window .closeup.content.line2 -anchor nw
incr sy [ expr 16 + 2 ]
.closeup.content create line 0 $sy 500 $sy -tag line3 -fill gray
incr sy 3
imfsample .closeup.content.line3 -bg $winbgcolor -width 32 -height 32 -iwidth 32 -iheight 32
.closeup.content create window 2 $sy -window .closeup.content.line3 -anchor nw
incr sy [ expr 32 + 2 ]
.closeup.content create line 0 $sy 500 $sy -tag line4 -fill gray
incr sy 3
imfsample .closeup.content.line4 -bg $winbgcolor -width 64 -height 64 -iwidth 64 -iheight 64
.closeup.content create window 2 $sy -window .closeup.content.line4 -anchor nw

frame .images -width 500 -height 300
pack .images -side top -fill both -expand true
pack propagate .images false

imfsample .images.content -pad 2 \
	-showcolor $showcolor -showmasks $showmasks -bg $bgcolor

scrollbar .images.scroll -command { .images.content yview }
pack .images.scroll -side right -fill y
pack .images.content -side left -fill both -expand true

bind .images.content <ButtonRelease-1> { select_imf %x %y }

proc set_initial_view {} {
#    .menubar.count config -text [ get_imf_status ]
}

proc new_images {} {
}

proc open_imf_dir {} {
}

proc add_imf_file {} {
    set filename [ get_string ".imf file to add" ]
    if { $filename != {} } {
	load_imf_file $filename
#	.menubar.count config -text [ get_imf_status ]
    }
}

proc save_imf_dir {} {
}

proc save_imf_file {} {
}

proc toggle_show_color {} {
    global showcolor

    .images.content config -showcolor $showcolor
}

proc toggle_show_names {} {
    global shownames

    .images.content config -shownames $shownames
}

proc toggle_show_masks {} {
    global showmasks

    .images.content config -showmasks $showmasks
}

proc select_imf { x y } {
    .images.content select $x $y
    set n [ .images.content curselection ]
    if { $n >= 0 } {
	set header "[ get_imf_name $n ] ([ get_imf_numsizes $n ] images)" 
	.closeup.content.line1 replace imf [ get_imf_name $n ]
	.closeup.content.line2 replace imf [ get_imf_name $n ]
	.closeup.content.line3 replace imf [ get_imf_name $n ]
	.closeup.content.line4 replace imf [ get_imf_name $n ]
    } else {
	set header "(nothing selected)"
    }
    .closeup.content itemconfigure selname -text $header
}

proc get_string { hint } {
    global prompt

    set f [toplevel .getstring -bd 10]
    label $f.label -text $hint
    entry $f.entry -textvariable prompt(result)
    set b [frame $f.buttons -bd 10]
    pack $f.label $f.entry $f.buttons -side top -fill x
    button $b.ok -text "OK" -command { set prompt(ok) 1 }
    button $b.cancel -text "Cancel" -command { set prompt(ok) 0 }
    pack $b.ok -side left
    pack $b.cancel -side right

    focus $f.entry
    grab $f
    tkwait variable prompt(ok)
    grab release $f
    destroy $f
    if { $prompt(ok) } {
	return $prompt(result)
    } else {
	return {}
    }
}
