/* Definitions of image families for the Tk interface to Xconq.
   Copyright (C) 1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

/* Structure for Tk-specific data. */

/* Note that this structure has an implicit window and therefore player. */

typedef struct a_tk_image_family {
    Tk_Window rootwin;		/* Root window of family's pixmaps */
} TkImageFamily;

typedef struct a_tk_image {
    Image *generic;		/* pointer to generic image */
    Pixmap mono;
    Pixmap colr;
    Pixmap mask;
    XColor *solid;
    XColor **cmap;
} TkImage;

extern TkImage *init_tk_image PARAMS ((Image *img));
extern TkImage *get_tk_image PARAMS ((Image *img));
extern ImageFamily *tk_load_imf PARAMS ((ImageFamily *imf));
extern ImageFamily *tk_interp_imf PARAMS ((ImageFamily *imf, Image *img,
					   int force));
extern void reverse_bit_endianness PARAMS ((char *rawdata, int numbytes));
