/* Definitions for game transport protocol.
   Copyright (C) 1996, 1997, 1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

typedef struct a_rui {
    int rid;
    int active;
} RUI;

extern int hosting;
extern int numremotes;
extern int numremotewaiting;
extern int my_rid;
extern int master_rid;
extern int tmprid;
extern int downloading;
extern int sendnow;

extern void init_remote_ui(Side *side);

extern void download_to_player(Player *player);
extern int send_packet(int id, char *buf);
extern void init_file_port(int willhost);
extern void low_file_send(int id, char *buf);

extern void send_game_checksum(int rid);
extern void broadcast_game_checksum(void);
extern void send_version(int rid);
extern int send_join(char *str);
extern void send_assignment(int id, Side *side, Player *player);
extern void send_id(int id);
extern void send_randstate(int id);
extern void broadcast_next_action(Unit *unit);
extern void send_quit(void);
extern void close_file_port(void);
extern void receive_data(int timeout);
extern void receive_packet(int id, char *buf);
extern int low_file_receive(int *id, char *buf, int maxchars, int timeout);
extern void flush_outgoing_queue(void);

extern void add_remote_program(int rid, char *name);
extern void add_remote_locally(int rid, char *str);
extern void add_remote_players(void);
extern void download_game_module(int rid);
extern void broadcast_game_module(void);
extern void broadcast_variants_chosen(void);
extern void broadcast_players_assigned(void);
extern void send_remote_id(int rid);
extern void net_send_chat(int rid, char *str);
extern void send_chat(int rid, char *str);

extern void init_file_port(int willhost);
extern void low_file_send(int rid, char *buf);
