/***************************************************************************
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULE_H
#define IPTRULE_H

#include "netfilterobject.h"

#include <tqptrlist.h>
#include <tqdict.h>

#include <tdemacros.h>

// Project Includes
#include "iptruleoption.h" 
/**
  *@author Christian Hubinger
  */

class TQString;

namespace KMF {

class IPTChain;
class IPTable;
class KMFError;
class KMFCheckInput;
/** This class represents one "Rule" in the ruleset needed to settup
		the firewall those rule look like: $IPT -A CHAINNAME [ OPTIONS ] -j TARGET [ OPTIONS ]
*/

class TDE_EXPORT IPTRule : public NetfilterObject {
public:
	
	/** The only constructor that sets the name,chain,target and table. */
	IPTRule( IPTChain* chain, const char *objectname , const TQString& name , const TQString& target );
	~IPTRule();
	
	virtual int type();
	virtual void clear();
	
	/** Sets the name of the rule to name.
		This name is displayed in the Document View */
	KMFError* setRuleName( const TQString& name ); 

	/** Sets the chain for which this Rule applies */
	void setChain( IPTChain* chain ); 

	/**  Sets the Target for the Rule */
	void setTarget( const TQString& target );

	/** Sets the Table of the rule to table */
	void setTable( IPTable* table ); // FIXME: set IPTable to use default="filter"

	/** Enable/Disable cmd line generation for this rule */
	void setEnabled( bool on );

	/** Return true if the Rule is enabled; else returns false */
	bool enabled() const {
		return m_enabled;
	};

	/** Enable/Disable logging rule for this rule */
	void setLogging( bool on );

	/** Return true if the rule logging is turend on; 
		else returns false */
	bool logging() const {
		return m_log_rule;
	};

	/** Addes a ruleoption defined the a string optionname
		e.g. "ip_opt" "state" and the strings needed to define
		all options is given by the list options values of the */
	bool addRuleOption( TQString& optionname, TQPtrList<TQString>& options );


	/** Addes a rule target option defined the a string optionname
		e.g. "ip_opt" "state" and the strings needed to define
		all options is given by the list options values of the */
	bool addTargetOption( TQString& optionname, TQPtrList<TQString>& options );

	/** Returns the chain to which this rule belongs */
	IPTChain* chain() const {
		return m_chain;
	};

	/** Returns the table to which this rule belongs */
	IPTable* table() const {
		return m_table;
	};

	/** Returns a ruleoption object for this option type if it
		exists.
		If no one exists a new rule option will be created with the given type.
		If the type is invalid 0 is returned. */
	IPTRuleOption* getOptionForName( const TQString& );

	/** Returns the target of the rule */
	const TQString& target() const ;


	/** Return the rule number in it's chain */
	int ruleNum() const;

	/** Return true if this is a rule eith custom options */
	bool customRule() const {
		return m_custom_rule;
	};

	/** Set the custom rule flag */
	void setCustomRule( bool );

	/** Returns the commandline that this rule represents */
	const TQString& toString();
	
	/** Serialize the rule to a TQDomDocument */
	const TQDomDocument& getDOMTree();
	
	/** Load the rule from the TQDomDocument */
	virtual void loadXML( const TQDomDocument&, TQStringList& errors );

	/** Load rule From DomNode */
	virtual void loadXML( TQDomNode, TQStringList& errors );

	/** Creates a deep copy of the rule */
	void createRuleClone( IPTRule* );


	/** Returns List of all possible Targets for this rule */
	TQStringList availableTargets() const;

	/** Returns true if the target is the name of a chain 
		e.g the rule forwards packets to a chain */
	bool isForward() const;

private:
	/**  The chain of the rule */
	IPTChain *m_chain;

	/** The table of the rule */
	IPTable *m_table;

	/** The target of the rule */
	TQString m_target;

	KMFError *m_err;
	KMFCheckInput *m_check_input;
	TQDict<IPTRuleOption> m_options;

	bool m_enabled;
	bool m_log_rule;
	bool m_custom_rule;

	TQString opt; 
	TQString ipt_cmd; 
	TQString tab; 
	TQString ap; 
	TQString ws; 
	TQString post; 
	TQString option_cmd;
};
}
#endif
