/***************************************************************************
 *
 * tdenetman-vpnplugin.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_VPNPLUGIN_H
#define TDENETWORKMANAGER_VPNPLUGIN_H

#include <tqwidget.h>
#include <tqmap.h>

#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

#include "tdenetman-plugin.h"

#define TDENETWORKMANAGER_VPNPLUGIN "TDENetworkManager/VPNPlugin"

class TDE_EXPORT VPNConfigWidget : public TQWidget
{
	TQ_OBJECT
  
	public:
		virtual ~VPNConfigWidget();
		VPNConfigWidget(TQWidget* parent = NULL, const char* name = NULL); 

		virtual void setVPNData(TDENetworkSingleRouteConfigurationList&, TDENetworkSettingsMap&, TDENetworkSettingsMap&);
		virtual TDENetworkSettingsMap getVPNProperties();
		virtual TDENetworkSettingsMap getVPNSecrets();
		virtual TDENetworkSingleRouteConfigurationList getVPNRoutes();
		virtual bool hasChanged();
		virtual bool isValid(TQStringList&);
};

class TDE_EXPORT VPNAuthenticationWidget : public TQWidget
{
	TQ_OBJECT
  
	public:
		virtual ~VPNAuthenticationWidget();
		VPNAuthenticationWidget(TQWidget* parent = NULL, const char* name = NULL);
		
		virtual void setVPNData(TDENetworkSingleRouteConfigurationList&, TDENetworkSettingsMap&, TDENetworkSettingsMap&);
		virtual TDENetworkSettingsMap getPasswords();
		virtual void setPasswords(TDENetworkSettingsMap secrets);
		virtual bool needsUserInteraction();
};

class TDE_EXPORT VPNPlugin : public Plugin
{
	TQ_OBJECT
  
	public:
		VPNPlugin(TQObject*, const char*, const TQStringList&);
		virtual ~VPNPlugin();

		virtual VPNConfigWidget* CreateConfigWidget(TQWidget* parent = 0);
		virtual VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent = 0);
};


#endif /* TDENETWORKMANAGER_VPNPLUGIN_H */
