// This file is generated by tdeconfig_compiler from kickerSettings.kcfg.
// All changes you do to this file will be lost.

#include "kickerSettings.h"

#include <kstaticdeleter.h>

#include <kdebug.h>

class KickerSettingsPrivate
{
  public:

    // General
    bool locked;
    bool conserveSpace;
    bool transparent;
    bool useResizeHandle;
    bool showDeepButtons;
    bool menubarPanelTransparent;
    bool menubarPanelBlurred;
    bool useBackgroundTheme;
    bool colorizeBackground;
    bool rotateBackground;
    TQString backgroundTheme;
    int tintValue;
    int blurValue;
    TQColor tintColor;
    int unhideLocation;
    bool fadeOutAppletHandles;
    bool hideAppletHandles;
    bool showToolTips;
    bool showIconActivationEffect;
    TQStringList untrustedApplets;
    TQStringList untrustedExtensions;
    bool legacyKMenu;
    bool openOnHover;
    bool scrollFlipView;
    int kMenuWidth;
    int kMenuHeight;
    int kickoffFontPointSizeOffset;
    bool kickoffSearchAddressBook;
    bool kickoffDrawGeekoEye;
    int kickoffTabBarFormat;
    bool kickoffSwitchTabsOnHover;

    // menus
    int menuEntryFormat;
    bool showMenuTitles;
    bool reduceMenuDepth;
    int menuEntryHeight;
    bool showHiddenFiles;
    bool showOpenInTerminal;
    uint maxEntries2;
    bool useBookmarks;
    bool useBrowser;
    TQStringList menuExtensions;
    TQStringList recentAppsStat;
    uint numVisibleEntries;
    bool recentVsOften;
    TQStringList favorites;
    bool firstRun;
    TQStringList firstSeenApps;

    // button_tiles
    bool enableKMenuTiles;
    bool enableDesktopButtonTiles;
    bool enableURLTiles;
    bool enableBrowserTiles;
    bool enableWindowListTiles;
    TQString kMenuTile;
    TQColor kMenuTileColor;
    TQString desktopButtonTile;
    TQColor desktopButtonTileColor;
    TQString uRLTile;
    TQColor uRLTileColor;
    TQString browserTile;
    TQColor browserTileColor;
    TQString windowListTile;
    TQColor windowListTileColor;

    // KMenu
    bool useSidePixmap;
    bool useTooltip;
    bool useSearchBar;
    bool useTopSide;
    TQString leftSideTopPixmapName;
    TQString rightSideTopPixmapName;
    TQString sideTopTileName;
    TQString sidePixmapName;
    TQString sideTileName;
    bool showKMenuText;
    TQString kMenuText;
    TQString customKMenuIcon;
    TQString searchShortcut;

    // buttons
    bool showMouseOverEffects;
    bool mouseOversShowIcon;
    bool mouseOversShowText;
    int mouseOversSpeed;
    uint mouseOversShowDelay;
    uint mouseOversHideDelay;
    bool enableTileBackground;
    int iconMargin;
    int maximumTDEMenuButtonHeight;
    bool removeButtonsWhenBroken;
    TQFont buttonFont;
    TQColor buttonTextColor;

    // SearchField
    TQStringList history;
    int historyLength;
    TQStringList completionItems;
    int completionMode;

    // items
    TDEConfigSkeleton::ItemBool *itemLocked;
    TDEConfigSkeleton::ItemBool *itemConserveSpace;
    TDEConfigSkeleton::ItemBool *itemTransparent;
    TDEConfigSkeleton::ItemBool *itemUseResizeHandle;
    TDEConfigSkeleton::ItemBool *itemShowDeepButtons;
    TDEConfigSkeleton::ItemBool *itemMenubarPanelTransparent;
    TDEConfigSkeleton::ItemBool *itemMenubarPanelBlurred;
    TDEConfigSkeleton::ItemBool *itemUseBackgroundTheme;
    TDEConfigSkeleton::ItemBool *itemColorizeBackground;
    TDEConfigSkeleton::ItemBool *itemRotateBackground;
    TDEConfigSkeleton::ItemPath *itemBackgroundTheme;
    TDEConfigSkeleton::ItemInt *itemTintValue;
    TDEConfigSkeleton::ItemInt *itemBlurValue;
    TDEConfigSkeleton::ItemColor *itemTintColor;
    TDEConfigSkeleton::ItemInt *itemUnhideLocation;
    TDEConfigSkeleton::ItemBool *itemFadeOutAppletHandles;
    TDEConfigSkeleton::ItemBool *itemHideAppletHandles;
    TDEConfigSkeleton::ItemBool *itemShowToolTips;
    TDEConfigSkeleton::ItemBool *itemShowIconActivationEffect;
    TDEConfigSkeleton::ItemStringList *itemUntrustedApplets;
    TDEConfigSkeleton::ItemStringList *itemUntrustedExtensions;
    TDEConfigSkeleton::ItemBool *itemLegacyKMenu;
    TDEConfigSkeleton::ItemBool *itemOpenOnHover;
    TDEConfigSkeleton::ItemBool *itemScrollFlipView;
    TDEConfigSkeleton::ItemInt *itemKMenuWidth;
    TDEConfigSkeleton::ItemInt *itemKMenuHeight;
    TDEConfigSkeleton::ItemInt *itemKickoffFontPointSizeOffset;
    TDEConfigSkeleton::ItemBool *itemKickoffSearchAddressBook;
    TDEConfigSkeleton::ItemBool *itemKickoffDrawGeekoEye;
    TDEConfigSkeleton::ItemEnum *itemKickoffTabBarFormat;
    TDEConfigSkeleton::ItemBool *itemKickoffSwitchTabsOnHover;
    TDEConfigSkeleton::ItemEnum *itemMenuEntryFormat;
    TDEConfigSkeleton::ItemBool *itemShowMenuTitles;
    TDEConfigSkeleton::ItemBool *itemReduceMenuDepth;
    TDEConfigSkeleton::ItemInt *itemMenuEntryHeight;
    TDEConfigSkeleton::ItemBool *itemShowHiddenFiles;
    TDEConfigSkeleton::ItemBool *itemShowOpenInTerminal;
    TDEConfigSkeleton::ItemUInt *itemMaxEntries2;
    TDEConfigSkeleton::ItemBool *itemUseBookmarks;
    TDEConfigSkeleton::ItemBool *itemUseBrowser;
    TDEConfigSkeleton::ItemStringList *itemMenuExtensions;
    TDEConfigSkeleton::ItemStringList *itemRecentAppsStat;
    TDEConfigSkeleton::ItemUInt *itemNumVisibleEntries;
    TDEConfigSkeleton::ItemBool *itemRecentVsOften;
    TDEConfigSkeleton::ItemStringList *itemFavorites;
    TDEConfigSkeleton::ItemBool *itemFirstRun;
    TDEConfigSkeleton::ItemStringList *itemFirstSeenApps;
    TDEConfigSkeleton::ItemBool *itemEnableKMenuTiles;
    TDEConfigSkeleton::ItemBool *itemEnableDesktopButtonTiles;
    TDEConfigSkeleton::ItemBool *itemEnableURLTiles;
    TDEConfigSkeleton::ItemBool *itemEnableBrowserTiles;
    TDEConfigSkeleton::ItemBool *itemEnableWindowListTiles;
    TDEConfigSkeleton::ItemPath *itemKMenuTile;
    TDEConfigSkeleton::ItemColor *itemKMenuTileColor;
    TDEConfigSkeleton::ItemPath *itemDesktopButtonTile;
    TDEConfigSkeleton::ItemColor *itemDesktopButtonTileColor;
    TDEConfigSkeleton::ItemPath *itemURLTile;
    TDEConfigSkeleton::ItemColor *itemURLTileColor;
    TDEConfigSkeleton::ItemPath *itemBrowserTile;
    TDEConfigSkeleton::ItemColor *itemBrowserTileColor;
    TDEConfigSkeleton::ItemPath *itemWindowListTile;
    TDEConfigSkeleton::ItemColor *itemWindowListTileColor;
    TDEConfigSkeleton::ItemBool *itemUseSidePixmap;
    TDEConfigSkeleton::ItemBool *itemUseTooltip;
    TDEConfigSkeleton::ItemBool *itemUseSearchBar;
    TDEConfigSkeleton::ItemBool *itemUseTopSide;
    TDEConfigSkeleton::ItemString *itemLeftSideTopPixmapName;
    TDEConfigSkeleton::ItemString *itemRightSideTopPixmapName;
    TDEConfigSkeleton::ItemString *itemSideTopTileName;
    TDEConfigSkeleton::ItemString *itemSidePixmapName;
    TDEConfigSkeleton::ItemString *itemSideTileName;
    TDEConfigSkeleton::ItemBool *itemShowKMenuText;
    TDEConfigSkeleton::ItemString *itemKMenuText;
    TDEConfigSkeleton::ItemPath *itemCustomKMenuIcon;
    TDEConfigSkeleton::ItemString *itemSearchShortcut;
    TDEConfigSkeleton::ItemBool *itemShowMouseOverEffects;
    TDEConfigSkeleton::ItemBool *itemMouseOversShowIcon;
    TDEConfigSkeleton::ItemBool *itemMouseOversShowText;
    TDEConfigSkeleton::ItemInt *itemMouseOversSpeed;
    TDEConfigSkeleton::ItemUInt *itemMouseOversShowDelay;
    TDEConfigSkeleton::ItemUInt *itemMouseOversHideDelay;
    TDEConfigSkeleton::ItemBool *itemEnableTileBackground;
    TDEConfigSkeleton::ItemInt *itemIconMargin;
    TDEConfigSkeleton::ItemInt *itemMaximumTDEMenuButtonHeight;
    TDEConfigSkeleton::ItemBool *itemRemoveButtonsWhenBroken;
    TDEConfigSkeleton::ItemFont *itemButtonFont;
    TDEConfigSkeleton::ItemColor *itemButtonTextColor;
    TDEConfigSkeleton::ItemPathList *itemHistory;
    TDEConfigSkeleton::ItemInt *itemHistoryLength;
    TDEConfigSkeleton::ItemPathList *itemCompletionItems;
    TDEConfigSkeleton::ItemInt *itemCompletionMode;
};

KickerSettings *KickerSettings::mSelf = 0;
static KStaticDeleter<KickerSettings> staticKickerSettingsDeleter;

KickerSettings *KickerSettings::self()
{
  if (!mSelf)
     kdFatal() << "you need to call KickerSettings::instance before using" << endl;
  return mSelf;
}

void KickerSettings::instance(const char *cfgfilename)
{
  if (mSelf) {
     kdError() << "KickerSettings::instance called after the first use - ignoring" << endl;
     return;
  }
  staticKickerSettingsDeleter.setObject( mSelf, new KickerSettings(cfgfilename) );
  mSelf->readConfig();
}

KickerSettings::KickerSettings(  const char *config  )
  : TDEConfigSkeleton( config )
{
  d = new KickerSettingsPrivate;
  mSelf = this;
  setCurrentGroup( TQString::fromLatin1( "General" ) );

  d->itemLocked = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "Locked" ), d->locked, false );
  addItem( d->itemLocked, TQString::fromLatin1( "Locked" ) );
  d->itemConserveSpace = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ConserveSpace" ), d->conserveSpace, true );
  addItem( d->itemConserveSpace, TQString::fromLatin1( "ConserveSpace" ) );
  d->itemTransparent = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "Transparent" ), d->transparent, false );
  addItem( d->itemTransparent, TQString::fromLatin1( "Transparent" ) );
  d->itemUseResizeHandle = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseResizeHandle" ), d->useResizeHandle, false );
  addItem( d->itemUseResizeHandle, TQString::fromLatin1( "UseResizeHandle" ) );
  d->itemShowDeepButtons = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowDeepButtons" ), d->showDeepButtons, false );
  addItem( d->itemShowDeepButtons, TQString::fromLatin1( "ShowDeepButtons" ) );
  d->itemMenubarPanelTransparent = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "MenubarPanelTransparent" ), d->menubarPanelTransparent, false );
  addItem( d->itemMenubarPanelTransparent, TQString::fromLatin1( "MenubarPanelTransparent" ) );
  d->itemMenubarPanelBlurred = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "MenubarPanelBlurred" ), d->menubarPanelBlurred, false );
  addItem( d->itemMenubarPanelBlurred, TQString::fromLatin1( "MenubarPanelBlurred" ) );
  d->itemUseBackgroundTheme = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseBackgroundTheme" ), d->useBackgroundTheme, true );
  addItem( d->itemUseBackgroundTheme, TQString::fromLatin1( "UseBackgroundTheme" ) );
  d->itemColorizeBackground = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ColorizeBackground" ), d->colorizeBackground, false );
  addItem( d->itemColorizeBackground, TQString::fromLatin1( "ColorizeBackground" ) );
  d->itemRotateBackground = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "RotateBackground" ), d->rotateBackground, true );
  addItem( d->itemRotateBackground, TQString::fromLatin1( "RotateBackground" ) );
  d->itemBackgroundTheme = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "BackgroundTheme" ), d->backgroundTheme, TQString::fromLatin1( "wallpapers/default.png" ) );
  addItem( d->itemBackgroundTheme, TQString::fromLatin1( "BackgroundTheme" ) );
  d->itemTintValue = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "TintValue" ), d->tintValue, 33 );
  d->itemTintValue->setMinValue(0);
  d->itemTintValue->setMaxValue(100);
  addItem( d->itemTintValue, TQString::fromLatin1( "TintValue" ) );
  d->itemBlurValue = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "BlurValue" ), d->blurValue, 0 );
  d->itemBlurValue->setMinValue(0);
  d->itemBlurValue->setMaxValue(10);
  addItem( d->itemBlurValue, TQString::fromLatin1( "BlurValue" ) );
  d->itemTintColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "TintColor" ), d->tintColor, (TQApplication::palette().active().mid()) );
  addItem( d->itemTintColor, TQString::fromLatin1( "TintColor" ) );
  d->itemUnhideLocation = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "UnhideLocation" ), d->unhideLocation, 0 );
  addItem( d->itemUnhideLocation, TQString::fromLatin1( "UnhideLocation" ) );
  d->itemFadeOutAppletHandles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "FadeOutAppletHandles" ), d->fadeOutAppletHandles, true );
  addItem( d->itemFadeOutAppletHandles, TQString::fromLatin1( "FadeOutAppletHandles" ) );
  d->itemHideAppletHandles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "HideAppletHandles" ), d->hideAppletHandles, false );
  addItem( d->itemHideAppletHandles, TQString::fromLatin1( "HideAppletHandles" ) );
  d->itemShowToolTips = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowToolTips" ), d->showToolTips, true );
  addItem( d->itemShowToolTips, TQString::fromLatin1( "ShowToolTips" ) );
  d->itemShowIconActivationEffect = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowIconActivationEffect" ), d->showIconActivationEffect, true );
  addItem( d->itemShowIconActivationEffect, TQString::fromLatin1( "ShowIconActivationEffect" ) );
  d->itemUntrustedApplets = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "UntrustedApplets" ), d->untrustedApplets );
  addItem( d->itemUntrustedApplets, TQString::fromLatin1( "UntrustedApplets" ) );
  d->itemUntrustedExtensions = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "UntrustedExtensions" ), d->untrustedExtensions );
  addItem( d->itemUntrustedExtensions, TQString::fromLatin1( "UntrustedExtensions" ) );
  d->itemLegacyKMenu = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "LegacyKMenu" ), d->legacyKMenu, true );
  addItem( d->itemLegacyKMenu, TQString::fromLatin1( "LegacyKMenu" ) );
  d->itemOpenOnHover = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "OpenOnHover" ), d->openOnHover, true );
  addItem( d->itemOpenOnHover, TQString::fromLatin1( "OpenOnHover" ) );
  d->itemScrollFlipView = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ScrollFlipView" ), d->scrollFlipView, true );
  addItem( d->itemScrollFlipView, TQString::fromLatin1( "ScrollFlipView" ) );
  d->itemKMenuWidth = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "KMenuWidth" ), d->kMenuWidth, 0 );
  addItem( d->itemKMenuWidth, TQString::fromLatin1( "KMenuWidth" ) );
  d->itemKMenuHeight = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "KMenuHeight" ), d->kMenuHeight, 0 );
  addItem( d->itemKMenuHeight, TQString::fromLatin1( "KMenuHeight" ) );
  d->itemKickoffFontPointSizeOffset = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "KickoffFontPointSizeOffset" ), d->kickoffFontPointSizeOffset, 0 );
  d->itemKickoffFontPointSizeOffset->setMinValue(-100);
  d->itemKickoffFontPointSizeOffset->setMaxValue(100);
  addItem( d->itemKickoffFontPointSizeOffset, TQString::fromLatin1( "KickoffFontPointSizeOffset" ) );
  d->itemKickoffSearchAddressBook = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "KickoffSearchAddressBook" ), d->kickoffSearchAddressBook, false );
  addItem( d->itemKickoffSearchAddressBook, TQString::fromLatin1( "KickoffSearchAddressBook" ) );
  d->itemKickoffDrawGeekoEye = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "KickoffDrawGeekoEye" ), d->kickoffDrawGeekoEye, false );
  addItem( d->itemKickoffDrawGeekoEye, TQString::fromLatin1( "KickoffDrawGeekoEye" ) );
  TQValueList<TDEConfigSkeleton::ItemEnum::Choice> valuesKickoffTabBarFormat;
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "LabelAndIcon" );
    valuesKickoffTabBarFormat.append( choice );
  }
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "LabelOnly" );
    valuesKickoffTabBarFormat.append( choice );
  }
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "IconOnly" );
    valuesKickoffTabBarFormat.append( choice );
  }
  d->itemKickoffTabBarFormat = new TDEConfigSkeleton::ItemEnum( currentGroup(), TQString::fromLatin1( "KickoffTabBarFormat" ), d->kickoffTabBarFormat, valuesKickoffTabBarFormat, LabelAndIcon );
  addItem( d->itemKickoffTabBarFormat, TQString::fromLatin1( "KickoffTabBarFormat" ) );
  d->itemKickoffSwitchTabsOnHover = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "KickoffSwitchTabsOnHover" ), d->kickoffSwitchTabsOnHover, true );
  addItem( d->itemKickoffSwitchTabsOnHover, TQString::fromLatin1( "KickoffSwitchTabsOnHover" ) );

  setCurrentGroup( TQString::fromLatin1( "menus" ) );

  TQValueList<TDEConfigSkeleton::ItemEnum::Choice> valuesMenuEntryFormat;
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "NameOnly" );
    valuesMenuEntryFormat.append( choice );
  }
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "NameAndDescription" );
    valuesMenuEntryFormat.append( choice );
  }
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "DescriptionOnly" );
    valuesMenuEntryFormat.append( choice );
  }
  {
    TDEConfigSkeleton::ItemEnum::Choice choice;
    choice.name = TQString::fromLatin1( "DescriptionAndName" );
    valuesMenuEntryFormat.append( choice );
  }
  d->itemMenuEntryFormat = new TDEConfigSkeleton::ItemEnum( currentGroup(), TQString::fromLatin1( "MenuEntryFormat" ), d->menuEntryFormat, valuesMenuEntryFormat, DescriptionAndName );
  addItem( d->itemMenuEntryFormat, TQString::fromLatin1( "MenuEntryFormat" ) );
  d->itemShowMenuTitles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowMenuTitles" ), d->showMenuTitles, true );
  addItem( d->itemShowMenuTitles, TQString::fromLatin1( "ShowMenuTitles" ) );
  d->itemReduceMenuDepth = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ReduceMenuDepth" ), d->reduceMenuDepth, false );
  addItem( d->itemReduceMenuDepth, TQString::fromLatin1( "ReduceMenuDepth" ) );
  d->itemMenuEntryHeight = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "MenuEntryHeight" ), d->menuEntryHeight, 0 );
  addItem( d->itemMenuEntryHeight, TQString::fromLatin1( "MenuEntryHeight" ) );
  d->itemShowHiddenFiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowHiddenFiles" ), d->showHiddenFiles, false );
  addItem( d->itemShowHiddenFiles, TQString::fromLatin1( "ShowHiddenFiles" ) );
  d->itemShowOpenInTerminal = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowOpenInTerminal" ), d->showOpenInTerminal, true );
  addItem( d->itemShowOpenInTerminal, TQString::fromLatin1( "ShowOpenInTerminal" ) );
  d->itemMaxEntries2 = new TDEConfigSkeleton::ItemUInt( currentGroup(), TQString::fromLatin1( "MaxEntries2" ), d->maxEntries2, 30 );
  d->itemMaxEntries2->setMinValue(1);
  addItem( d->itemMaxEntries2, TQString::fromLatin1( "MaxEntries2" ) );
  d->itemUseBookmarks = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseBookmarks" ), d->useBookmarks, false );
  addItem( d->itemUseBookmarks, TQString::fromLatin1( "UseBookmarks" ) );
  d->itemUseBrowser = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseBrowser" ), d->useBrowser, false );
  addItem( d->itemUseBrowser, TQString::fromLatin1( "UseBrowser" ) );
  TQStringList defaultMenuExtensions;
  defaultMenuExtensions.append( TQString::fromUtf8( "prefmenu.desktop" ) );
  defaultMenuExtensions.append( TQString::fromUtf8( "systemmenu.desktop" ) );

  d->itemMenuExtensions = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "Extensions" ), d->menuExtensions, defaultMenuExtensions );
  addItem( d->itemMenuExtensions, TQString::fromLatin1( "MenuExtensions" ) );
  d->itemRecentAppsStat = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "RecentAppsStat" ), d->recentAppsStat );
  addItem( d->itemRecentAppsStat, TQString::fromLatin1( "RecentAppsStat" ) );
  d->itemNumVisibleEntries = new TDEConfigSkeleton::ItemUInt( currentGroup(), TQString::fromLatin1( "NumVisibleEntries" ), d->numVisibleEntries, 5 );
  d->itemNumVisibleEntries->setMaxValue(100);
  addItem( d->itemNumVisibleEntries, TQString::fromLatin1( "NumVisibleEntries" ) );
  d->itemRecentVsOften = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "RecentVsOften" ), d->recentVsOften, false );
  addItem( d->itemRecentVsOften, TQString::fromLatin1( "RecentVsOften" ) );
  d->itemFavorites = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "Favorites" ), d->favorites );
  addItem( d->itemFavorites, TQString::fromLatin1( "Favorites" ) );
  d->itemFirstRun = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "FirstRun" ), d->firstRun, false );
  addItem( d->itemFirstRun, TQString::fromLatin1( "FirstRun" ) );
  d->itemFirstSeenApps = new TDEConfigSkeleton::ItemStringList( currentGroup(), TQString::fromLatin1( "FirstSeenApps" ), d->firstSeenApps );
  addItem( d->itemFirstSeenApps, TQString::fromLatin1( "FirstSeenApps" ) );

  setCurrentGroup( TQString::fromLatin1( "button_tiles" ) );

  d->itemEnableKMenuTiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableKMenuTiles" ), d->enableKMenuTiles, false );
  addItem( d->itemEnableKMenuTiles, TQString::fromLatin1( "EnableKMenuTiles" ) );
  d->itemEnableDesktopButtonTiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableDesktopButtonTiles" ), d->enableDesktopButtonTiles, false );
  addItem( d->itemEnableDesktopButtonTiles, TQString::fromLatin1( "EnableDesktopButtonTiles" ) );
  d->itemEnableURLTiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableURLTiles" ), d->enableURLTiles, false );
  addItem( d->itemEnableURLTiles, TQString::fromLatin1( "EnableURLTiles" ) );
  d->itemEnableBrowserTiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableBrowserTiles" ), d->enableBrowserTiles, false );
  addItem( d->itemEnableBrowserTiles, TQString::fromLatin1( "EnableBrowserTiles" ) );
  d->itemEnableWindowListTiles = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableWindowListTiles" ), d->enableWindowListTiles, false );
  addItem( d->itemEnableWindowListTiles, TQString::fromLatin1( "EnableWindowListTiles" ) );
  d->itemKMenuTile = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "KMenuTile" ), d->kMenuTile );
  addItem( d->itemKMenuTile, TQString::fromLatin1( "KMenuTile" ) );
  d->itemKMenuTileColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "KMenuTileColor" ), d->kMenuTileColor, TQColor() );
  addItem( d->itemKMenuTileColor, TQString::fromLatin1( "KMenuTileColor" ) );
  d->itemDesktopButtonTile = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "DesktopButtonTile" ), d->desktopButtonTile );
  addItem( d->itemDesktopButtonTile, TQString::fromLatin1( "DesktopButtonTile" ) );
  d->itemDesktopButtonTileColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "DesktopButtonTileColor" ), d->desktopButtonTileColor, TQColor() );
  addItem( d->itemDesktopButtonTileColor, TQString::fromLatin1( "DesktopButtonTileColor" ) );
  d->itemURLTile = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "URLTile" ), d->uRLTile );
  addItem( d->itemURLTile, TQString::fromLatin1( "URLTile" ) );
  d->itemURLTileColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "URLTileColor" ), d->uRLTileColor, TQColor() );
  addItem( d->itemURLTileColor, TQString::fromLatin1( "URLTileColor" ) );
  d->itemBrowserTile = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "BrowserTile" ), d->browserTile );
  addItem( d->itemBrowserTile, TQString::fromLatin1( "BrowserTile" ) );
  d->itemBrowserTileColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "BrowserTileColor" ), d->browserTileColor, TQColor() );
  addItem( d->itemBrowserTileColor, TQString::fromLatin1( "BrowserTileColor" ) );
  d->itemWindowListTile = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "WindowListTile" ), d->windowListTile );
  addItem( d->itemWindowListTile, TQString::fromLatin1( "WindowListTile" ) );
  d->itemWindowListTileColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "WindowListTileColor" ), d->windowListTileColor, TQColor() );
  addItem( d->itemWindowListTileColor, TQString::fromLatin1( "WindowListTileColor" ) );

  setCurrentGroup( TQString::fromLatin1( "KMenu" ) );

  d->itemUseSidePixmap = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseSidePixmap" ), d->useSidePixmap, true );
  addItem( d->itemUseSidePixmap, TQString::fromLatin1( "UseSidePixmap" ) );
  d->itemUseTooltip = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseTooltip" ), d->useTooltip, false );
  addItem( d->itemUseTooltip, TQString::fromLatin1( "UseTooltip" ) );
  d->itemUseSearchBar = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseSearchBar" ), d->useSearchBar, true );
  addItem( d->itemUseSearchBar, TQString::fromLatin1( "UseSearchBar" ) );
  d->itemUseTopSide = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "UseTopSide" ), d->useTopSide, false );
  addItem( d->itemUseTopSide, TQString::fromLatin1( "UseTopSide" ) );
  d->itemLeftSideTopPixmapName = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "LeftSideTopName" ), d->leftSideTopPixmapName, TQString::fromLatin1( "kside_top_left.png" ) );
  addItem( d->itemLeftSideTopPixmapName, TQString::fromLatin1( "LeftSideTopPixmapName" ) );
  d->itemRightSideTopPixmapName = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "RightSideTopName" ), d->rightSideTopPixmapName, TQString::fromLatin1( "kside_top_right.png" ) );
  addItem( d->itemRightSideTopPixmapName, TQString::fromLatin1( "RightSideTopPixmapName" ) );
  d->itemSideTopTileName = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "SideTopTileName" ), d->sideTopTileName, TQString::fromLatin1( "kside_top_tile.png" ) );
  addItem( d->itemSideTopTileName, TQString::fromLatin1( "SideTopTileName" ) );
  d->itemSidePixmapName = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "SideName" ), d->sidePixmapName, TQString::fromLatin1( "kside.png" ) );
  addItem( d->itemSidePixmapName, TQString::fromLatin1( "SidePixmapName" ) );
  d->itemSideTileName = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "SideTileName" ), d->sideTileName, TQString::fromLatin1( "kside_tile.png" ) );
  addItem( d->itemSideTileName, TQString::fromLatin1( "SideTileName" ) );
  d->itemShowKMenuText = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "ShowText" ), d->showKMenuText, false );
  addItem( d->itemShowKMenuText, TQString::fromLatin1( "ShowKMenuText" ) );
  d->itemKMenuText = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "Text" ), d->kMenuText, i18n("Applications") );
  addItem( d->itemKMenuText, TQString::fromLatin1( "KMenuText" ) );
  d->itemCustomKMenuIcon = new TDEConfigSkeleton::ItemPath( currentGroup(), TQString::fromLatin1( "CustomIcon" ), d->customKMenuIcon, TQString("kmenu") );
  addItem( d->itemCustomKMenuIcon, TQString::fromLatin1( "CustomKMenuIcon" ) );
  d->itemSearchShortcut = new TDEConfigSkeleton::ItemString( currentGroup(), TQString::fromLatin1( "SearchShortcut" ), d->searchShortcut, TQString::fromLatin1( "/" ) );
  addItem( d->itemSearchShortcut, TQString::fromLatin1( "SearchShortcut" ) );

  setCurrentGroup( TQString::fromLatin1( "buttons" ) );

  d->itemShowMouseOverEffects = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableIconZoom" ), d->showMouseOverEffects, true );
  addItem( d->itemShowMouseOverEffects, TQString::fromLatin1( "ShowMouseOverEffects" ) );
  d->itemMouseOversShowIcon = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "MouseOversShowIcon" ), d->mouseOversShowIcon, true );
  addItem( d->itemMouseOversShowIcon, TQString::fromLatin1( "MouseOversShowIcon" ) );
  d->itemMouseOversShowText = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "MouseOversShowText" ), d->mouseOversShowText, true );
  addItem( d->itemMouseOversShowText, TQString::fromLatin1( "MouseOversShowText" ) );
  d->itemMouseOversSpeed = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "MouseOversSpeed" ), d->mouseOversSpeed, 500 );
  d->itemMouseOversSpeed->setMinValue(0);
  addItem( d->itemMouseOversSpeed, TQString::fromLatin1( "MouseOversSpeed" ) );
  d->itemMouseOversShowDelay = new TDEConfigSkeleton::ItemUInt( currentGroup(), TQString::fromLatin1( "MouseOversShowDelay" ), d->mouseOversShowDelay, 500 );
  addItem( d->itemMouseOversShowDelay, TQString::fromLatin1( "MouseOversShowDelay" ) );
  d->itemMouseOversHideDelay = new TDEConfigSkeleton::ItemUInt( currentGroup(), TQString::fromLatin1( "MouseOversHideDelay" ), d->mouseOversHideDelay, 200 );
  addItem( d->itemMouseOversHideDelay, TQString::fromLatin1( "MouseOversHideDelay" ) );
  d->itemEnableTileBackground = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "EnableTileBackground" ), d->enableTileBackground, false );
  addItem( d->itemEnableTileBackground, TQString::fromLatin1( "EnableTileBackground" ) );
  d->itemIconMargin = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "IconMargin" ), d->iconMargin, 3 );
  addItem( d->itemIconMargin, TQString::fromLatin1( "IconMargin" ) );
  d->itemMaximumTDEMenuButtonHeight = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "MaximumTDEMenuButtonHeight" ), d->maximumTDEMenuButtonHeight, 30 );
  addItem( d->itemMaximumTDEMenuButtonHeight, TQString::fromLatin1( "MaximumTDEMenuButtonHeight" ) );
  d->itemRemoveButtonsWhenBroken = new TDEConfigSkeleton::ItemBool( currentGroup(), TQString::fromLatin1( "RemoveButtonsWhenBroken" ), d->removeButtonsWhenBroken, true );
  addItem( d->itemRemoveButtonsWhenBroken, TQString::fromLatin1( "RemoveButtonsWhenBroken" ) );
  d->itemButtonFont = new TDEConfigSkeleton::ItemFont( currentGroup(), TQString::fromLatin1( "Font" ), d->buttonFont, TDEGlobalSettings::generalFont() );
  addItem( d->itemButtonFont, TQString::fromLatin1( "ButtonFont" ) );
  d->itemButtonTextColor = new TDEConfigSkeleton::ItemColor( currentGroup(), TQString::fromLatin1( "TextColor" ), d->buttonTextColor, TDEGlobalSettings::textColor() );
  addItem( d->itemButtonTextColor, TQString::fromLatin1( "ButtonTextColor" ) );

  setCurrentGroup( TQString::fromLatin1( "SearchField" ) );

  d->itemHistory = new TDEConfigSkeleton::ItemPathList( currentGroup(), TQString::fromLatin1( "History" ), d->history );
  addItem( d->itemHistory, TQString::fromLatin1( "History" ) );
  d->itemHistoryLength = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "HistoryLength" ), d->historyLength, 50 );
  addItem( d->itemHistoryLength, TQString::fromLatin1( "HistoryLength" ) );
  d->itemCompletionItems = new TDEConfigSkeleton::ItemPathList( currentGroup(), TQString::fromLatin1( "CompletionItems" ), d->completionItems );
  addItem( d->itemCompletionItems, TQString::fromLatin1( "CompletionItems" ) );
  d->itemCompletionMode = new TDEConfigSkeleton::ItemInt( currentGroup(), TQString::fromLatin1( "CompletionMode" ), d->completionMode, 2 );
  addItem( d->itemCompletionMode, TQString::fromLatin1( "CompletionMode" ) );
}

void KickerSettings::setLocked( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "Locked" ) ))
        self()->d->locked = v;
}

bool KickerSettings::locked()
{
  return self()->d->locked;
}


void KickerSettings::setConserveSpace( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ConserveSpace" ) ))
        self()->d->conserveSpace = v;
}

bool KickerSettings::conserveSpace()
{
  return self()->d->conserveSpace;
}


void KickerSettings::setTransparent( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "Transparent" ) ))
        self()->d->transparent = v;
}

bool KickerSettings::transparent()
{
  return self()->d->transparent;
}


void KickerSettings::setUseResizeHandle( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseResizeHandle" ) ))
        self()->d->useResizeHandle = v;
}

bool KickerSettings::useResizeHandle()
{
  return self()->d->useResizeHandle;
}


void KickerSettings::setShowDeepButtons( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowDeepButtons" ) ))
        self()->d->showDeepButtons = v;
}

bool KickerSettings::showDeepButtons()
{
  return self()->d->showDeepButtons;
}


void KickerSettings::setMenubarPanelTransparent( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MenubarPanelTransparent" ) ))
        self()->d->menubarPanelTransparent = v;
}

bool KickerSettings::menubarPanelTransparent()
{
  return self()->d->menubarPanelTransparent;
}


void KickerSettings::setMenubarPanelBlurred( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MenubarPanelBlurred" ) ))
        self()->d->menubarPanelBlurred = v;
}

bool KickerSettings::menubarPanelBlurred()
{
  return self()->d->menubarPanelBlurred;
}


void KickerSettings::setUseBackgroundTheme( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseBackgroundTheme" ) ))
        self()->d->useBackgroundTheme = v;
}

bool KickerSettings::useBackgroundTheme()
{
  return self()->d->useBackgroundTheme;
}


void KickerSettings::setColorizeBackground( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ColorizeBackground" ) ))
        self()->d->colorizeBackground = v;
}

bool KickerSettings::colorizeBackground()
{
  return self()->d->colorizeBackground;
}


void KickerSettings::setRotateBackground( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "RotateBackground" ) ))
        self()->d->rotateBackground = v;
}

bool KickerSettings::rotateBackground()
{
  return self()->d->rotateBackground;
}


void KickerSettings::setBackgroundTheme( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "BackgroundTheme" ) ))
        self()->d->backgroundTheme = v;
}

TQString KickerSettings::backgroundTheme()
{
  return self()->d->backgroundTheme;
}


void KickerSettings::setTintValue( int v )
{
      if (v < 0)
      {
        kdDebug() << "setTintValue: value " << v << " is less than the minimum value of 0" << endl;
        v = 0;
      }

      if (v > 100)
      {
        kdDebug() << "setTintValue: value " << v << " is greater than the maximum value of 100" << endl;
        v = 100;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "TintValue" ) ))
        self()->d->tintValue = v;
}

int KickerSettings::tintValue()
{
  return self()->d->tintValue;
}


void KickerSettings::setBlurValue( int v )
{
      if (v < 0)
      {
        kdDebug() << "setBlurValue: value " << v << " is less than the minimum value of 0" << endl;
        v = 0;
      }

      if (v > 10)
      {
        kdDebug() << "setBlurValue: value " << v << " is greater than the maximum value of 10" << endl;
        v = 10;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "BlurValue" ) ))
        self()->d->blurValue = v;
}

int KickerSettings::blurValue()
{
  return self()->d->blurValue;
}


void KickerSettings::setTintColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "TintColor" ) ))
        self()->d->tintColor = v;
}

TQColor KickerSettings::tintColor()
{
  return self()->d->tintColor;
}


void KickerSettings::setUnhideLocation( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UnhideLocation" ) ))
        self()->d->unhideLocation = v;
}

int KickerSettings::unhideLocation()
{
  return self()->d->unhideLocation;
}


void KickerSettings::setFadeOutAppletHandles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "FadeOutAppletHandles" ) ))
        self()->d->fadeOutAppletHandles = v;
}

bool KickerSettings::fadeOutAppletHandles()
{
  return self()->d->fadeOutAppletHandles;
}


void KickerSettings::setHideAppletHandles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "HideAppletHandles" ) ))
        self()->d->hideAppletHandles = v;
}

bool KickerSettings::hideAppletHandles()
{
  return self()->d->hideAppletHandles;
}


void KickerSettings::setShowToolTips( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowToolTips" ) ))
        self()->d->showToolTips = v;
}

bool KickerSettings::showToolTips()
{
  return self()->d->showToolTips;
}


void KickerSettings::setShowIconActivationEffect( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowIconActivationEffect" ) ))
        self()->d->showIconActivationEffect = v;
}

bool KickerSettings::showIconActivationEffect()
{
  return self()->d->showIconActivationEffect;
}


void KickerSettings::setUntrustedApplets( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UntrustedApplets" ) ))
        self()->d->untrustedApplets = v;
}

TQStringList KickerSettings::untrustedApplets()
{
  return self()->d->untrustedApplets;
}


void KickerSettings::setUntrustedExtensions( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UntrustedExtensions" ) ))
        self()->d->untrustedExtensions = v;
}

TQStringList KickerSettings::untrustedExtensions()
{
  return self()->d->untrustedExtensions;
}


void KickerSettings::setLegacyKMenu( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "LegacyKMenu" ) ))
        self()->d->legacyKMenu = v;
}

bool KickerSettings::legacyKMenu()
{
  return self()->d->legacyKMenu;
}


void KickerSettings::setOpenOnHover( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "OpenOnHover" ) ))
        self()->d->openOnHover = v;
}

bool KickerSettings::openOnHover()
{
  return self()->d->openOnHover;
}


void KickerSettings::setScrollFlipView( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ScrollFlipView" ) ))
        self()->d->scrollFlipView = v;
}

bool KickerSettings::scrollFlipView()
{
  return self()->d->scrollFlipView;
}


void KickerSettings::setKMenuWidth( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KMenuWidth" ) ))
        self()->d->kMenuWidth = v;
}

int KickerSettings::kMenuWidth()
{
  return self()->d->kMenuWidth;
}


void KickerSettings::setKMenuHeight( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KMenuHeight" ) ))
        self()->d->kMenuHeight = v;
}

int KickerSettings::kMenuHeight()
{
  return self()->d->kMenuHeight;
}


void KickerSettings::setKickoffFontPointSizeOffset( int v )
{
      if (v < -100)
      {
        kdDebug() << "setKickoffFontPointSizeOffset: value " << v << " is less than the minimum value of -100" << endl;
        v = -100;
      }

      if (v > 100)
      {
        kdDebug() << "setKickoffFontPointSizeOffset: value " << v << " is greater than the maximum value of 100" << endl;
        v = 100;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "KickoffFontPointSizeOffset" ) ))
        self()->d->kickoffFontPointSizeOffset = v;
}

int KickerSettings::kickoffFontPointSizeOffset()
{
  return self()->d->kickoffFontPointSizeOffset;
}


void KickerSettings::setKickoffSearchAddressBook( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KickoffSearchAddressBook" ) ))
        self()->d->kickoffSearchAddressBook = v;
}

bool KickerSettings::kickoffSearchAddressBook()
{
  return self()->d->kickoffSearchAddressBook;
}


void KickerSettings::setKickoffDrawGeekoEye( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KickoffDrawGeekoEye" ) ))
        self()->d->kickoffDrawGeekoEye = v;
}

bool KickerSettings::kickoffDrawGeekoEye()
{
  return self()->d->kickoffDrawGeekoEye;
}


void KickerSettings::setKickoffTabBarFormat( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KickoffTabBarFormat" ) ))
        self()->d->kickoffTabBarFormat = v;
}

int KickerSettings::kickoffTabBarFormat()
{
  return self()->d->kickoffTabBarFormat;
}


void KickerSettings::setKickoffSwitchTabsOnHover( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KickoffSwitchTabsOnHover" ) ))
        self()->d->kickoffSwitchTabsOnHover = v;
}

bool KickerSettings::kickoffSwitchTabsOnHover()
{
  return self()->d->kickoffSwitchTabsOnHover;
}


void KickerSettings::setMenuEntryFormat( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MenuEntryFormat" ) ))
        self()->d->menuEntryFormat = v;
}

int KickerSettings::menuEntryFormat()
{
  return self()->d->menuEntryFormat;
}


void KickerSettings::setShowMenuTitles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowMenuTitles" ) ))
        self()->d->showMenuTitles = v;
}

bool KickerSettings::showMenuTitles()
{
  return self()->d->showMenuTitles;
}


void KickerSettings::setReduceMenuDepth( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ReduceMenuDepth" ) ))
        self()->d->reduceMenuDepth = v;
}

bool KickerSettings::reduceMenuDepth()
{
  return self()->d->reduceMenuDepth;
}


void KickerSettings::setMenuEntryHeight( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MenuEntryHeight" ) ))
        self()->d->menuEntryHeight = v;
}

int KickerSettings::menuEntryHeight()
{
  return self()->d->menuEntryHeight;
}


void KickerSettings::setShowHiddenFiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowHiddenFiles" ) ))
        self()->d->showHiddenFiles = v;
}

bool KickerSettings::showHiddenFiles()
{
  return self()->d->showHiddenFiles;
}


void KickerSettings::setShowOpenInTerminal( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowOpenInTerminal" ) ))
        self()->d->showOpenInTerminal = v;
}

bool KickerSettings::showOpenInTerminal()
{
  return self()->d->showOpenInTerminal;
}


void KickerSettings::setMaxEntries2( uint v )
{
      if (v < 1)
      {
        kdDebug() << "setMaxEntries2: value " << v << " is less than the minimum value of 1" << endl;
        v = 1;
      }
      if (!self()->isImmutable( TQString::fromLatin1( "MaxEntries2" ) ))
        self()->d->maxEntries2 = v;
}

uint KickerSettings::maxEntries2()
{
  return self()->d->maxEntries2;
}


void KickerSettings::setUseBookmarks( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseBookmarks" ) ))
        self()->d->useBookmarks = v;
}

bool KickerSettings::useBookmarks()
{
  return self()->d->useBookmarks;
}


void KickerSettings::setUseBrowser( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseBrowser" ) ))
        self()->d->useBrowser = v;
}

bool KickerSettings::useBrowser()
{
  return self()->d->useBrowser;
}


void KickerSettings::setMenuExtensions( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MenuExtensions" ) ))
        self()->d->menuExtensions = v;
}

TQStringList KickerSettings::menuExtensions()
{
  return self()->d->menuExtensions;
}


void KickerSettings::setRecentAppsStat( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "RecentAppsStat" ) ))
        self()->d->recentAppsStat = v;
}

TQStringList KickerSettings::recentAppsStat()
{
  return self()->d->recentAppsStat;
}


void KickerSettings::setNumVisibleEntries( uint v )
{

      if (v > 100)
      {
        kdDebug() << "setNumVisibleEntries: value " << v << " is greater than the maximum value of 100" << endl;
        v = 100;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "NumVisibleEntries" ) ))
        self()->d->numVisibleEntries = v;
}

uint KickerSettings::numVisibleEntries()
{
  return self()->d->numVisibleEntries;
}


void KickerSettings::setRecentVsOften( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "RecentVsOften" ) ))
        self()->d->recentVsOften = v;
}

bool KickerSettings::recentVsOften()
{
  return self()->d->recentVsOften;
}


void KickerSettings::setFavorites( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "Favorites" ) ))
        self()->d->favorites = v;
}

TQStringList KickerSettings::favorites()
{
  return self()->d->favorites;
}


void KickerSettings::setFirstRun( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "FirstRun" ) ))
        self()->d->firstRun = v;
}

bool KickerSettings::firstRun()
{
  return self()->d->firstRun;
}


void KickerSettings::setFirstSeenApps( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "FirstSeenApps" ) ))
        self()->d->firstSeenApps = v;
}

TQStringList KickerSettings::firstSeenApps()
{
  return self()->d->firstSeenApps;
}


void KickerSettings::setEnableKMenuTiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableKMenuTiles" ) ))
        self()->d->enableKMenuTiles = v;
}

bool KickerSettings::enableKMenuTiles()
{
  return self()->d->enableKMenuTiles;
}


void KickerSettings::setEnableDesktopButtonTiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableDesktopButtonTiles" ) ))
        self()->d->enableDesktopButtonTiles = v;
}

bool KickerSettings::enableDesktopButtonTiles()
{
  return self()->d->enableDesktopButtonTiles;
}


void KickerSettings::setEnableURLTiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableURLTiles" ) ))
        self()->d->enableURLTiles = v;
}

bool KickerSettings::enableURLTiles()
{
  return self()->d->enableURLTiles;
}


void KickerSettings::setEnableBrowserTiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableBrowserTiles" ) ))
        self()->d->enableBrowserTiles = v;
}

bool KickerSettings::enableBrowserTiles()
{
  return self()->d->enableBrowserTiles;
}


void KickerSettings::setEnableWindowListTiles( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableWindowListTiles" ) ))
        self()->d->enableWindowListTiles = v;
}

bool KickerSettings::enableWindowListTiles()
{
  return self()->d->enableWindowListTiles;
}


void KickerSettings::setKMenuTile( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KMenuTile" ) ))
        self()->d->kMenuTile = v;
}

TQString KickerSettings::kMenuTile()
{
  return self()->d->kMenuTile;
}


void KickerSettings::setKMenuTileColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KMenuTileColor" ) ))
        self()->d->kMenuTileColor = v;
}

TQColor KickerSettings::kMenuTileColor()
{
  return self()->d->kMenuTileColor;
}


void KickerSettings::setDesktopButtonTile( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "DesktopButtonTile" ) ))
        self()->d->desktopButtonTile = v;
}

TQString KickerSettings::desktopButtonTile()
{
  return self()->d->desktopButtonTile;
}


void KickerSettings::setDesktopButtonTileColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "DesktopButtonTileColor" ) ))
        self()->d->desktopButtonTileColor = v;
}

TQColor KickerSettings::desktopButtonTileColor()
{
  return self()->d->desktopButtonTileColor;
}


void KickerSettings::setURLTile( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "URLTile" ) ))
        self()->d->uRLTile = v;
}

TQString KickerSettings::uRLTile()
{
  return self()->d->uRLTile;
}


void KickerSettings::setURLTileColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "URLTileColor" ) ))
        self()->d->uRLTileColor = v;
}

TQColor KickerSettings::uRLTileColor()
{
  return self()->d->uRLTileColor;
}


void KickerSettings::setBrowserTile( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "BrowserTile" ) ))
        self()->d->browserTile = v;
}

TQString KickerSettings::browserTile()
{
  return self()->d->browserTile;
}


void KickerSettings::setBrowserTileColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "BrowserTileColor" ) ))
        self()->d->browserTileColor = v;
}

TQColor KickerSettings::browserTileColor()
{
  return self()->d->browserTileColor;
}


void KickerSettings::setWindowListTile( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "WindowListTile" ) ))
        self()->d->windowListTile = v;
}

TQString KickerSettings::windowListTile()
{
  return self()->d->windowListTile;
}


void KickerSettings::setWindowListTileColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "WindowListTileColor" ) ))
        self()->d->windowListTileColor = v;
}

TQColor KickerSettings::windowListTileColor()
{
  return self()->d->windowListTileColor;
}


void KickerSettings::setUseSidePixmap( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseSidePixmap" ) ))
        self()->d->useSidePixmap = v;
}

bool KickerSettings::useSidePixmap()
{
  return self()->d->useSidePixmap;
}


void KickerSettings::setUseTooltip( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseTooltip" ) ))
        self()->d->useTooltip = v;
}

bool KickerSettings::useTooltip()
{
  return self()->d->useTooltip;
}


void KickerSettings::setUseSearchBar( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseSearchBar" ) ))
        self()->d->useSearchBar = v;
}

bool KickerSettings::useSearchBar()
{
  return self()->d->useSearchBar;
}


void KickerSettings::setUseTopSide( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "UseTopSide" ) ))
        self()->d->useTopSide = v;
}

bool KickerSettings::useTopSide()
{
  return self()->d->useTopSide;
}


void KickerSettings::setLeftSideTopPixmapName( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "LeftSideTopPixmapName" ) ))
        self()->d->leftSideTopPixmapName = v;
}

TQString KickerSettings::leftSideTopPixmapName()
{
  return self()->d->leftSideTopPixmapName;
}


void KickerSettings::setRightSideTopPixmapName( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "RightSideTopPixmapName" ) ))
        self()->d->rightSideTopPixmapName = v;
}

TQString KickerSettings::rightSideTopPixmapName()
{
  return self()->d->rightSideTopPixmapName;
}


void KickerSettings::setSideTopTileName( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "SideTopTileName" ) ))
        self()->d->sideTopTileName = v;
}

TQString KickerSettings::sideTopTileName()
{
  return self()->d->sideTopTileName;
}


void KickerSettings::setSidePixmapName( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "SidePixmapName" ) ))
        self()->d->sidePixmapName = v;
}

TQString KickerSettings::sidePixmapName()
{
  return self()->d->sidePixmapName;
}


void KickerSettings::setSideTileName( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "SideTileName" ) ))
        self()->d->sideTileName = v;
}

TQString KickerSettings::sideTileName()
{
  return self()->d->sideTileName;
}


void KickerSettings::setShowKMenuText( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowKMenuText" ) ))
        self()->d->showKMenuText = v;
}

bool KickerSettings::showKMenuText()
{
  return self()->d->showKMenuText;
}


void KickerSettings::setKMenuText( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "KMenuText" ) ))
        self()->d->kMenuText = v;
}

TQString KickerSettings::kMenuText()
{
  return self()->d->kMenuText;
}


void KickerSettings::setCustomKMenuIcon( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "CustomKMenuIcon" ) ))
        self()->d->customKMenuIcon = v;
}

TQString KickerSettings::customKMenuIcon()
{
  return self()->d->customKMenuIcon;
}


void KickerSettings::setSearchShortcut( const TQString & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "SearchShortcut" ) ))
        self()->d->searchShortcut = v;
}

TQString KickerSettings::searchShortcut()
{
  return self()->d->searchShortcut;
}


void KickerSettings::setShowMouseOverEffects( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ShowMouseOverEffects" ) ))
        self()->d->showMouseOverEffects = v;
}

bool KickerSettings::showMouseOverEffects()
{
  return self()->d->showMouseOverEffects;
}


void KickerSettings::setMouseOversShowIcon( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MouseOversShowIcon" ) ))
        self()->d->mouseOversShowIcon = v;
}

bool KickerSettings::mouseOversShowIcon()
{
  return self()->d->mouseOversShowIcon;
}


void KickerSettings::setMouseOversShowText( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MouseOversShowText" ) ))
        self()->d->mouseOversShowText = v;
}

bool KickerSettings::mouseOversShowText()
{
  return self()->d->mouseOversShowText;
}


void KickerSettings::setMouseOversSpeed( int v )
{
      if (v < 0)
      {
        kdDebug() << "setMouseOversSpeed: value " << v << " is less than the minimum value of 0" << endl;
        v = 0;
      }
      if (!self()->isImmutable( TQString::fromLatin1( "MouseOversSpeed" ) ))
        self()->d->mouseOversSpeed = v;
}

int KickerSettings::mouseOversSpeed()
{
  return self()->d->mouseOversSpeed;
}


void KickerSettings::setMouseOversShowDelay( uint v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MouseOversShowDelay" ) ))
        self()->d->mouseOversShowDelay = v;
}

uint KickerSettings::mouseOversShowDelay()
{
  return self()->d->mouseOversShowDelay;
}


void KickerSettings::setMouseOversHideDelay( uint v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MouseOversHideDelay" ) ))
        self()->d->mouseOversHideDelay = v;
}

uint KickerSettings::mouseOversHideDelay()
{
  return self()->d->mouseOversHideDelay;
}


void KickerSettings::setEnableTileBackground( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "EnableTileBackground" ) ))
        self()->d->enableTileBackground = v;
}

bool KickerSettings::enableTileBackground()
{
  return self()->d->enableTileBackground;
}


void KickerSettings::setIconMargin( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "IconMargin" ) ))
        self()->d->iconMargin = v;
}

int KickerSettings::iconMargin()
{
  return self()->d->iconMargin;
}


void KickerSettings::setMaximumTDEMenuButtonHeight( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "MaximumTDEMenuButtonHeight" ) ))
        self()->d->maximumTDEMenuButtonHeight = v;
}

int KickerSettings::maximumTDEMenuButtonHeight()
{
  return self()->d->maximumTDEMenuButtonHeight;
}


void KickerSettings::setRemoveButtonsWhenBroken( bool v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "RemoveButtonsWhenBroken" ) ))
        self()->d->removeButtonsWhenBroken = v;
}

bool KickerSettings::removeButtonsWhenBroken()
{
  return self()->d->removeButtonsWhenBroken;
}


void KickerSettings::setButtonFont( const TQFont & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ButtonFont" ) ))
        self()->d->buttonFont = v;
}

TQFont KickerSettings::buttonFont()
{
  return self()->d->buttonFont;
}


void KickerSettings::setButtonTextColor( const TQColor & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "ButtonTextColor" ) ))
        self()->d->buttonTextColor = v;
}

TQColor KickerSettings::buttonTextColor()
{
  return self()->d->buttonTextColor;
}


void KickerSettings::setHistory( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "History" ) ))
        self()->d->history = v;
}

TQStringList KickerSettings::history()
{
  return self()->d->history;
}


void KickerSettings::setHistoryLength( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "HistoryLength" ) ))
        self()->d->historyLength = v;
}

int KickerSettings::historyLength()
{
  return self()->d->historyLength;
}


void KickerSettings::setCompletionItems( const TQStringList & v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "CompletionItems" ) ))
        self()->d->completionItems = v;
}

TQStringList KickerSettings::completionItems()
{
  return self()->d->completionItems;
}


void KickerSettings::setCompletionMode( int v )
{
      if (!self()->isImmutable( TQString::fromLatin1( "CompletionMode" ) ))
        self()->d->completionMode = v;
}

int KickerSettings::completionMode()
{
  return self()->d->completionMode;
}


KickerSettings::~KickerSettings()
{
  delete d;
  if ( mSelf == this )
    staticKickerSettingsDeleter.setObject( mSelf, 0, false );
}

