// File autogenerated

#if !defined(AGENT1INTERFACE_H_INCLUDED)
#define AGENT1INTERFACE_H_INCLUDED

// TQt includes
#include <tqmap.h>

// TQt D-Bus includes
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobject.h>

// forward declarations
class TQDomElement;
class TQString;
class TQT_DBusError;
class TQT_DBusObjectPath;

namespace org
{
namespace bluez
{

class Agent1Interface : public TQT_DBusObjectBase
{
public:
    virtual ~Agent1Interface() {}

    static void buildIntrospectionData(TQDomElement& interfaceElement);

    static const TQCString interface() { return TQCString("org.bluez.Agent1"); }

public:
    virtual void RequestPinCodeAsyncReply(int asyncCallId, const TQString& pincode);

    virtual void RequestPinCodeAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void DisplayPinCodeAsyncReply(int asyncCallId);

    virtual void DisplayPinCodeAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void RequestPasskeyAsyncReply(int asyncCallId, TQ_UINT32 passkey);

    virtual void RequestPasskeyAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void DisplayPasskeyAsyncReply(int asyncCallId);

    virtual void DisplayPasskeyAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void RequestConfirmationAsyncReply(int asyncCallId);

    virtual void RequestConfirmationAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void RequestAuthorizationAsyncReply(int asyncCallId);

    virtual void RequestAuthorizationAsyncError(int asyncCallId, const TQT_DBusError& error);

    virtual void AuthorizeServiceAsyncReply(int asyncCallId);

    virtual void AuthorizeServiceAsyncError(int asyncCallId, const TQT_DBusError& error);

protected:
    virtual bool Release(TQT_DBusError& error) = 0;

    virtual bool Cancel(TQT_DBusError& error) = 0;

    virtual void RequestPinCodeAsync(int asyncCallId, const TQT_DBusObjectPath& device) = 0;

    virtual void DisplayPinCodeAsync(int asyncCallId, const TQT_DBusObjectPath& device, const TQString& pincode) = 0;

    virtual void RequestPasskeyAsync(int asyncCallId, const TQT_DBusObjectPath& device) = 0;

    virtual void DisplayPasskeyAsync(int asyncCallId, const TQT_DBusObjectPath& device, TQ_UINT32 passkey, TQ_UINT16 entered) = 0;

    virtual void RequestConfirmationAsync(int asyncCallId, const TQT_DBusObjectPath& device, TQ_UINT32 passkey) = 0;

    virtual void RequestAuthorizationAsync(int asyncCallId, const TQT_DBusObjectPath& device) = 0;

    virtual void AuthorizeServiceAsync(int asyncCallId, const TQT_DBusObjectPath& device, const TQString& uuid) = 0;

protected: // implement sending replies
    virtual void handleMethodReply(const TQT_DBusMessage& reply) = 0;

protected: // usually no need to reimplement
    virtual bool handleMethodCall(const TQT_DBusMessage& message);

    TQT_DBusMessage callRelease(const TQT_DBusMessage& message);

    void callRequestPinCodeAsync(const TQT_DBusMessage& message);

    void callDisplayPinCodeAsync(const TQT_DBusMessage& message);

    void callRequestPasskeyAsync(const TQT_DBusMessage& message);

    void callDisplayPasskeyAsync(const TQT_DBusMessage& message);

    void callRequestConfirmationAsync(const TQT_DBusMessage& message);

    void callRequestAuthorizationAsync(const TQT_DBusMessage& message);

    void callAuthorizeServiceAsync(const TQT_DBusMessage& message);

    TQT_DBusMessage callCancel(const TQT_DBusMessage& message);

protected:
    TQMap<int, TQT_DBusMessage> m_asyncCalls;

}; // class Agent1Interface

}; // namespace bluez

}; // namespace org

#endif //AGENT1INTERFACE_H_INCLUDED

// End of File

