// File autogenerated

// declaration include
#include "healthmanager1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{

HealthManager1Proxy::HealthManager1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.HealthManager1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

HealthManager1Proxy::~HealthManager1Proxy()
{
    delete m_baseProxy;
}

void HealthManager1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool HealthManager1Proxy::CreateApplication(const TQMap< TQString, TQT_DBusVariant >& config, TQT_DBusObjectPath& application, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(config));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("CreateApplication", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    application = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    return true;
}

bool HealthManager1Proxy::DestroyApplication(const TQT_DBusObjectPath& application, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(application);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("DestroyApplication", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

}; // namespace bluez

}; // namespace org

#include "healthmanager1Proxy.moc"

// End of File

