//
// C++ Interface: creategettersetterconfiguration
//
// Description: 
//
//
// Author: Jonas Jacobi <j.jacobi@gmx.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CREATEGETTERSETTERCONFIGURATION_H
#define CREATEGETTERSETTERCONFIGURATION_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

class CppSupportPart;
class TQDomDocument;

/**
 * Class containing the settings for the creation of get/set methods for class attributes.
 * It contains several attributes:
 * - prefixGet is the prefix which is put in front of the attributename for the getmethod.
 * - prefixSet is the prefix which is put in front of the attributename for the setmethod.
 * - prefixVariable is a StringList containing prefixes which should be removed from the attributename
 *   when creating the get/set method names
 * - parameterName is the name of the parameter containing the value in the setmethod.
 * - inlineGet true if getmethod should be created inline, false otherwise
 * - inlineSet true if setmethod should be created inline, false otherwise
 * 
 * The settings are stored per project under /kdevcppsupport/creategettersetter/.
 * @author Jonas Jacobi <j.jacobi@gmx.de>
 */
class CreateGetterSetterConfiguration : public TQObject{
TQ_OBJECT
  
public:
    CreateGetterSetterConfiguration(CppSupportPart* part);
    ~CreateGetterSetterConfiguration();
	
public slots:
	void init();
	void store();

public:
	void setPrefixGet(const TQString& theValue)
	{
		m_prefixGet = theValue;
	}
	
	TQString prefixGet() const
	{
		return m_prefixGet;
	}
	void setPrefixSet(const TQString& theValue)
	{
		m_prefixSet = theValue;
	}
	
	TQString prefixSet() const
	{
		return m_prefixSet;
	}
	void setPrefixVariable(const TQStringList& theValue)
	{
		m_prefixVariable = theValue;
	}
	
	TQStringList prefixVariable() const
	{
		return m_prefixVariable;
	}
	void setParameterName(const TQString& theValue)
	{
		m_parameterName = theValue;
	}
	
	TQString parameterName() const
	{
		return m_parameterName;
	}
	void setInlineGet(bool theValue)
	{
		m_isInlineGet = theValue;
	}
	
	bool isInlineGet() const
	{
		return m_isInlineGet;
	}
	void setInlineSet(bool theValue)
	{
		m_isInlineSet = theValue;
	}
	
	bool isInlineSet() const
	{
		return m_isInlineSet;
	}
	
private:
	CppSupportPart* m_part;
	TQDomDocument* m_settings;
	
	TQString m_prefixGet;
	TQString m_prefixSet;
	TQStringList m_prefixVariable;
	TQString m_parameterName;
	bool m_isInlineGet;
	bool m_isInlineSet;
	
private:
	static TQString defaultPath;
};

#endif
