#ifndef __KDEVPART_SQLSUPPORT_H__
#define __KDEVPART_SQLSUPPORT_H__

#include <tqguardedptr.h>
#include <tqstringlist.h>

#include <kprocess.h>
#include <kdialogbase.h>

#include "kdevplugin.h"
#include "kdevlanguagesupport.h"

class SqlListAction;
class SqlOutputWidget;
class CodeModel;

class SQLSupportPart : public KDevLanguageSupport
{
  TQ_OBJECT
  

public:

    SQLSupportPart(TQObject *parent, const char *name, const TQStringList &);
    virtual ~SQLSupportPart();

    static TQString cryptStr(const TQString& aStr);
    const TQStringList& connections() const { return conNames; }


protected:
    virtual Features features();
    virtual KMimeType::List mimeTypes();

private slots:
    void slotRun();
    void projectConfigWidget(KDialogBase *dlg);
    void projectOpened();
    void projectClosed();
    void savedFile(const KURL &fileName);
    void addedFilesToProject(const TQStringList &fileList);
    void removedFilesFromProject(const TQStringList &fileList);
    void parse();
    void loadConfig();
    void activeConnectionChanged();

private:
    void clearConfig();
    void updateCatalog();
    SqlListAction* dbAction;
    SqlOutputWidget* m_widget;
    TQStringList conNames;
    CodeModel *m_store;
};

#endif
