/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//BibleTime includes
#include "creadwindow.h"

#include "backend/centrydisplay.h"
#include "backend/cdisplayrendering.h"
#include "backend/cswordkey.h"

#include "frontend/cbtconfig.h"
#include "frontend/cexportmanager.h"
#include "frontend/cmdiarea.h"
#include "frontend/cprofilewindow.h"
#include "frontend/displaywindow/cmodulechooserbar.h"
#include "frontend/keychooser/ckeychooser.h"
#include "frontend/searchdialog/csearchdialog.h"

#include "util/cresmgr.h"

//TDE includes
#include <tdepopupmenu.h>
#include <tdeaction.h>
#include <tdeaccel.h>
#include <tdestdaccel.h>
#include <tdelocale.h>

using namespace Profile;

CReadWindow::CReadWindow(ListCSwordModuleInfo modules, CMDIArea* parent, const char *name )
: CDisplayWindow(modules,parent,name),
m_displayWidget(0) {

	//   installEventFilter(this);
}

CReadWindow::~CReadWindow() {
	//  tqWarning("destructor of CReadWindow");
}

/** Returns the display widget of this window. */
CReadDisplay* const CReadWindow::displayWidget() {
	return m_displayWidget;
}

/** Sets the display widget of this display window. */
void CReadWindow::setDisplayWidget( CReadDisplay* newDisplay ) {
	CDisplayWindow::setDisplayWidget(newDisplay);
	if (m_displayWidget) {
		disconnect(m_displayWidget->connectionsProxy(), TQ_SIGNAL(referenceClicked(const TQString&, const TQString&)), this, TQ_SLOT(lookup(const TQString&, const TQString&)));

		disconnect(m_displayWidget->connectionsProxy(), TQ_SIGNAL(referenceDropped(const TQString&)), this, TQ_SLOT(lookup(const TQString&)));
	}

	m_displayWidget = newDisplay;
	connect(
		m_displayWidget->connectionsProxy(),
		TQ_SIGNAL(referenceClicked(const TQString&, const TQString&)),
		this,
		TQ_SLOT(lookup(const TQString&, const TQString&))
	);

	connect(
		m_displayWidget->connectionsProxy(),
		TQ_SIGNAL(referenceDropped(const TQString&)),
		this,
		TQ_SLOT(lookup(const TQString&))
	);
}

/** Lookup the given entry. */
void CReadWindow::lookup( CSwordKey* newKey ) {
	Q_ASSERT(newKey);

	using namespace Rendering;

	Q_ASSERT(isReady() && newKey && modules().first());
	if (!isReady() || !newKey || !modules().first()) {
		return;
	}

	Q_ASSERT(modules().first()->getDisplay());
	CEntryDisplay* display = modules().first()->getDisplay();
	if (display) { //do we have a display object?
		displayWidget()->setText(
			display->text(
				modules(),
				newKey->key(),
				displayOptions(),
				filterOptions()
			)
		);
	}

	if (key() != newKey) {
		key()->key(newKey->key());
	}

	setCaption( windowCaption() );

	//  tqDebug("[CReadWindow::lookup] Moving to anchor %s", CDisplayRendering::keyToHTMLAnchor(key()->key()).latin1());

	displayWidget()->moveToAnchor( CDisplayRendering::keyToHTMLAnchor(key()->key()) );
}

/** Store the settings of this window in the given CProfileWindow object. */
void CReadWindow::storeProfileSettings(CProfileWindow * const settings) {
	TQRect rect;
	rect.setX(parentWidget()->x());
	rect.setY(parentWidget()->y());
	rect.setWidth(width());
	rect.setHeight(height());
	settings->setGeometry(rect);

	// settings->setScrollbarPositions( m_htmlWidget->view()->horizontalScrollBar()->value(), m_htmlWidget->view()->verticalScrollBar()->value() );
	settings->setType(modules().first()->type());
	settings->setMaximized(isMaximized() || parentWidget()->isMaximized());
	settings->setFocus( (this == mdi()->activeWindow()) ); //set property to true if this window is the active one.

	if (key()) {
		sword::VerseKey* vk = dynamic_cast<sword::VerseKey*>(key());
		TQString oldLang;
		if (vk) {
			oldLang = TQString(vk->getLocale());
			vk->setLocale("en"); //save english locale names as default!
		}
		settings->setKey( key()->key() );
		if (vk) {
			vk->setLocale(oldLang.latin1());
		}
	}

	TQStringList mods;

	ListCSwordModuleInfo allMods = modules();
	ListCSwordModuleInfo::iterator end_it = allMods.end();
	for (ListCSwordModuleInfo::iterator it(allMods.begin()); it != end_it; ++it) {
		mods.append((*it)->name());
	}
	settings->setModules(mods);
}

void CReadWindow::applyProfileSettings(CProfileWindow * const settings) {
	//  parentWidget()->setUpdatesEnabled(false);
	setUpdatesEnabled(false);

	if (settings->maximized()) { //maximize this window
		// Use parentWidget() to call showMaximized. Otherwise we'd get lot's of X11 errors
		parentWidget()->showMaximized();
	}
	else {
		const TQRect rect = settings->geometry();
		resize(rect.width(), rect.height());
		parentWidget()->move(rect.x(), rect.y());
	}

	setUpdatesEnabled(true);
}

void CReadWindow::insertKeyboardActions( TDEActionCollection* const ) {}

/** No descriptions */
void CReadWindow::copyDisplayedText() {
	CExportManager mgr(TQString::null);
	mgr.copyKey(key(), CExportManager::Text, true);
}


/*!
    \fn CReadWindow::resizeEvent(TQResizeEvent* e)
 */
void CReadWindow::resizeEvent(TQResizeEvent* /*e*/) {
	displayWidget()->moveToAnchor(
		Rendering::CDisplayRendering::keyToHTMLAnchor(key()->key())
	);
}

void CReadWindow::openSearchStrongsDialog() {
//	tqWarning("looking for lemma %s",  displayWidget()->getCurrentNodeInfo()[CDisplay::Lemma].latin1() );
	TQString searchText = TQString();
	
	if (displayWidget()->getCurrentNodeInfo()[CDisplay::Lemma] != TQString()) {
		searchText.append("strong:").append(displayWidget()->getCurrentNodeInfo() [CDisplay::Lemma]);
	}
	
	Search::CSearchDialog::openDialog( modules(), searchText, 0 );
}

#include "creadwindow.moc"
