/*********
*
* This file is part of BibleTime's source code, http://www.bibletime.info/.
*
* Copyright 1999-2006 by the BibleTime developers.
* The BibleTime source code is licensed under the GNU General Public License version 2.0.
*
**********/



//TQt includes
#include <tqstring.h>
#include <tqpixmap.h>
#include <tqtextstream.h>


#ifndef CTOOLCLASS_H
#define CTOOLCLASS_H


class CSwordModuleInfo;
class TQLabel;

/**
 * Provides some useful functions which would be normally global.
 *
 * Some methods,that would be normaly global, but I hate global functions :-)
 * (the function locateHTML is from Sandy Meier (KDevelop))
 *
 * @short A class which contains static members to do small things.
 * @author Joachim Ansorg <info@bibletime.info>
 */
class CToolClass {
public:
	/**
	 * @return The path of the HTML file "filename". This function searches only in $TDEDIR.
	 * @author Sandy Meier of the KDevelop team.
	 */
	static TQString locatehtml(const TQString &filename);
	/**
	 * Converts HTML text to plain text.
	 * This function converts some HTML tags in text (e.g. <BR> to \n)
	 * @return The text withput HTML tags and with converted <BR> to \n
	 * @author Joachim Ansorg  
	 */
	static TQString htmlToText(const TQString&);
	/**
	* Converts text to HTML converting some text commands into HTML tags (e.g. \n to <BR>)
	* @return The HTML formatted text we got after changing \n to <BR>
	* @author Joachim Ansorg
	*/
	static TQString textToHTML(const TQString&);
	/**
	* Creates the file filename and put the text of parameter "text" into the file.
	* @return True if saving was sucessful, otherwise false
	* @author Joachim Ansorg
	*/
	static bool savePlainFile( const TQString& filename, const TQString& text, const bool& forceOverwrite = false, const TQTextStream::Encoding& fileEncoding = TQTextStream::Locale);
	/**
	* Returns the icon used for the module given as aparameter.
	*/
	static TQPixmap getIconForModule( CSwordModuleInfo* );
	/** Returns a label to explain difficult things of dialogs.
	* This function returns a label with heading "heading" and explanation "text". This label should be used to
	* explain difficult things of the GUI, e.g. in the optionsdialog.
	*/
	static TQLabel* explanationLabel(TQWidget* parent, const TQString& heading, const TQString& text );
	/**
	* Returns true if the character at position "pos" of text is inside an HTML tag. Returns false if it's not inside an HTML tag.
	*/
	static bool inHTMLTag(int pos, TQString & text);
	/** Return the module's tooltip text
	* @param module The module required for the toolip
	* @return The tooltip text for the passed module
	*/
	static TQString moduleToolTip(CSwordModuleInfo* module);
};

#endif
