/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-05-02
 * Description : a widget to perform month selection.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef MONTHWIDGET_H
#define MONTHWIDGET_H

// TQt includes.

#include <tqframe.h>

// Local includes.

#include "imageinfo.h"

namespace Digikam
{
class MonthWidgetPriv;

class MonthWidget : public TQFrame
{
    TQ_OBJECT

public:

    MonthWidget(TQWidget* parent);
    ~MonthWidget();

    void setYearMonth(int year, int month);
    TQSize sizeHint() const;

    void setActive(bool val);

protected:

    void resizeEvent(TQResizeEvent *e);
    void drawContents(TQPainter *p);
    void mousePressEvent(TQMouseEvent *e);

private:

    void init();

private slots:

    void slotAddItems(const ImageInfoList& items);
    void slotDeleteItem(ImageInfo* item);

private:

    MonthWidgetPriv *d;
};

}  // namespace Digikam

#endif /* MONTHWIDGET_H */
