/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "config.h"

#include "kbfxtooltip.h"

KbfxToolTip::KbfxToolTip ( TQWidget * parent, const char *name, WFlags fl ) :
		TQWidget ( parent, name,
		          fl | WStyle_Customize | WRepaintNoErase | WStyle_NoBorder |
		          WDestructiveClose | TQt::WPaintDesktop | TQt::WType_Popup | TQt::
		          WPaintClever | TQt::WNoAutoErase | TQt::WResizeNoErase | TQt::
		          WStaticContents | TQt::WNoAutoErase )
{
	_animate = ConfigInit ().m_ToolTipAnimation;
	m_fontTooltipFont = ConfigInit ().m_fontTooltipFont;

	logo = ( KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit().m_SpinxTooltipLogo ) ) ?
		TQImage ( ConfigInit().m_SpinxTooltipLogo )
		: TQImage ( ConfigInit().m_SpinxTooltipLogoDefault );

	tooltip_win = ( KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit ().m_SpinxTooltipWindow ) ) ?
		TQImage ( ConfigInit ().m_SpinxTooltipWindow )
		: TQImage ( ConfigInit ().m_SpinxTooltipWindowDefault );

	tooltip_mask = ( KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit().m_SpinxTooltipMask ) ) ?
		TQImage ( ConfigInit().m_SpinxTooltipMask )
		: TQImage ( ConfigInit().m_SpinxTooltipMaskDefault );

	dude_img = ( KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit ().m_SpinxDudeImage ) ) ?
		TQImage ( ConfigInit ().m_SpinxDudeImage )
		: TQImage ( ConfigInit ().m_SpinxDudeImageDefault );

	setUserImage ();
	setBoundBox ();
	setBackground ( TQPixmap () );
	setWindow ( TQPixmap () );
	KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit ().m_ToolTipAvatar ) ?
		setAnimationImage ( ConfigInit ().m_ToolTipAvatar )
		: setAnimationImage ( ConfigInit ().m_ToolTipAvatarDefault );

	_hide_timer = new TQTimer ( this );
	_update_timer = new TQTimer ( this );
	_move_timer = new TQTimer ( this );

	connect ( _hide_timer, TQ_SIGNAL ( timeout () ), this, TQ_SLOT ( hide () ) );
	connect ( _hide_timer, TQ_SIGNAL ( timeout () ), _agent, TQ_SLOT ( hide () ) );
	connect ( _update_timer, TQ_SIGNAL ( timeout () ), this, TQ_SLOT ( logoMove () ) );

	TQCursor kbfxCursor;
	kbfxCursor.setShape ( TQt::PointingHandCursor );
	this->setCursor ( ( const TQCursor ) kbfxCursor );
}

KbfxToolTip::~KbfxToolTip ()
{
	delete _hide_timer;
	delete _move_timer;
	delete _update_timer;
	delete _window;
	delete _agent;
	delete _agent_anim;
}

void
KbfxToolTip::setWindow ( TQPixmap win )
{
	TQImage m_win_img;

	( win.isNull () ) ?
		m_win_img = tooltip_win
		: m_win_img = win.convertToImage ();

	m_win_img = m_win_img.smoothScale ( _bg.width (), 13 );
//  _window = new TQLabel (this, "", TQt::WStaticContents | TQt::WNoAutoErase);
	_window = new TQLabel ( this, "" );
	_window->resize ( _bg.width (), 13 );
	TQPixmap pm;
	pm.convertFromImage(m_win_img);
	_window->setBackgroundPixmap ( pm );
	if ( _animate )
		_window->show ();
	else
		_window->hide ();
}

void
KbfxToolTip::setAnimationImage ( TQString path )
{
	/*
	  _agent = new TQLabel (this, "",
			       TQt::WStaticContents |
			       TQt::WNoAutoErase | TQt::WPaintDesktop);
	*/
	_agent = new TQLabel ( this,"" );
	_agent->resize ( 100, 100 );

	_agent_anim = new TQMovie ( path );
	TQPixmap agent_mask = _agent_anim->framePixmap ();
	_agent->setBackgroundPixmap ( agent_mask );
	if ( agent_mask.mask () )
		_agent->setMask ( *agent_mask.mask () );
	_agent->repaint ();

	/*FIXME:Need to remove Hard Coded Values */
	_agent->move ( 200, 0 );

	if ( _animate )
		_agent->show ();
	else
		_agent->close ();
}


void
KbfxToolTip::setBackground ( TQPixmap bg )
{

	( bg.isNull () ) ?
		_bg = tooltip_mask
		: _bg = bg.convertToImage ();

	/* animation check : Auto streatch */
	if ( _animate )
	{
		TQImage m_tmp = _bg;
		_bg = m_tmp.smoothScale ( _bg.width () + 100, _bg.height () );
	}

	TQPixmap pm;
	pm.convertFromImage(_bg);
	this->setBackgroundPixmap ( pm );

	TQPixmap m_tmp ( _bg );
	if ( m_tmp.mask () )
		this->setMask ( ( *m_tmp.mask () ) );
	this->resize ( _bg.width (), _bg.height () );
	_maxW = _bg.width ();
}

void
KbfxToolTip::setStartPos ( int _x_, int _y_ )
{
	_x = _x_;
	_y = _y_;
	_logo_move_x = 100;
	if ( _animate )
	{
		_logo_move_x = 0;
		_hide_timer->start ( 10000, true );
		_move_timer->start ( _agent_anim->speed (), false );
		_update_timer->start ( 2, false );
	}

	move ( _x, _y );
}

void
KbfxToolTip::logoMove ()
{
	TQPainter p;

	if ( _logo_move_x < _bg.width () - 68 )
	{
		_logo_move_x += 1;
		_window->repaint ();

		p.begin ( _window );
		p.drawPixmap ( TQRect ( _logo_move_x, 0, logo.width (), logo.height () ),
		               TQPixmap ( logo ) );
		p.end ();
	}
	else
	{
		p.begin ( _window );
		p.drawPixmap ( TQRect ( _bg.width () - 68, 0, logo.width (), logo.height () ),
		               TQPixmap ( logo ) );
		p.end ();
	}

	TQPixmap agent_mask = _agent_anim->framePixmap ();
	_agent->setBackgroundPixmap ( agent_mask );
	if ( agent_mask.mask () )
		_agent->setMask ( *agent_mask.mask () );
	_agent->repaint ();
}

void
KbfxToolTip::setAnimated ( bool b )
{
	_animate = b;
}


void
KbfxToolTip::setLabelText ( TQString str )
{
	_label_text = str;
}

void
KbfxToolTip::setHeadingText ( TQString str )
{
	_heading_text = str;
}

void
KbfxToolTip::setVersionText ( TQString str )
{
	_version_text = str;
}

void
KbfxToolTip::hideToolTip ()
{
	_move_timer->stop ();
	_hide_timer->stop ();

	_agent->close ();
	this->hide ();
	this->close ();
}


void
KbfxToolTip::setUserImage ()
{
	TQImage userimage = dude_img;
	userimage = userimage.smoothScale ( 48, 48 );
	_dude = TQPixmap ( userimage );
}

void
KbfxToolTip::setBoundBox ()
{
	_dude_box = ( KbfxPlasmaPixmapProvider::PixmapPathCheck ( ConfigInit ().m_SpinxTooltipDudebox ) ) ?
		TQPixmap ( ConfigInit ().m_SpinxTooltipDudebox )
		: TQPixmap ( ConfigInit ().m_SpinxTooltipDudeboxDefault );
}


void
KbfxToolTip::paintEvent ( TQPaintEvent * pe )
{

	const TQRect r = pe->rect ();
	TQFont *let = new TQFont (m_fontTooltipFont);

	TQPainter p;
	p.begin ( this );
	p.setBackgroundMode ( TQt::TransparentMode );
	p.drawPixmap ( TQRect ( 7, 16, _dude_box.width (), _dude_box.height () ),
	               _dude_box );
	int _paddingX = ( ( _dude_box.height () - _dude.height () ) / 2 ) + 16;
	p.drawPixmap ( TQRect
	               ( _paddingX - ( 55 - 48 ), _paddingX, _dude.width (),
	                 _dude.height () ), _dude );

	if ( _animate )
	{}
	else
	{

		p.drawPixmap ( TQRect ( 126, 0, logo.width (), logo.height () ),
		               TQPixmap ( TQImage (ConfigInit ().m_SpinxTooltipLogo ) ) );
	}

	let->setBold ( true );
	let->setPointSize ( 10 );
	p.setFont ( *let );
	p.setPen ( TQColor ( 61, 94, 129 ) );
	p.drawText ( _dude_box.width () + 15, 30, TQString("KBFX") );

	p.setPen ( TQColor ( 0, 0, 0 ) );
	let->setBold ( false );
	let->setPointSize ( 8 );
	p.setFont ( *let );
	p.drawText ( ( _animate ) ? _dude_box.width () + 50 : _dude_box.width () + 4,
	             _dude_box.height () + 30, TQString ( "Version " ).append ( APPLICATION_VERSION ) );

	p.setPen ( ConfigInit ().m_fontTooltipColor );
	let->setBold ( true );
	let->setPointSize ( 8 );
	p.setFont ( *let );


	p.drawText ( _dude_box.width () + 15, 43, ConfigInit ().m_ToolTipText );
	p.end ();
	delete let;
}

#include "kbfxtooltip.moc"
